/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

#if !defined(AFX_GETPREFS_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_GETPREFS_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

void CompatGetPrefs(void);
	// get the CVSROOT, authentication, and misc options...

#ifdef WIN32
#include "Authen.h"

class CGetPrefs_CVSROOT : public CPropertyPage
{
	DECLARE_DYNCREATE(CGetPrefs_CVSROOT)

// Construction
public:
	CGetPrefs_CVSROOT();
	~CGetPrefs_CVSROOT();

	void StoreValues();

	// Dialog Data
	//{{AFX_DATA(CGetPrefs_CVSROOT)
	enum { IDD = IDD_PREFS_CVSROOT };
	CComboBox	m_combovers;
	CComboBox	m_comboauthen;
	CComboBox	m_ctrlroot;
	CString		m_cvsroot;
	int			m_cvsvers;
	AuthenKind	m_authen;
	CString	m_host;
	CString	m_login;
	CString	m_path;
	BOOL		m_cvsconsole;
	//}}AFX_DATA

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CGetPrefs_CVSROOT)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	bool m_didInteract;
	bool m_flag;

	void FillFields(void);
	void OnChangeFields(void);

	// Generated message map functions
	//{{AFX_MSG(CGetPrefs_CVSROOT)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeAuthen();
	afx_msg void OnChangePath();
	afx_msg void OnChangeHost();
	afx_msg void OnChangeLogin();
	afx_msg void OnSettings();
	afx_msg void OnSelchangeComboroot();
	afx_msg void OnEditchangeComboroot();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CGetPrefs_GLOBALS : public CPropertyPage
{
	DECLARE_DYNCREATE(CGetPrefs_GLOBALS)

// Construction
public:
	CGetPrefs_GLOBALS();
	~CGetPrefs_GLOBALS();

	void StoreValues();

// Dialog Data
	//{{AFX_DATA(CGetPrefs_GLOBALS)
	enum { IDD = IDD_PREFS_GLOBALS };
	CSpinButtonCtrl	m_zspin;
	CSpinButtonCtrl	m_spin;
	BOOL	m_checkoutro;
	BOOL	m_prune;
	BOOL	m_tcpip;
	BOOL	m_quiet;
	BOOL	m_cntladd;
	BOOL	m_dirty;
	BOOL	m_alwaysroot;
	BOOL	m_logout;
	UINT	m_editlogout;
	BOOL	m_unixlf;
	UINT	m_zlevel;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CGetPrefs_GLOBALS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	bool m_didInteract;

	// Generated message map functions
	//{{AFX_MSG(CGetPrefs_GLOBALS)
	afx_msg void OnLogout();
	afx_msg void OnCheckunixlf();
	afx_msg void OnTcpip();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CGetPrefs_WINCVS : public CPropertyPage
{
	DECLARE_DYNCREATE(CGetPrefs_WINCVS)

// Construction
public:
	CGetPrefs_WINCVS();
	~CGetPrefs_WINCVS();

	void StoreValues();

// Dialog Data
	//{{AFX_DATA(CGetPrefs_WINCVS)
	enum { IDD = IDD_PREFS_WINCVS };
	CString	m_viewer;
	CString	m_diffprog;
	BOOL	m_chkdiff;
	CString	m_home;
	BOOL	m_chkUseViewerAlways;
	BOOL	m_cvschk;
	CString	m_cvsprog;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CGetPrefs_WINCVS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	bool m_didInteract;

	// Generated message map functions
	//{{AFX_MSG(CGetPrefs_WINCVS)
	afx_msg void OnBtnviewer();
	afx_msg void OnExtdiffsel();
	afx_msg void OnExtdiff();
	afx_msg void OnBtnhome();
	afx_msg void OnAltcvschk();
	afx_msg void OnAltcvssel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class CGetPrefs_CVSCMD_DIALOGS : public CPropertyPage
{
	DECLARE_DYNCREATE(CGetPrefs_CVSCMD_DIALOGS)

// Construction
public:
	CGetPrefs_CVSCMD_DIALOGS();
	~CGetPrefs_CVSCMD_DIALOGS();

	void StoreValues();

// Dialog Data
	//{{AFX_DATA(CGetPrefs_CVSCMD_DIALOGS)
	enum { IDD = IDD_PREFS_CVSCMD_DIALOGS };
	BOOL	m_hideUpdate;
	BOOL	m_hideDiff;
	BOOL	m_hideGraph;
	BOOL	m_hideLog;
	int		m_keyForce;
	BOOL	m_hideAnnotate;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CGetPrefs_CVSCMD_DIALOGS)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	bool m_didInteract;

	// Generated message map functions
	//{{AFX_MSG(CGetPrefs_CVSCMD_DIALOGS)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif /* WIN32 */

#endif // !defined(AFX_GETPREFS_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
