/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

// wincvs.h : main header file for the WINCVS application
//

#if !defined(AFX_WINCVS_H__D2D77DC7_8299_11D1_8949_444553540000__INCLUDED_)
#define AFX_WINCVS_H__D2D77DC7_8299_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "MultiString.h"

/////////////////////////////////////////////////////////////////////////////
// CWincvsApp:
// See wincvs.cpp for the implementation of this class
//

class CWincvsView;
class CWinCvsBrowser;
class CBrowseFileView;
class CStr;
class CMainFrame;
class CStatusBar;
class KiFilterModel;
class KiRecursionModel;
class KiIgnoreModel;

class CWincvsApp : public CWinApp
{
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	CWincvsApp();

	CWincvsView *GetConsoleView(void);
		// get the top console

	CWinCvsBrowser *GetBrowserView(void);
	void ActivateBrowserView(void);
		// get the left directory browser

	CCJShellTree *GetExplorerView(void);
		// get the left directory explorer

	CBrowseFileView *GetFileView(void);
		// get the right files browser

	CDocument *GetDocument(void);
		// get the document

	CStatusBar *GetStatusBar();
		// get the mainframe status bar

    CString GetRoot();
        // returns currently selected root

	inline CMainFrame *GetMainFrame(void) { return m_mainFrame; }
		// get the document

	bool gCvsRunning;
		// the dll is running

	bool gCvsStopping;
		// the dll is about to stop

	int gLastCvsResult;
		// last know exit() return value of cvs

	CMultiDocTemplate* gLogTempl;
	CMultiDocTemplate* gLogGraph;
	CMultiDocTemplate* gLogHtml;

	void UpdateAllDocsView();
		// call UpdateAllViews for all documents

	struct _CvsProcess *gCvsProcess;
		// the current cvs process

	void GetAppPath(CStr & path) const;
		// return the application path

	void GetAppModule(CStr & module) const;
		// return the application module

	bool GetAppVersion(CStr & vers) const;
		// return false if an error occured

	inline DWORD GetIdleTime(void) const { return m_idletime; }
	inline void ResetIdleTime(void) { m_idletime = 0; }

	// in order to get an idea of where is cvs
	void IdleCvsProgress(void);
    
	// retrieve filtering model to use
	KiFilterModel* GetFilterModel() const;

	// retrieve recursion model to use
	KiRecursionModel* GetRecursionModel() const;

	// ignore model in use
	KiIgnoreModel* GetIgnoreModel() const;

	// ask a GetEnv value from the main thread for those
	// which require interaction (ex: CVS_GETPASS)
	char *GetEnvMainThread(const char *name);
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWincvsApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	virtual BOOL SaveAllModified();
	//}}AFX_VIRTUAL

	bool m_isBackgroundProcess;
		// tells if the app is in background

protected:
	BOOL InitATL();
	void LookForResourceFile(const char *what, CStr & path);

	afx_msg void OnFileNew();

	DWORD m_idletime;
	CMainFrame *m_mainFrame;
	BOOL m_bATLInited;

// Implementation
	COleTemplateServer m_server;
		// Server object for document creation

	//{{AFX_MSG(CWincvsApp)
	afx_msg void OnAppAbout();
	afx_msg void OnAppCopyrights();
	afx_msg void OnAppCredits();
	afx_msg void OnLogWindowIsPresent(CCmdUI* pCmdUI);
	afx_msg void OnHelpCvs();
	afx_msg void OnHelpCvsclient();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void ShowTipAtStartup(void);
private:
	void ShowTipOfTheDay(void);
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

void AFXAPI DDV_MinChars(CDataExchange* pDX, CString const& value, int nChars);
void AFXAPI DDV_CheckCVSROOT(CDataExchange* pDX, CString& strValue);
void AFXAPI DDX_ComboMString(CDataExchange* pDX, int nIDC,
							 CMString & mstr, CComboBox & combo);

#endif // !defined(AFX_WINCVS_H__D2D77DC7_8299_11D1_8949_444553540000__INCLUDED_)
