/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- June 2001
 */

/*
 * AnnotateDlg.h : the cvs annotate dialog
 */

#if !defined(AFX_ANNOTATEDLG_H__864729EE_838B_473D_8723_E1269829F781__INCLUDED_)
#define AFX_ANNOTATEDLG_H__864729EE_838B_473D_8723_E1269829F781__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CPStr.h"
#include "MultiString.h"

bool CompatGetAnnotate(bool & noRecurs, bool & isDate, CPStr & rev, bool & force);
	// get the annotate options...

extern CMString gRevNames;
extern CMString gDateNames;
	// persistent default values for the dates, tags...

#ifdef WIN32

/////////////////////////////////////////////////////////////////////////////
// CAnnotate_MAIN dialog

class CAnnotate_MAIN : public CPropertyPage
{
	DECLARE_DYNCREATE(CAnnotate_MAIN)

// Construction
public:
	CAnnotate_MAIN(const char *rev, bool isDate);
	CAnnotate_MAIN();
	~CAnnotate_MAIN();

// Dialog Data
	//{{AFX_DATA(CAnnotate_MAIN)
	enum { IDD = IDD_ANNOTATE_MAIN };
	CComboBox	m_revCombo;
	BOOL	m_hasRev;
	BOOL	m_isDate;
	BOOL	m_force;
	BOOL	m_noRecurse;
	CString	m_strRev;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CAnnotate_MAIN)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CAnnotate_MAIN)
	afx_msg void OnSpecifyRev();
	afx_msg void OnIsdate();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_ANNOTATEDLG_H__864729EE_838B_473D_8723_E1269829F781__INCLUDED_)
