/* yesno.c -- read a yes/no response from stdin
   Copyright (C) 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

#ifdef CVSGUI_SHL
#	include <string.h>
#endif /* CVSGUI_SHL */

/* Read one line from standard input
   and return nonzero if that line begins with y or Y,
   otherwise return 0. */

int
yesno ()
{
  int c;
  int rv;

#ifdef CVSGUI_SHL
	char *response;

	printf("\n");
	dllglue_flushconsole();
	response = getenv("CVSLIB_YESNO");
	if(response != 0L)
		return strcmp(response, "yes") == 0;
#endif /* CVSGUI_SHL */

  fflush (stderr);
  fflush (stdout);
  c = getchar ();
  rv = (c == 'y') || (c == 'Y');
  while (c != EOF && c != '\n')
    c = getchar ();

  return rv;
}
