/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * dll_process.h --- allow to simulate a process using the dll mechanism
 */

#ifndef DLL_PROCESS_H
#define DLL_PROCESS_H

#ifdef macintosh
#	include <CodeFragments.h>
#	include <Events.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if defined(macintosh) && !TARGET_API_MAC_CARBON
	enum {
		uppGetEnvProcInfo = kCStackBased
			| RESULT_SIZE(SIZE_CODE(sizeof(char *)))
			| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(char *)))
	};

	enum {
		uppConsoleOutProcInfo = kCStackBased
			| RESULT_SIZE(SIZE_CODE(sizeof(long)))
			| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(char *)))
			| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
	};

	enum {
		uppConsoleInProcInfo = kCStackBased
			| RESULT_SIZE(SIZE_CODE(sizeof(long)))
			| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(char *)))
			| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
	};

	enum {
		uppMainProcInfo = kCStackBased
			| RESULT_SIZE(SIZE_CODE(sizeof(int)))
			| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(char *)))
			| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(int)))
			| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(char **)))
	};

	enum {
		uppSetGlueProcInfo = kCStackBased
			| RESULT_SIZE(SIZE_CODE(sizeof(int)))
			| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(UniversalProcPtr)))
	};

	enum {
		uppEventDispatchProcInfo = kCStackBased
			| RESULT_SIZE(SIZE_CODE(sizeof(int)))
			| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(void */*EventRecord **/)))
	};
#else /* !macintosh || TARGET_API_MAC_CARBON */
	typedef char * (*dllglue_getenv_func) (const char *);
	typedef long (*dllglue_consoleout_func) (char *, long);
	typedef long (*dllglue_consolein_func) (char *, long);
	typedef int (*dllglue_main_func) (const char *, int, char**);
	typedef int (*dllglue_setglue_func) (void *);
#	if TARGET_API_MAC_CARBON
	typedef int (*dllglue_eventdispath_func) (EventRecord *);
#	endif
#endif /* !macintosh || TARGET_API_MAC_CARBON */

#ifdef __cplusplus
}
#endif

#endif /* DLL_PROCESS_H */
