/* LIBGIMP - The GIMP Library                                                   
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball                
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.             
 *                                                                              
 * This library is distributed in the hope that it will be useful,              
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */                                                                             

/*
 * gimpprotocol.h modified for the cvsgui project by :
 * Alexandre Parenteau <aubonbeurre@hotmail.com> --- January 2000
 */

#ifndef CVSGUI_PROTOCOL_H
#define CVSGUI_PROTOCOL_H

#include "cvsgui_wire.h"

enum {
	GP_QUIT,
	GP_GETENV,
	GP_CONSOLE
};

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	gint32 code;
} GPT_QUIT;

typedef struct
{
	guint8 empty;
	char *str;
} GPT_GETENV;

typedef struct
{
	guint8 isStderr;
	guint32 len;
	char *str;
} GPT_CONSOLE;

int  gp_quit_write (int fd, int code);
int  gp_getenv_write (int fd, const char *env);
int  gp_console_write (int fd, const char *str, int len, int isStderr);
char *gp_getenv_read (int fd);

#ifdef __cplusplus
}
#endif

#endif /* CVSGUI_PROTOCOL_H */
