#ifndef __MODEL__H__
#define __MODEL__H__

// forward references 
class EntnodeData;

// notification handler
template <class TObserver>
class NotificationManager
{
// used types
public:
	typedef void (TObserver::*NotificationHandler)();
	// handler that observer registers to be called to get notification

private:
	// node describing observer registration
	struct Node
	{
		TObserver* observer;  
		// observer

		NotificationHandler handler; 
		// its notification handler

		// default constructor just zeroes everything
		Node()
		: observer(NULL), handler(NULL)
		{}

		// full-blown construction
		Node(TObserver* o, NotificationHandler h)
		: observer(o), handler(h)
		{}

	};

// Attributes
private:
	std::vector<Node> m_nodes;
	
// Construction
public:
	NotificationManager(int size = 4)
	: m_nodes(size)
	{}

// Operations
public:
	// register an observer
	void CheckIn(TObserver* observer, NotificationHandler handler)
	{
		std::vector<Node>::const_iterator i;
		for (i = m_nodes.begin(); i != m_nodes.end(); i++)
		{
			Node& node = m_nodes[i - m_nodes.begin()];
			if (!node.observer)
			{
				node.observer = observer;
				node.handler = handler;
				return;
			}
		}
		m_nodes.push_back(Node(observer, handler));
	}

	// unregister an observer
	void CheckOut(TObserver* observer)
	{
		for (std::vector<Node>::const_iterator i = m_nodes.begin(); i != m_nodes.end(); i++)
		{
			Node& node = m_nodes[i - m_nodes.begin()];
			if (node.observer == observer)
			{
				node.observer = 0;
			}
		}
	}

	// fire up a notification once done with changes in observable
	void NotifyAll()
	{
		for (std::vector<Node>::const_iterator i = m_nodes.begin(); i != m_nodes.end(); i++)
		{
			// make a local copy so that observers can freely unregister during the process
			Node node = m_nodes[i - m_nodes.begin()];
			if (node.observer)
			{
				(node.observer->*node.handler)();
			}
		}
	}

};

// use this to cast to proper notification handler
typedef void (CObject::*FNOBSERVER)();

// interface to filtering entries
class KiFilterModel
{
// Interfaces
public:
	// checks to see if an item satisfies current filtering criteria
	virtual bool IsMatch(EntnodeData* data) = 0;

	// retrieves notification manager for observing changes in the 
	virtual NotificationManager<CObject>* GetNotificationManager() = 0;
};

// interface to recursive display of entries
class KiRecursionModel
{
// Interfaces
public:
	// returns true if displaying files recursively
	virtual bool IsShowRecursive() = 0;

	// retrieves notification manager for observing changes in the 
	virtual NotificationManager<CObject>* GetNotificationManager() = 0;
};

// interface to recursive display of entries
class KiIgnoreModel
{
// Interfaces
public:
	// returns true if displaying ignored files
	virtual bool IsShowIgnored() = 0;

	// retrieves notification manager for observing changes in the 
	virtual NotificationManager<CObject>* GetNotificationManager() = 0;
};

#endif 
// __MODEL__H__

