// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__D2D77DCC_8299_11D1_8949_444553540000__INCLUDED_)
#define AFX_MAINFRM_H__D2D77DCC_8299_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ConsoleBar.h"
#include "CvsStatusBar.h"
#include "model.h"
#include "ToolbarCombo.h"

// interface to filtering entries
class KoFilterModel : public KiFilterModel
{
// Attributes
protected:
	NotificationManager<CObject> m_manager; // manager for filter change notifications
	CString m_mask;			 // current file mask
	std::vector<CStr> m_match;  // itemized array of file masks to display as found
	bool m_isChanged;		// flag to tell if only changed files are to be displayed
	bool m_isAdded;			// flag to tell if only added files are to be displayed
	bool m_isRemoved;		// flag to tell if only removed files are to be displayed
	bool m_isConflicts;		// flag to tell if conflicting files shall be displayed

	bool m_isUnknown;		// flag to tell if unknown files have to be shown
	bool m_isHideUnknown;	// flag to tell if unknown files have to be hidden, mutually 
							// exclusive with above
	bool m_isMissing;		// flag to tell if missing files have to be shown

// Construction
public:
	KoFilterModel();
	~KoFilterModel();

// Interfaces
public:
	// checks to see if an item satisfies current filtering criteria
	virtual bool IsMatch(EntnodeData* data);

	// retrieves notification manager for observing changes in the 
	virtual NotificationManager<CObject>* GetNotificationManager();

// Operations
public:
	// tells if the filter is in default mode - fo show flags are set
	bool IsDefaultMode() const;

	// toggles modified flag
	void ToggleModified();

	//accessor for modified flag
	bool IsModified() const;

	// sets new file mask, returns true if changed
	bool SetMask(const CString& mask);

	// toggles show conflict flag
	void ToggleConflict()
	{
		m_isConflicts = !m_isConflicts;
	}

	//accessor for show conflict flag
	bool IsConflict() const
	{
		return m_isConflicts;
	}

	// toggles show conflict flag
	void ToggleUnknown();

	//accessor for show unknown flag
	bool IsUnknown() const
	{
		return m_isUnknown;
	}

	// toggles hide unknown flag
	void ToggleHideUnknown();

	//accessor for hide unknown flag
	bool IsHideUnknown() const
	{
		return m_isHideUnknown;
	}


	// toggles show conflict flag
	void ToggleMissing()
	{
		m_isMissing = !m_isMissing;
	}

	//accessor for show unknown flag
	bool IsMissing() const
	{
		return m_isMissing;
	}

	void ToggleChanged()
	{
		m_isChanged = !m_isChanged;
	}

	bool IsChanged() const
	{
		return m_isChanged;
	}

	void ToggleAdded()
	{
		m_isAdded = !m_isAdded;
	}

	bool IsAdded() const
	{
		return m_isAdded;
	}

	void ToggleRemoved()
	{
		m_isRemoved = !m_isRemoved;
	}

	bool IsRemoved() const
	{
		return m_isRemoved;
	}
};

// interface to recursive display of entries
class KoRecursionModel : public KiRecursionModel
{
	NotificationManager<CObject> m_manager; 
	// manager for change notifications

	bool m_isRecursive;		
	// flag to tell if files in subfolders shall be iterated
// Construction
public:
	KoRecursionModel();
	~KoRecursionModel();

// Interfaces
public:
	// returns true if displaying files recursively
	virtual bool IsShowRecursive();

	// retrieves notification manager for observing changes in the 
	virtual NotificationManager<CObject>* GetNotificationManager();

	// toggle recursion switch
	void ToggleRecursion();

};

// interface to r\ecursive display of entries
class KoIgnoreModel : public KiIgnoreModel
{
	NotificationManager<CObject> m_manager; 
	// manager for change notifications

	bool m_isIgnore;
	// flag to tell if ignored files are displayed

// Construction
public:
	KoIgnoreModel();
	~KoIgnoreModel();

// Interfaces
public:
	// returns true if displaying ignored files
	virtual bool IsShowIgnored();

	// retrieves notification manager for observing changes in the 
	virtual NotificationManager<CObject>* GetNotificationManager();

	// toggle recursion switch
	void ToggleIgnore();
};


class CMainFrame : public CCJMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();
#if 0
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)
#endif

// Attributes
protected:
	 KoFilterModel m_filter;
	 KoRecursionModel m_recursion;
	 KoIgnoreModel m_ignore;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	void DropFiles(HDROP hDropInfo);
	void InitialShowWindow(int nCmdShow);
	virtual ~CMainFrame();

	CWinCvsBrowser *GetBrowserView();
	CCJShellTree *GetExplorerView();
	inline CCJTabCtrlBar *GetWorkspace() { return &m_wndWorkspace; }
	inline CMDIMenuList & GetMenuList(void) { return m_menuList; }

	inline CWincvsView *GetConsoleView() { return m_consolebar.m_view; }
	inline CComboBox & GetBrowseHistory(void) { return m_browseHist; }
	inline CStatusBar *GetStatusBar() { return &m_wndStatusBar; }

	BOOL OnBroadcastCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
		// take care about the cmd msg routing on the dock bars

	// KiFilterModel implementation
	KiFilterModel* GetFilterModel()
	{
		return &m_filter;
	}

	// KiRecursionModel implementation
	KiRecursionModel* GetRecursionModel()
	{
		return &m_recursion;
	}

	// KiRecursionModel implementation
	KiIgnoreModel* GetIgnoreModel()
	{
		return &m_ignore;
	}


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CCvsStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;
	CToolBar    m_wndBrowser;
	CToolBar    m_wndMultiUser;
	CToolBar    m_wndTags;
	CToolBar    m_wndList;
	CToolBar    m_wndFilter;
	CComboBox	m_browseHist;
	CToolbarCombo m_comboFilterMask;
	CFont		m_fontNormal;
	CBarConsole	m_consolebar;
	CCJTabCtrlBar	m_wndWorkspace;
	CImageList	m_TabImages;
	CCJWindowPlacement	m_state;

	BOOL InitializeDockingWindows();
	void OnFilterMaskEntered();

// Generated message map functions
protected:
	afx_msg void OnInitMenu(CMenu* pMenu);
	void DockControlBarLeftOf(CToolBar* Bar,CToolBar* LeftOf);
	bool FreshenFileMask();

	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnHistorySelect();
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnViewRecursive();
	afx_msg void OnViewModified();
	afx_msg void OnUpdateViewModified(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRecursive(CCmdUI* pCmdUI);
	afx_msg void OnViewConflict();
	afx_msg void OnUpdateViewConflict(CCmdUI* pCmdUI);
	afx_msg void OnViewUnknown();
	afx_msg void OnUpdateViewUnknown(CCmdUI* pCmdUI);
	afx_msg void OnViewMissing();
	afx_msg void OnUpdateViewMissing(CCmdUI* pCmdUI);
	afx_msg void OnViewIgnore();
	afx_msg void OnUpdateViewIgnore(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilterMask(CCmdUI* pCmdUI);
	afx_msg void OnUpdateHistory(CCmdUI* pCmdUI);
	afx_msg void OnViewAdded();
	afx_msg void OnUpdateViewAdded(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRemoved(CCmdUI* pCmdUI);
	afx_msg void OnViewRemoved();
	afx_msg void OnViewChanged();
	afx_msg void OnUpdateViewChanged(CCmdUI* pCmdUI);
	afx_msg void OnViewHideunknown();
	afx_msg void OnUpdateViewHideunknown(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL m_bRestoreFocus;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__D2D77DCC_8299_11D1_8949_444553540000__INCLUDED_)
