/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined(AFX_GRAPHVIEW_H__7A07C311_03F9_11D2_BCB2_000000000000__INCLUDED_)
#define AFX_GRAPHVIEW_H__7A07C311_03F9_11D2_BCB2_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// GraphView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CGraphView view

class CGraphView : public CScrollView
{
protected:
	CGraphView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CGraphView)

// Attributes
public:
	void CalcImageSize(void);
		// calculate the size of the graph and set the scroll bars

	static inline CImageList & GetImgList(void) { return m_ImageList; }

	// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGraphView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnInitialUpdate();     // first time after construct
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
protected:

	bool fFirstTime;
	static CImageList m_ImageList;

	int m_numberOfPages;
	int m_pageHeight;
		// for printing

	bool CGraphView::DisableCommon();

	virtual ~CGraphView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CGraphView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnViewReload();
	afx_msg void OnUpdateViewReload(CCmdUI* pCmdUI);
	afx_msg void OnViewDiff();
	afx_msg void OnUpdateViewDiff(CCmdUI* pCmdUI);
	afx_msg void OnViewUpdate();
	afx_msg void OnUpdateViewUpdate(CCmdUI* pCmdUI);
	afx_msg void OnViewTag();
	afx_msg void OnUpdateViewTag(CCmdUI* pCmdUI);
	afx_msg void OnViewDelrev();
	afx_msg void OnUpdateViewDelrev(CCmdUI* pCmdUI);
	afx_msg void OnViewSelnonsig();
	afx_msg void OnUpdateViewSelnonsig(CCmdUI* pCmdUI);
	afx_msg void OnViewRetrieve();
	afx_msg void OnUpdateViewRetrieve(CCmdUI* pCmdUI);
	afx_msg void DisableUpdate(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GRAPHVIEW_H__7A07C311_03F9_11D2_BCB2_000000000000__INCLUDED_)
