#include <process.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <windows.h>

/*
 * This little dos command allows to redirect the input/output/error
 * stream of another dos command. It is provided as a work around
 * of a possible Windows bug.
 *
 * Theory : it's not possible to use anonymous pipe from a MFC application
 * to a dos command : usually it uses the SetStdHandle call to give
 * the child its console IO. But it works only for Dos->Dos program.
 *
 * So this application get the stdin from a file, intercept the IO's
 * from a sub-process then save the output/error back in a file :
 *
 * Usage : dospipe stdinfile stdoutfile stderrfile doscmd ?arg ?arg...
 * Return : the exit code of the child command
 */

static FILE *fromIn = 0L, *toOut = 0L, *toErr = 0L;

/*************************************************************/
/* Creates the child process and redirects its std.IO handles*/
/*************************************************************/
HANDLE
ForkChildProcess(          // Creates a new process
    char *cmd,             // Redirects its stdin,stdout
    PHANDLE inH,           // and stderr - returns the
    PHANDLE outH,          // corresponding pipe ends.
    PHANDLE errH
    )
{
	SECURITY_ATTRIBUTES lsa;
	STARTUPINFO         si;
	PROCESS_INFORMATION pi;

	HANDLE ChildIn, ChildOut, ChildErr;
	HANDLE oldIn, oldOut, oldErr;
	HANDLE dupIn, dupOut, dupErr;

	ChildIn = ChildOut = ChildErr = 0L;
	dupIn = dupOut = dupErr = 0L;
	*inH = *outH = *errH = 0;

	lsa.nLength=sizeof(SECURITY_ATTRIBUTES);
	lsa.lpSecurityDescriptor=NULL;
	lsa.bInheritHandle=TRUE;

	//
	//Create Parent_Write to ChildStdIn Pipe
	//

	if (!CreatePipe(&ChildIn,&dupIn,&lsa,0))
	{
		fprintf(toErr, "Could Not Create Parent-->Child Pipe (error %d)\n", GetLastError());
		goto error;
	}

	//
	//Create ChildStdOut to Parent_Read pipe
	//

	if (!CreatePipe(&dupOut,&ChildOut,&lsa,0))
	{
		fprintf(toErr, "Could Not Create Child-->Parent Pipe (error %d)\n", GetLastError());
		goto error;
	}

	//
	//Create ChildStdOut to Parent_Read pipe
	//

	if (!CreatePipe(&dupErr,&ChildErr, &lsa,0))
	{
		fprintf(toErr, "Could Not Create Child-->Parent Pipe (error %d)\n", GetLastError());
		goto error;
	}

	if(!DuplicateHandle(GetCurrentProcess(), dupIn,
        GetCurrentProcess(), inH, 0, FALSE, DUPLICATE_SAME_ACCESS))
			goto error;
	CloseHandle(dupIn);
	dupIn = 0;
	if(!DuplicateHandle(GetCurrentProcess(), dupOut,
        GetCurrentProcess(), outH, 0, FALSE, DUPLICATE_SAME_ACCESS))
			goto error;
	CloseHandle(dupOut);
	dupOut = 0;
	if(!DuplicateHandle(GetCurrentProcess(), dupErr,
        GetCurrentProcess(), errH, 0, FALSE, DUPLICATE_SAME_ACCESS))
			goto error;
	CloseHandle(dupErr);
	dupErr = 0;

	//
	// Lets Redirect Console StdHandles - easy enough
	//


	memset(&si,0,sizeof(STARTUPINFO));
	si.cb=sizeof(STARTUPINFO);
	si.dwFlags=0/*STARTF_USESTDHANDLES*/;
	si.hStdInput =ChildIn;
	si.hStdOutput=ChildOut;
	si.hStdError =ChildErr;

	//
	//Create Child Process
	//

	oldIn = GetStdHandle(STD_INPUT_HANDLE);
	oldOut = GetStdHandle(STD_OUTPUT_HANDLE);
	oldErr = GetStdHandle(STD_ERROR_HANDLE);
	SetStdHandle(STD_INPUT_HANDLE, ChildIn);
	SetStdHandle(STD_OUTPUT_HANDLE, ChildOut);
	SetStdHandle(STD_ERROR_HANDLE, ChildErr);

	if (!CreateProcess
		 (
			NULL,
			cmd,
			NULL,
			NULL,
			TRUE,
			NORMAL_PRIORITY_CLASS,
			NULL,
			NULL,
			&si,
			&pi)
		 )
	{
		if (GetLastError()==2)
			fprintf(toErr, "Executable %s not found\n", cmd);
		fprintf(toErr, "Could Not Create Child Process (error %d)\n", GetLastError());
	}

	SetStdHandle(STD_INPUT_HANDLE, oldIn);
	SetStdHandle(STD_OUTPUT_HANDLE, oldOut);
	SetStdHandle(STD_ERROR_HANDLE, oldErr);

	//
	//Close unneccesary Handles and Restore the crt handles
	//

	CloseHandle(ChildIn);
	CloseHandle(ChildOut);
	CloseHandle(ChildErr);

	CloseHandle(pi.hThread);

	return(pi.hProcess);
error:
	if(ChildIn != 0L)
		CloseHandle(ChildIn);
	if(ChildOut != 0L)
		CloseHandle(ChildOut);
	if(ChildErr != 0L)
		CloseHandle(ChildErr);
	if(dupIn != 0L)
		CloseHandle(dupIn);
	if(dupOut != 0L)
		CloseHandle(dupOut);
	if(dupErr != 0L)
		CloseHandle(dupErr);
	if(*inH != 0L)
		CloseHandle(*inH);
	if(*outH != 0L)
		CloseHandle(*outH);
	if(*errH != 0L)
		CloseHandle(*errH);
	return 0L;
}

#define BUFFSIZE 1024

DWORD
GetChldOutput(
    HANDLE readH
    )
{
    char  buff[BUFFSIZE];
    DWORD dread;

    while(ReadFile(readH,buff,BUFFSIZE-1,&dread,NULL))
    {
        buff[dread]='\0';
		fwrite(buff, sizeof(char), dread, toOut);
    }
    return(1);
}

DWORD
GetChldError(
    HANDLE readH
    )
{
    char  buff[BUFFSIZE];
    DWORD dread;

    while(ReadFile(readH,buff,BUFFSIZE-1,&dread,NULL))
    {
        buff[dread]='\0';
		fwrite(buff, sizeof(char), dread, toErr);
    }
    return(1);
}


int main(int argc, char* argv[])
{
	HANDLE hIn = 0L, hOut = 0L, hErr = 0L;
	HANDLE hChild = 0L;
	DWORD retval = -1;
	HANDLE WaitH[3] = {0L, 0L, 0L};
    DWORD ThreadID;
    DWORD WaitObj;
	int i;
	char *args = 0L;
	int lenargs = 0;
    char  buff[BUFFSIZE];
    DWORD dread, numWritten;

	if(argc < 5)
	{
        fprintf(stderr, "Wrong argunents\n");
		goto error1;
	}

	// open the files IO
	if((toErr = fopen(argv[3], "w")) == 0L)
	{
        fprintf(stderr, "Impossible to open the stderr file\n");
		goto error1;
	}
	if((toOut = fopen(argv[2], "w")) == 0L)
	{
        fprintf(toErr, "Impossible to open the stdout file\n");
		goto error1;
	}
	if((fromIn = fopen(argv[1], "r")) == 0L)
	{
        fprintf(toErr, "Impossible to open the stdin file\n");
		goto error1;
	}

	// concatenate the arguments
	for(i = 4; i < argc; i++)
	{
		lenargs += strlen(argv[i]) + 1 + 2;
	}
	args = (char *)malloc((lenargs + 1) * sizeof(char));
	if(args == 0L)
	{
		fprintf(toErr, "%s : Cannot allocate %d bytes\n", argv[0], lenargs);
		goto error1;
	}

	args[0] = '\0';
	for(i = 4; i < argc; i++)
	{
		strcat(args, """");
		strcat(args, argv[i]);
		strcat(args, """");
		strcat(args, " ");
	}

	// launch the sub-process
	hChild = ForkChildProcess(args, &hIn, &hOut, &hErr);

	if(hChild == 0L)
		goto error1;

	WaitH[2] = hChild;

	// intercept stdout
    if ((WaitH[1]=CreateThread
                  (
                     (LPSECURITY_ATTRIBUTES)NULL,           // No security attributes.
                     (DWORD)0,                              // Use same stack size.
                     (LPTHREAD_START_ROUTINE)GetChldOutput, // Thread procedure.
                     (LPVOID)hOut,                   // Parameter to pass.
                     (DWORD)0,                              // Run immediately.
                     (LPDWORD)&ThreadID)
                  )==NULL)
    {

        TerminateProcess(hChild,0);
        fprintf(toErr, "Failed to Create GetGhldOutput#2 Thread\n");
		goto error1;
    }

	// intercept stderr
    if ((WaitH[0]=CreateThread
                  (
                     (LPSECURITY_ATTRIBUTES)NULL,           // No security attributes.
                     (DWORD)0,                              // Use same stack size.
                     (LPTHREAD_START_ROUTINE)GetChldError, // Thread procedure.
                     (LPVOID)hErr,                   // Parameter to pass.
                     (DWORD)0,                              // Run immediately.
                     (LPDWORD)&ThreadID)
                   )==NULL)
    {
        TerminateProcess(hChild,0);
        fprintf(toErr, "Failed to Create GetGhldOutput#1 Thread\n");
		goto error1;
    }

	// now spool stdinfile > stdinchild
	while(!feof(fromIn) && !ferror(fromIn))
	{
		dread = fread(buff, sizeof(char), BUFFSIZE, fromIn);
		if(dread < 0)
			break;

		if(!WriteFile(hIn, buff, dread, &numWritten, 0L))
		{
	        fprintf(toErr, "Error while writing to the process input\n");
			break;
		}
	}
	CloseHandle(hIn);
	hIn = 0L;

    //
    // Wait until the child process terminates
    // or local IO thread terminates
    // or IO with child process ends
    //

    WaitObj=WaitForMultipleObjects(3, &WaitH[0], TRUE, INFINITE);

#if 0
    switch (WaitObj-WAIT_OBJECT_0)
    {
        case 0:      // Error Writing to savefile
        case 1:
            TerminateProcess(hChild,0);
            break;
        case 2:      // Child Proc Terminated
			GetExitCodeProcess(hChild, &retval);
            break;

        default:     // Out of Some Resource
            fprintf(toErr, "Out of Resource Error %d..Terminating\n",GetLastError());
            break;

    }
#else
	GetExitCodeProcess(hChild, &retval);
#endif

error1:
	if(hChild != 0L)
		CloseHandle(hChild);

	if(hIn != 0L)
	    CloseHandle(hIn);
	if(hOut != 0L)
	    CloseHandle(hOut);
	if(hErr != 0L)
		CloseHandle(hErr);

	if(fromIn != 0L)
		fclose(fromIn);
	if(toOut != 0L)
		fclose(toOut);
	if(toErr != 0L)
		fclose(toErr);

	if(args != 0L)
		free(args);

	return retval;
}
