/*
 # $Id: morpher.h,v 1.2 1997/08/06 14:43:29 fbm Exp fbm $
 # Copyright (C) 1997 Farrell McKay
 # All rights reserved.
 #
 # This file is part of the Fortify distribution, a toolkit for
 # upgrading the cryptographic strength of the Netscape Navigator
 # web browser, authored by Farrell McKay.
 #
 # This toolkit is provided to the recipient under the
 # following terms and conditions:-
 #   1.  This copyright notice must not be removed or modified.
 #   2.  This toolkit may not be reproduced or included in any commercial
 #       media distribution, or commercial publication (for example CD-ROM,
 #       disk, book, magazine, journal) without first obtaining the author's
 #       express permission.
 #   3.  This toolkit, or any component of this toolkit, may not be
 #       commercially resold, redeveloped, rewritten, enhanced or otherwise
 #       used as the basis for commercial venture, without first obtaining
 #       the author's express permission.
 #   4.  Subject to the above conditions being observed (1-3), this toolkit
 #       may be freely reproduced or redistributed.
 #   5.  This software is provided "as-is", without express or implied
 #       warranty.  In no event shall the author be liable for any direct,
 #       indirect or consequential damages however caused.
 #   6.  Subject to the above conditions being observed (1-5),
 #       this toolkit may be used at no cost to the recipient.
 #
 # Farrell McKay			Farrell.McKay@mpx.com.au
 */

#ifndef DEFS_H
#define DEFS_H

#define	ADDR_UNKN	(unsigned long)-1
#define GRAMMAR_MAJOR	1
#define GRAMMAR_MINOR	1

#define	VEC_NUM_FMT	0
#define	VEC_STR_FMT	1

#ifndef GNU_WIN32
#define OPENFL(a)	(a)
#else
#define OPENFL(a)	((a)|O_BINARY)
#endif

#define	min(a,b)	((a) < (b)? (a): (b))
#define	max(a,b)	((a) > (b)? (a): (b))

#define is_bool_op(a)	((a)==eq||(a)==ne||(a)==lt||(a)==le||(a)==gt||(a)==ge)

enum verb_t {
	print, assert
};

enum op_t {
	constant, ptr, base, addr, offset, eq, ne, lt, le, gt, ge
};

typedef struct {
	int		len;
	unsigned char	*data;
	int		format;
} vec_t;

typedef struct exp {
	enum op_t	op;
	int		nargs;
	union {
	  unsigned long ul;
	  struct exp	*p;
	  char		*cp;
	}		arg1, arg2;
} exp_t;

typedef struct cmd {
	struct cmd	*next;
	enum verb_t	verb;
	exp_t		*exp;
} cmd_t;

typedef struct {
	char		*name;
	int		seg;
	char		*msg;
	unsigned long	base;
	unsigned long	offset;
	unsigned long	filepos;
	int		is_context;
	vec_t		old, new;
	cmd_t		*cmds;
} morph_t;

typedef struct {
	int		grammar_major;
	int		grammar_minor;
	char		*target;
	unsigned long	main;
	long		offsets[NSEGS];
	int		nmorphs;		/* no. of morphs in morphs[] */
	int		morphs_sz;		/* len of morphs[] array */
	morph_t		**morphs;
} morph_set;

morph_set	*parse(FILE* fp);
void		lex_file_input(FILE* fp);
morph_t		*find_morph(morph_set *ms, char *name);
void		dump_bool_op(FILE *fp, enum op_t op);
void		dump_morph(FILE *fp, morph_set *ms, morph_t *mp, void (*eval_fn)(), void *vp);
void		dump_init(FILE *fp, morph_set *ms);
void		dump_set(FILE *fp, morph_set *ms, void (*eval_fn)(), void *vp);

#endif
