/*
 # $Id: md5_calc.c,v 1.3 1997/12/07 05:54:03 fbm Exp fbm $
 # Copyright (C) 1997 Farrell McKay
 # All rights reserved.
 #
 # This file is part of the Fortify distribution, a toolkit for
 # upgrading the cryptographic strength of the Netscape Navigator
 # web browser, authored by Farrell McKay.
 #
 # This toolkit is provided to the recipient under the
 # following terms and conditions:-
 #   1.  This copyright notice must not be removed or modified.
 #   2.  This toolkit may not be reproduced or included in any commercial
 #       media distribution, or commercial publication (for example CD-ROM,
 #       disk, book, magazine, journal) without first obtaining the author's
 #       express permission.
 #   3.  This toolkit, or any component of this toolkit, may not be
 #       commercially resold, redeveloped, rewritten, enhanced or otherwise
 #       used as the basis for commercial venture, without first obtaining
 #       the author's express permission.
 #   4.  Subject to the above conditions being observed (1-3), this toolkit
 #       may be freely reproduced or redistributed.
 #   5.  This software is provided "as-is", without express or implied
 #       warranty.  In no event shall the author be liable for any direct,
 #       indirect or consequential damages however caused.
 #   6.  Subject to the above conditions being observed (1-5),
 #       this toolkit may be used at no cost to the recipient.
 #
 # Farrell McKay			Farrell.McKay@mpx.com.au
 */

#include <stdio.h>
#include <unistd.h>
#include "md5.h"

#define BUFSIZE 1024*16

char *
md5_calc(int fd, char *span)
{
        int                     i, nb;
        MD5_CTX                 c;
	long			start = 0;
	long			stop = -1;
	long			posn = 0;
        unsigned char           *p, md[MD5_DIGEST_LENGTH];
        static unsigned char    buf[BUFSIZE];

	MD5_Init(&c);

	if (span == NULL || *span == '\0')
		span = "0-";
	while (span && *span) {
		start = strtol(span, &span, 0);

		if (posn != start)
			posn = (long) lseek(fd, (off_t) start, SEEK_SET);

		if (*span == '\0')
			stop = start;
		else if (*span == ',')
			stop = start;
		else if (*span == '-' || *span == ':') {
			stop = (*span == ':')? start: 0;
			span++;
			if (*span == '\0' || *span == ',')
				stop = -1;
			else {
				stop += strtol(span, &span, 0);
			}
		}
		if (*span == ',')
			span++;

		if (start < 0 || (stop < start && stop >= 0)) {
			fprintf(stderr, "Warning, bad range ignored: %d to %d\n",
				start, stop
			);
		}
		else {
			while (posn < stop || stop < 0) {
				nb = sizeof(buf);
				if (stop > 0 && stop - posn < nb)
					nb = stop - posn;
				i = read(fd, buf, nb);
				if (i <= 0)
					break;
				MD5_Update(&c, buf, (unsigned long)i);
				posn += i;
			}
		}
	}

	MD5_Final(&(md[0]),&c);

        for (i = 0, p = buf; i < MD5_DIGEST_LENGTH; i++, p += 2)
                sprintf(p, "%02x", md[i]);
        return buf;
}
