/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.lpdg;

import java.io.File;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class InteractionHandler {
    private static final String PathOption = "p";
    private static final String HelpOption = "h";
    private static final String DepthOption = "d";
    private static final String OverwriteOption = "o";
    private static final String MinimizeOption = "m";
    private static final String LicenseOptionLong = "license";
    private static final String DebugOptionLong = "debug";
    private boolean isSingleFile = false;
    private boolean isDebug = false;
    private boolean overwriteFlag = false;
    private boolean minimizeFlag = false;
    private final Options options;
    private final String userDirectory;
    private String path = this.userDirectory = System.getProperty("user.dir");
    private int depth = 5;
    public static final InteractionHandler INSTANCE = new InteractionHandler();

    public boolean hasOverwriteFlag() {
        return this.overwriteFlag;
    }

    public boolean hasMinimizeFlag() {
        return this.minimizeFlag;
    }

    public String getPath() {
        return this.path;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUserDirectory() {
        return this.userDirectory;
    }

    public static InteractionHandler getInstance() {
        return INSTANCE;
    }

    private InteractionHandler() {
        this.options = InteractionHandler.InitOptions();
    }

    private static Options InitOptions() {
        Options options = new Options();
        options.addOption(Option.builder(HelpOption).desc("Print this message and quit.").longOpt("help").build());
        options.addOption(Option.builder(DepthOption).hasArg().argName("Depth").desc("The depth of the scan. Default value is 5.").longOpt("depth").build());
        options.addOption(Option.builder(OverwriteOption).desc("Overwrite the input file(s), with a version that only includes the necessary packages.").longOpt("overwrite").build());
        options.addOption(Option.builder(MinimizeOption).desc("Creates a minimized version of the input file(s), with only the necessary packages.").longOpt("minimize").build());
        options.addOption(Option.builder(PathOption).desc("File or path to be scanned. The default value is the current working directory.").hasArg().argName("Path").longOpt("Path").build());
        options.addOption(Option.builder().desc("Print the Licensing information and quit.").longOpt(LicenseOptionLong).build());
        options.addOption(Option.builder().desc("Print debug information.").longOpt(DebugOptionLong).build());
        return options;
    }

    public void handleOptions(String[] args) throws ParseException {
        Boolean validateResult;
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args);
        if (cmd.hasOption(DebugOptionLong)) {
            this.isDebug = true;
            this.printDebugMessage("Debugging.");
        }
        if (cmd.hasOption(HelpOption)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar LatexDependencyGrapher", "Scan your Latex file(s) to find unused pacakges and create a graph of your dependencies.", this.options, "");
            this.printDebugMessage("HelpOption called.");
            System.exit(0);
        }
        if (cmd.hasOption(PathOption)) {
            this.path = cmd.getOptionValue(PathOption);
            this.printDebugMessage("PathOption called. Values is: " + this.path);
            if (this.path.isBlank() || this.path.isEmpty()) {
                throw new MissingArgumentException("The value for the path is missing.");
            }
        }
        if (cmd.hasOption(DepthOption)) {
            this.depth = Integer.parseInt(cmd.getOptionValue(DepthOption));
            this.printDebugMessage("DepthOption called. Values is: " + this.depth);
        }
        if (cmd.hasOption(LicenseOptionLong)) {
            System.out.println("This project uses the Apache Commons CLI Library, which is licensed under Apache License 2.0. See more in the NOTICE.txt File.");
            this.printDebugMessage("LicenseOption called. Values is: " + this.path);
            System.exit(0);
        }
        if (cmd.hasOption(MinimizeOption)) {
            this.minimizeFlag = true;
            this.printDebugMessage("MinimizeOption called.");
        }
        if (cmd.hasOption(OverwriteOption)) {
            this.overwriteFlag = true;
            this.printDebugMessage("OverwriteOption called.");
        }
        if (!(validateResult = this.validatePath(this.path)).booleanValue()) {
            throw new InvalidParameterException("The given path is invalid: " + this.path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<File> getFiles() {
        if (!this.isSingleFile) return this.loadLatexFiles();
        if (this.path.endsWith(".sty")) return new ArrayList<File>(){
            {
                this.add(new File(InteractionHandler.this.path));
            }
        };
        if (this.path.endsWith(".cls")) return new /* invalid duplicate definition of identical inner class */;
        if (!this.path.endsWith(".tex")) throw new IllegalArgumentException("The given Path is not a LaTeX-File.");
        return new /* invalid duplicate definition of identical inner class */;
    }

    public void printDebugMessage(String msg) {
        if (this.isDebug) {
            System.out.println("\u001b[33mDEBUG: " + msg + "\u001b[0m");
        }
    }

    private Boolean validatePath(String path) {
        if (path == null) {
            this.printDebugMessage("Path is null.");
            return false;
        }
        File file = new File(path);
        this.printDebugMessage("Filepath: " + file.getAbsolutePath());
        if (!file.isDirectory()) {
            this.printDebugMessage("Path is not a directory");
            this.isSingleFile = file.exists();
            file = file.getParentFile();
        } else {
            this.isSingleFile = false;
        }
        if (this.isSingleFile) {
            this.printDebugMessage("The path is a single file.");
            if (!(path.endsWith(".sty") || path.endsWith(".cls") || path.endsWith(".tex"))) {
                throw new IllegalArgumentException("The given Path is not a LaTeX-File.");
            }
        }
        return file != null && file.exists();
    }

    private List<File> loadLatexFiles() {
        File[] files;
        if (this.isSingleFile) {
            throw new IllegalCallerException("This method should only be called to load the LaTeX-Files from a directory.");
        }
        ArrayList<File> latexFiles = new ArrayList<File>();
        File directory = new File(this.path);
        if (directory.isDirectory() && (files = directory.listFiles((dir, name) -> name.endsWith(".sty") || name.endsWith(".cls") || name.endsWith(".tex"))) != null) {
            latexFiles.addAll(Arrays.asList(files));
        }
        return latexFiles;
    }
}

