/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.NotUpdatable;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UpdatableResultSet
extends ResultSet {
    private static final byte[] STREAM_DATA_MARKER = "** STREAM DATA **".getBytes();
    private List primaryKeyIndicies = null;
    private PreparedStatement deleter = null;
    private PreparedStatement inserter = null;
    private PreparedStatement refresher;
    private PreparedStatement updater = null;
    private SingleByteCharsetConverter charConverter;
    private String charEncoding;
    private String deleteSQL = null;
    private String insertSQL = null;
    private String quotedIdChar = null;
    private String refreshSQL = null;
    private String qualifiedAndQuotedTableName;
    private String tableOnlyName;
    private String updateSQL = null;
    private byte[][] defaultColumnValue;
    private byte[][] savedCurrentRow;
    private boolean isUpdatable = false;
    private boolean initializedCharConverter = false;

    public UpdatableResultSet(long updateCount, long updateID) {
        super(updateCount, updateID);
    }

    public UpdatableResultSet(String catalog, Field[] fields, RowData rows, Connection conn) throws SQLException {
        super(catalog, fields, rows, conn);
        this.isUpdatable = this.checkUpdatability();
    }

    public UpdatableResultSet(Field[] fields, RowData rows) throws SQLException {
        super(fields, rows);
        this.isUpdatable = this.checkUpdatability();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return super.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return super.isBeforeFirst();
    }

    public int getConcurrency() throws SQLException {
        return this.isUpdatable ? 1008 : 1007;
    }

    public synchronized boolean isFirst() throws SQLException {
        return super.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return super.isLast();
    }

    public synchronized boolean absolute(int row) throws SQLException {
        return super.absolute(row);
    }

    public synchronized void afterLast() throws SQLException {
        super.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        super.beforeFirst();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.updater.clearParameters();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        super.close();
    }

    public synchronized void deleteRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            throw new SQLException("Can not call deleteRow() when on insert row");
        }
        if (this.rowData.size() == 0) {
            throw new SQLException("Can't deleteRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call deleteRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call deleteRow().");
        }
        if (this.deleter == null) {
            if (this.deleteSQL == null) {
                this.generateStatements();
            }
            this.deleter = (PreparedStatement)this.connection.prepareStatement(this.deleteSQL);
            if (this.deleter.getMaxRows() != 0) {
                this.deleter.setMaxRows(0);
            }
        }
        this.deleter.clearParameters();
        String characterEncoding = null;
        if (this.connection.useUnicode()) {
            characterEncoding = this.connection.getEncoding();
        }
        try {
            int numKeys = this.primaryKeyIndicies.size();
            if (numKeys == 1) {
                int index = (Integer)this.primaryKeyIndicies.get(0);
                String currentVal = characterEncoding == null ? new String(this.thisRow[index]) : new String(this.thisRow[index], characterEncoding);
                this.deleter.setString(1, currentVal);
            } else {
                int i = 0;
                while (i < numKeys) {
                    int index = (Integer)this.primaryKeyIndicies.get(i);
                    String currentVal = characterEncoding == null ? new String(this.thisRow[index]) : new String(this.thisRow[index], characterEncoding);
                    this.deleter.setString(i + 1, currentVal);
                    ++i;
                }
            }
            this.deleter.executeUpdate();
            this.rowData.removeRow(this.rowData.getCurrentRowNumber());
        }
        catch (UnsupportedEncodingException encodingEx) {
            throw new SQLException("Unsupported character encoding '" + this.connection.getEncoding() + "'");
        }
    }

    public synchronized boolean first() throws SQLException {
        return super.first();
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.onInsertRow) {
            throw new SQLException("Not on insert row");
        }
        this.inserter.executeUpdate();
        int numPrimaryKeys = 0;
        if (this.primaryKeyIndicies != null) {
            numPrimaryKeys = this.primaryKeyIndicies.size();
        }
        long autoIncrementId = this.inserter.getLastInsertID();
        int numFields = this.fields.length;
        byte[][] newRow = new byte[numFields][];
        int i = 0;
        while (i < numFields) {
            newRow[i] = (byte[])(this.inserter.isNull(i) ? null : this.inserter.getBytes(i));
            if (numPrimaryKeys == 1 && this.fields[i].isPrimaryKey() && autoIncrementId > 0L) {
                newRow[i] = String.valueOf(autoIncrementId).getBytes();
            }
            ++i;
        }
        this.rowData.addRow(newRow);
        this.resetInserter();
    }

    public synchronized boolean last() throws SQLException {
        return super.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            this.onInsertRow = false;
            this.thisRow = this.savedCurrentRow;
        }
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.inserter == null) {
            this.generateStatements();
            this.inserter = (PreparedStatement)this.connection.prepareStatement(this.insertSQL);
            if (this.inserter.getMaxRows() != 0) {
                this.inserter.setMaxRows(0);
            }
            this.extractDefaultValues();
            this.resetInserter();
        } else {
            this.resetInserter();
        }
        int numFields = this.fields.length;
        this.onInsertRow = true;
        this.doingUpdates = false;
        this.savedCurrentRow = this.thisRow;
        this.thisRow = new byte[numFields][];
        int i = 0;
        while (i < numFields) {
            if (this.defaultColumnValue[i] != null) {
                this.inserter.setBytes(i + 1, this.defaultColumnValue[i]);
                byte[] defaultValueCopy = new byte[this.defaultColumnValue[i].length];
                System.arraycopy(this.defaultColumnValue[i], 0, defaultValueCopy, 0, defaultValueCopy.length);
                this.thisRow[i] = defaultValueCopy;
            } else {
                this.inserter.setNull(i + 1, 0);
                this.thisRow[i] = null;
            }
            ++i;
        }
    }

    public synchronized boolean next() throws SQLException {
        return super.next();
    }

    public synchronized boolean prev() throws SQLException {
        return super.prev();
    }

    public synchronized boolean previous() throws SQLException {
        return super.previous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void refreshRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            throw new SQLException("Can not call refreshRow() when on insert row");
        }
        if (this.rowData.size() == 0) {
            throw new SQLException("Can't refreshRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call refreshRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call refreshRow().");
        }
        if (this.refresher == null) {
            if (this.refreshSQL == null) {
                this.generateStatements();
            }
            this.refresher = (PreparedStatement)this.connection.prepareStatement(this.refreshSQL);
            if (this.refresher.getMaxRows() != 0) {
                this.refresher.setMaxRows(0);
            }
        }
        this.refresher.clearParameters();
        int numKeys = this.primaryKeyIndicies.size();
        if (numKeys == 1) {
            byte[] dataFrom = null;
            int index = (Integer)this.primaryKeyIndicies.get(0);
            if (!this.doingUpdates) {
                dataFrom = this.thisRow[index];
            } else {
                dataFrom = this.updater.getBytes(index);
                if (this.updater.isNull(index) || dataFrom.length == 0) {
                    dataFrom = this.thisRow[index];
                }
            }
            this.refresher.setBytesNoEscape(1, dataFrom);
        } else {
            int i = 0;
            while (i < numKeys) {
                byte[] dataFrom = null;
                int index = (Integer)this.primaryKeyIndicies.get(i);
                if (!this.doingUpdates) {
                    dataFrom = this.thisRow[index];
                } else {
                    dataFrom = this.updater.getBytes(index);
                    if (this.updater.isNull(index) || dataFrom.length == 0) {
                        dataFrom = this.thisRow[index];
                    }
                }
                this.refresher.setBytesNoEscape(i + 1, dataFrom);
                ++i;
            }
        }
        java.sql.ResultSet rs = null;
        try {
            rs = this.refresher.executeQuery();
            int numCols = rs.getMetaData().getColumnCount();
            if (!rs.next()) throw new SQLException("refreshRow() called on row that has been deleted or had primary key changed", "S1000");
            int i = 0;
            while (i < numCols) {
                byte[] val = rs.getBytes(i + 1);
                this.thisRow[i] = (byte[])(val == null || rs.wasNull() ? null : rs.getBytes(i + 1));
                ++i;
            }
            Object var7_9 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            rs.close();
            return;
        }
        catch (SQLException ex) {}
    }

    public synchronized boolean relative(int rows) throws SQLException {
        return super.relative(rows);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setAsciiStream(columnIndex, x, length);
        } else {
            this.inserter.setAsciiStream(columnIndex, x, length);
            this.thisRow[columnIndex - 1] = STREAM_DATA_MARKER;
        }
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBigDecimal(columnIndex, x);
        } else {
            this.inserter.setBigDecimal(columnIndex, x);
            this.thisRow[columnIndex - 1] = (byte[])(x == null ? null : x.toString().getBytes());
        }
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBinaryStream(columnIndex, x, length);
        } else {
            this.inserter.setBinaryStream(columnIndex, x, length);
            this.thisRow[columnIndex - 1] = (byte[])(x == null ? null : STREAM_DATA_MARKER);
        }
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateBlob(int columnIndex, Blob blob) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBlob(columnIndex, blob);
        } else {
            this.inserter.setBlob(columnIndex, blob);
            this.thisRow[columnIndex - 1] = (byte[])(blob == null ? null : STREAM_DATA_MARKER);
        }
    }

    public void updateBlob(String columnName, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(columnName), blob);
    }

    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBoolean(columnIndex, x);
        } else {
            this.inserter.setBoolean(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(1);
        }
    }

    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setByte(columnIndex, x);
        } else {
            this.inserter.setByte(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex);
        }
    }

    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBytes(columnIndex, x);
        } else {
            this.inserter.setBytes(columnIndex, x);
            this.thisRow[columnIndex - 1] = x;
        }
    }

    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setCharacterStream(columnIndex, x, length);
        } else {
            this.inserter.setCharacterStream(columnIndex, x, length);
            this.thisRow[columnIndex - 1] = (byte[])(x == null ? null : STREAM_DATA_MARKER);
        }
    }

    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        if (clob == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateCharacterStream(columnIndex, clob.getCharacterStream(), (int)clob.length());
        }
    }

    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setDate(columnIndex, x);
        } else {
            this.inserter.setDate(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setDouble(columnIndex, x);
        } else {
            this.inserter.setDouble(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setFloat(columnIndex, x);
        } else {
            this.inserter.setFloat(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setInt(columnIndex, x);
        } else {
            this.inserter.setInt(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setLong(columnIndex, x);
        } else {
            this.inserter.setLong(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setNull(columnIndex, 0);
        } else {
            this.inserter.setNull(columnIndex, 0);
            this.thisRow[columnIndex - 1] = null;
        }
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setObject(columnIndex, x);
        } else {
            this.inserter.setObject(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setObject(columnIndex, x);
        } else {
            this.inserter.setObject(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.doingUpdates) {
            this.updater.executeUpdate();
            this.refreshRow();
            this.doingUpdates = false;
        }
        this.syncUpdate();
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setShort(columnIndex, x);
        } else {
            this.inserter.setShort(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setString(columnIndex, x);
        } else {
            this.inserter.setString(columnIndex, x);
            if (x == null) {
                this.thisRow[columnIndex - 1] = null;
            } else if (this.getCharConverter() != null) {
                try {
                    this.thisRow[columnIndex - 1] = StringUtils.getBytes(x, this.charConverter, this.charEncoding, this.connection.parserKnowsUnicode());
                }
                catch (UnsupportedEncodingException uEE) {
                    throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
                }
            } else {
                this.thisRow[columnIndex - 1] = x.getBytes();
            }
        }
    }

    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setTime(columnIndex, x);
        } else {
            this.inserter.setTime(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setTimestamp(columnIndex, x);
        } else {
            this.inserter.setTimestamp(columnIndex, x);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    protected void setResultSetConcurrency(int concurrencyFlag) {
        super.setResultSetConcurrency(concurrencyFlag);
    }

    protected void checkRowPos() throws SQLException {
        if (!this.onInsertRow) {
            super.checkRowPos();
        }
    }

    protected synchronized void generateStatements() throws SQLException {
        StringBuffer tableNameBuffer;
        if (!this.isUpdatable) {
            this.doingUpdates = false;
            this.onInsertRow = false;
            throw new NotUpdatable();
        }
        String quotedId = this.getQuotedIdChar();
        this.qualifiedAndQuotedTableName = null;
        this.tableOnlyName = null;
        if (this.fields[0].getOriginalTableName() != null) {
            tableNameBuffer = new StringBuffer();
            String databaseName = this.fields[0].getDatabaseName();
            if (databaseName != null && databaseName.length() > 0) {
                tableNameBuffer.append(quotedId);
                tableNameBuffer.append(databaseName);
                tableNameBuffer.append(quotedId);
                tableNameBuffer.append('.');
            }
            this.tableOnlyName = this.fields[0].getOriginalTableName();
            tableNameBuffer.append(quotedId);
            tableNameBuffer.append(this.tableOnlyName);
            tableNameBuffer.append(quotedId);
            this.qualifiedAndQuotedTableName = tableNameBuffer.toString();
        } else {
            tableNameBuffer = new StringBuffer();
            this.tableOnlyName = this.fields[0].getTableName();
            tableNameBuffer.append(quotedId);
            tableNameBuffer.append(this.tableOnlyName);
            tableNameBuffer.append(quotedId);
            this.qualifiedAndQuotedTableName = tableNameBuffer.toString();
        }
        this.primaryKeyIndicies = new ArrayList();
        StringBuffer fieldValues = new StringBuffer();
        StringBuffer keyValues = new StringBuffer();
        StringBuffer columnNames = new StringBuffer();
        StringBuffer insertPlaceHolders = new StringBuffer();
        boolean firstTime = true;
        boolean keysFirstTime = true;
        int i = 0;
        while (i < this.fields.length) {
            String originalColumnName = this.fields[i].getOriginalName();
            String columnName = null;
            columnName = this.connection.getIO().hasLongColumnInfo() && originalColumnName != null && originalColumnName.length() > 0 ? originalColumnName : this.fields[i].getName();
            if (this.fields[i].isPrimaryKey()) {
                this.primaryKeyIndicies.add(new Integer(i));
                if (!keysFirstTime) {
                    keyValues.append(" AND ");
                } else {
                    keysFirstTime = false;
                }
                keyValues.append(quotedId);
                keyValues.append(columnName);
                keyValues.append(quotedId);
                keyValues.append("=?");
            }
            if (firstTime) {
                firstTime = false;
                fieldValues.append("SET ");
            } else {
                fieldValues.append(",");
                columnNames.append(",");
                insertPlaceHolders.append(",");
            }
            insertPlaceHolders.append("?");
            columnNames.append(quotedId);
            columnNames.append(columnName);
            columnNames.append(quotedId);
            fieldValues.append(quotedId);
            fieldValues.append(columnName);
            fieldValues.append(quotedId);
            fieldValues.append("=?");
            ++i;
        }
        this.updateSQL = "UPDATE " + this.qualifiedAndQuotedTableName + " " + fieldValues.toString() + " WHERE " + keyValues.toString();
        this.insertSQL = "INSERT INTO " + this.qualifiedAndQuotedTableName + " (" + columnNames.toString() + ") VALUES (" + insertPlaceHolders.toString() + ")";
        this.refreshSQL = "SELECT " + columnNames.toString() + " FROM " + this.qualifiedAndQuotedTableName + " WHERE " + keyValues.toString();
        this.deleteSQL = "DELETE FROM " + this.qualifiedAndQuotedTableName + " WHERE " + keyValues.toString();
    }

    synchronized boolean isUpdatable() {
        return this.isUpdatable;
    }

    synchronized void syncUpdate() throws SQLException {
        if (this.updater == null) {
            if (this.updateSQL == null) {
                this.generateStatements();
            }
            this.updater = (PreparedStatement)this.connection.prepareStatement(this.updateSQL);
            if (this.updater.getMaxRows() != 0) {
                this.updater.setMaxRows(0);
            }
        }
        int numFields = this.fields.length;
        this.updater.clearParameters();
        int i = 0;
        while (i < numFields) {
            if (this.thisRow[i] != null) {
                this.updater.setBytes(i + 1, this.thisRow[i]);
            } else {
                this.updater.setNull(i + 1, 0);
            }
            ++i;
        }
        int numKeys = this.primaryKeyIndicies.size();
        if (numKeys == 1) {
            int index = (Integer)this.primaryKeyIndicies.get(0);
            byte[] keyData = this.thisRow[index];
            this.updater.setBytes(numFields + 1, keyData);
        } else {
            int i2 = 0;
            while (i2 < numKeys) {
                byte[] currentVal = this.thisRow[(Integer)this.primaryKeyIndicies.get(i2)];
                if (currentVal != null) {
                    this.updater.setBytes(numFields + i2 + 1, currentVal);
                } else {
                    this.updater.setNull(numFields + i2 + 1, 0);
                }
                ++i2;
            }
        }
    }

    private synchronized SingleByteCharsetConverter getCharConverter() throws SQLException {
        if (!this.initializedCharConverter) {
            this.initializedCharConverter = true;
            if (this.connection.useUnicode()) {
                this.charEncoding = this.connection.getEncoding();
                this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
            }
        }
        return this.charConverter;
    }

    private synchronized String getQuotedIdChar() throws SQLException {
        if (this.quotedIdChar == null) {
            boolean useQuotedIdentifiers = this.connection.supportsQuotedIdentifiers();
            if (useQuotedIdentifiers) {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                this.quotedIdChar = dbmd.getIdentifierQuoteString();
            } else {
                this.quotedIdChar = "";
            }
        }
        return this.quotedIdChar;
    }

    private String getTableName(Field field) {
        String originalTableName = field.getOriginalTableName();
        if (originalTableName != null && originalTableName.length() > 0) {
            return originalTableName;
        }
        return field.getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUpdatability() throws SQLException {
        String tableName = null;
        String catalogName = null;
        int primaryKeyCount = 0;
        if (this.fields.length > 0) {
            tableName = this.fields[0].getOriginalTableName();
            catalogName = this.fields[0].getDatabaseName();
            if (tableName == null) {
                tableName = this.fields[0].getTableName();
                catalogName = this.catalog;
            }
            if (this.fields[0].isPrimaryKey()) {
                ++primaryKeyCount;
            }
            int i = 1;
            while (i < this.fields.length) {
                String otherTableName = this.fields[i].getOriginalTableName();
                String otherCatalogName = this.fields[i].getDatabaseName();
                if (otherTableName == null) {
                    otherTableName = this.fields[i].getTableName();
                    otherCatalogName = this.catalog;
                }
                if (tableName == null || !otherTableName.equals(tableName)) {
                    return false;
                }
                if (catalogName == null || !otherCatalogName.equals(catalogName)) {
                    return false;
                }
                if (this.fields[i].isPrimaryKey()) {
                    ++primaryKeyCount;
                }
                ++i;
            }
            if (tableName == null || tableName.length() == 0) {
                return false;
            }
        } else {
            return false;
        }
        if (primaryKeyCount == 0) {
            return false;
        }
        if (this.catalog == null || this.catalog.length() == 0) {
            this.catalog = this.fields[0].getDatabaseName();
            if (this.catalog == null || this.catalog.length() == 0) {
                throw new SQLException("Can not create updatable result sets when there is no currently selected database and MySQL server version < 4.1", "S1009");
            }
        }
        if (this.connection.useStrictUpdates()) {
            HashMap<String, String> primaryKeyNames;
            block24: {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                java.sql.ResultSet rs = null;
                primaryKeyNames = new HashMap<String, String>();
                try {
                    rs = dbmd.getPrimaryKeys(catalogName, null, tableName);
                    while (rs.next()) {
                        String keyName = rs.getString(4);
                        keyName = keyName.toUpperCase();
                        primaryKeyNames.put(keyName, keyName);
                    }
                    Object var9_10 = null;
                    if (rs == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        rs = null;
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    AssertionFailedException.shouldNotHappen(ex);
                }
                rs = null;
                {
                }
            }
            if (primaryKeyNames.size() == 0) {
                return false;
            }
            int i = 0;
            while (i < this.fields.length) {
                String originalName;
                String columnNameUC;
                if (this.fields[i].isPrimaryKey() && primaryKeyNames.remove(columnNameUC = this.fields[i].getName().toUpperCase()) == null && (originalName = this.fields[i].getOriginalName()) != null && primaryKeyNames.remove(originalName.toUpperCase()) == null) {
                    return false;
                }
                ++i;
            }
            return primaryKeyNames.isEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void extractDefaultValues() throws SQLException {
        DatabaseMetaData dbmd = this.connection.getMetaData();
        java.sql.ResultSet columnsResultSet = null;
        try {
            columnsResultSet = dbmd.getColumns(this.catalog, null, this.tableOnlyName, "%");
            HashMap<String, byte[]> columnNameToDefaultValueMap = new HashMap<String, byte[]>(this.fields.length);
            while (columnsResultSet.next()) {
                String columnName = columnsResultSet.getString("COLUMN_NAME");
                byte[] defaultValue = columnsResultSet.getBytes("COLUMN_DEF");
                columnNameToDefaultValueMap.put(columnName, defaultValue);
            }
            int numFields = this.fields.length;
            this.defaultColumnValue = new byte[numFields][];
            int i = 0;
            while (i < numFields) {
                String tableName = this.fields[i].getOriginalName();
                if (tableName == null || tableName.length() == 0) {
                    tableName = this.fields[i].getName();
                }
                if (tableName != null) {
                    byte[] defaultVal = (byte[])columnNameToDefaultValueMap.get(tableName);
                    this.defaultColumnValue[i] = defaultVal;
                }
                ++i;
            }
            Object var9_10 = null;
            if (columnsResultSet == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (columnsResultSet == null) throw throwable;
            columnsResultSet.close();
            columnsResultSet = null;
            throw throwable;
        }
        columnsResultSet.close();
    }

    private void resetInserter() throws SQLException {
        this.inserter.clearParameters();
        int i = 0;
        while (i < this.fields.length) {
            this.inserter.setNull(i + 1, 0);
            ++i;
        }
    }
}

