<?php
//============================================================+
// File name   : tce_pdf.php
// Begin       : 2004-06-11
// Last Update : 2006-09-26
// 
// Description : Configuration file for pdf documents.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Congiguration file for TCPDF.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @package com.tecnick.tcpdf
 * @version 1.53.0.TC017
 * @link http://tcpdf.sourceforge.net
 * @license http://www.gnu.org/copyleft/lesser.html LGPL
 * @since 2004-06-11
 */

// PLEASE SET THE FOLLOWING CONSTANTS:

/**
 * header title
 */
define ("PDF_HEADER_TITLE", "School name");

/**
 * header description string
 */
define ("PDF_HEADER_STRING", "first row\nsecond row\nthird row");

/**
 * image logo
 */
define ("PDF_HEADER_LOGO", "logo_example.png");

/**
 * header logo image width [mm]
 */
define ("PDF_HEADER_LOGO_WIDTH", 20);

/**
 * height of area for offline user answer
 */
define ("PDF_TEXTANSWER_HEIGHT", 40);

/**
 * page format
 */
define ("PDF_PAGE_FORMAT", "A4");

/**
 * page orientation (P=portrait, L=landscape)
 */
define ("PDF_PAGE_ORIENTATION", "P");

/**
 * document creator
 */
define ("PDF_CREATOR", "TCExam 4");

/**
 * document author
 */
define ("PDF_AUTHOR", "TCExam 4");

/**
 *  document unit of measure [pt=point, mm=millimeter, cm=centimeter, in=inch]
 */
define ("PDF_UNIT", "mm");

/**
 * header margin
 */
define ("PDF_MARGIN_HEADER", 5);

/**
 * footer margin
 */
define ("PDF_MARGIN_FOOTER", 10);

/**
 * top margin
 */
define ("PDF_MARGIN_TOP", 27);

/**
 * bottom margin
 */
define ("PDF_MARGIN_BOTTOM", 30);

/**
 * left margin
 */
define ("PDF_MARGIN_LEFT", 15);

/**
 * right margin
 */
define ("PDF_MARGIN_RIGHT", 15);

/**
 * main font name
 */
define ("PDF_FONT_NAME_MAIN", "FreeSerif");

/**
 * main font size
 */
define ("PDF_FONT_SIZE_MAIN", 9);

/**
 * data font name
 */
define ("PDF_FONT_NAME_DATA", "FreeSans");

/**
 * data font size
 */
define ("PDF_FONT_SIZE_DATA", 7);

/**
 *  scale factor for images (number of points in user unit)
 */
define ("PDF_IMAGE_SCALE_RATIO", 2);

/**
 * magnification factor for titles
 */
define("HEAD_MAGNIFICATION", 1.1);

/**
 * height of cell repect font height
 */
define("K_CELL_HEIGHT_RATIO", 1.25);

/**
 * title magnification respect main font size
 */
define("K_TITLE_MAGNIFICATION", 1.3);

/**
 * reduction factor for small font
 */
define("K_SMALL_RATIO", 2/3);

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
