<?php
//============================================================+
// File name   : tce_paths.php
// Begin       : 2002-01-15
// Last Update : 2005-01-02
//
// Description : Configuration file for files and directories
//               paths.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Configuration file for files and directories paths.
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2002-01-15
 */

/**
 * host URL (e.g.: "http://www.yoursite.com")
 */
define ("K_PATH_HOST", "");

/**
 * relative URL where this program is installed (e.g.: "/")
 */
define ("K_PATH_TCEXAM", "");

/**
 * real full path where this program is installed (e.g: "/var/www/html/TCExam/")
 */
define ("K_PATH_MAIN", "");

/**
 * standard port for http (80) or https (443)
 */
define ("K_STANDARD_PORT", 80);

// --- DO NOT CHANGE THE FOLLOWING VALUES ---

/**
 * path to public code
 */
define ("K_PATH_PUBLIC_CODE", K_PATH_HOST.K_PATH_TCEXAM."public/code/");

/**
 * server path to public code
 */
define ("K_PATH_PUBLIC_CODE_REAL", K_PATH_MAIN."public/code/");

/**
 * full path to cache directory
 */
define ("K_PATH_CACHE", K_PATH_MAIN."cache/"); //

/**
 * url path to to cache directory
 */
define ("K_PATH_URL_CACHE", K_PATH_TCEXAM."cache/");

/**
 * full path to fonts directory
 */
define ("K_PATH_FONTS", K_PATH_MAIN."fonts/");

/**
 * full path to PDF fonts directory
 */
define ("FPDF_FONTPATH", K_PATH_FONTS);

/**
 * relative path to stylesheets directory
 */
define ("K_PATH_STYLE_SHEETS", "../styles/");

/**
 * relative path to javascript directory
 */
define ("K_PATH_JSCRIPTS", "../jscripts/");

/**
 * relative path to shared javascript directory
 */
define ("K_PATH_SHARED_JSCRIPTS", "../../shared/jscripts/");

/**
 * relative path to images directory
 */
define ("K_PATH_IMAGES", "../../images/");

/**
 * full path to TMX language file
 */
define ("K_PATH_TMX_FILE", K_PATH_MAIN."shared/config/lang/language_tmx.xml");

/**
 * full path to a blank image
 */
define ("K_BLANK_IMAGE", K_PATH_IMAGES."_blank.png");

//============================================================+
// END OF FILE                                                 
//============================================================+
?>