<?php
//============================================================+
// File name   : tce_mime.php
// Begin       : 2005-03-04
// Last Update : 2006-06-19
// 
// Description : file extension - MIME type associations
//
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Configuration file for MIME types.
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2005-03-04
 */

/**
 */

$mime = array();
$mime['323'] = "text/h323";
$mime['aab'] = "application/x-authorware-bin";
$mime['aam'] = "application/x-authorware-map";
$mime['aas'] = "application/x-authorware-seg";
$mime['acc'] = "chemical/x-synopsys-accord";
$mime['acx'] = "application/internet-property-stream";
$mime['ai'] = "application/postscript";
$mime['aif'] = "audio/x-aiff";
$mime['aifc'] = "audio/x-aiff";
$mime['aiff'] = "audio/x-aiff";
$mime['ano'] = "application/x-annotator";
$mime['apm'] = "application/studiom";
$mime['asc'] = "text/plain";
$mime['asd'] = "application/astound";
$mime['asf'] = "video/x-ms-asf";
$mime['asn'] = "application/astound";
$mime['asp'] = "application/x-asap";
$mime['asr'] = "video/x-ms-asf";
$mime['asx'] = "video/x-ms-asf";
$mime['au'] = "audio/basic";
$mime['avi'] = "video/x-msvideo";
$mime['axs'] = "application/olescript";
$mime['bas'] = "text/plain";
$mime['bcpio'] = "application/x-bcpio";
$mime['bin'] = "application/octet-stream";
$mime['bmp'] = "image/bmp";
$mime['c'] = "text/plain";
$mime['cat'] = "application/vnd.ms-pkiseccat";
$mime['cdf'] = "application/x-cdf";
$mime['cdf'] = "application/x-netcdf";
$mime['cer'] = "application/x-x509-ca-cert";
$mime['cgm'] = "image/cgm";
$mime['chat'] = "application/x-chat";
$mime['chm'] = "chemical/x-cs-chemdraw";
$mime['class'] = "application/octet-stream";
$mime['clp'] = "application/x-msclip";
$mime['cmx'] = "image/x-cmx";
$mime['cod'] = "image/cis-cod";
$mime['config'] = "application/x-ns-proxy-autoconfig";
$mime['cpio'] = "application/x-cpio";
$mime['cpt'] = "application/mac-compactpro";
$mime['crd'] = "application/x-mscardfile";
$mime['crl'] = "application/pkix-crl";
$mime['crt'] = "application/x-x509-ca-cert";
$mime['csh'] = "application/x-csh";
$mime['css'] = "text/css";
$mime['dcr'] = "application/x-director";
$mime['der'] = "application/x-x509-ca-cert";
$mime['dir'] = "application/x-director";
$mime['divx'] = "video/x-divx";
$mime['dll'] = "application/x-msdownload";
$mime['dms'] = "application/octet-stream";
$mime['doc'] = "application/msword";
$mime['dot'] = "application/msword";
$mime['dvi'] = "application/x-dvi";
$mime['dvx'] = "video/x-divx";
$mime['dwg'] = "application/autocad";
$mime['dxf'] = "application/dxf";
$mime['dxr'] = "application/x-director";
$mime['epb'] = "application/x-epublisher";
$mime['eps'] = "application/postscript";
$mime['es'] = "audio/echospeech";
$mime['etx'] = "text/x-setext";
$mime['evy'] = "application/envoy";
$mime['exe'] = "application/octet-stream";
$mime['ez'] = "application/andrew-inset";
$mime['faxmgr'] = "application/x-fax-manager";
$mime['faxmgrjob'] = "application/x-fax-manager-job";
$mime['fgd'] = "application/x-director";
$mime['fh'] = "image/x-freehand";
$mime['fh4'] = "image/x-freehand";
$mime['fh5'] = "image/x-freehand";
$mime['fh7'] = "image/x-freehand";
$mime['fhc'] = "image/x-freehand";
$mime['fif'] = "application/fractals";
$mime['fif'] = "image/fif";
$mime['flr'] = "x-world/x-vrml";
$mime['fm'] = "application/x-framemaker";
$mime['frame'] = "application/x-framemaker";
$mime['frm'] = "application/x-framemaker";
$mime['gif'] = "image/gif";
$mime['gtar'] = "application/x-gtar";
$mime['gz'] = "application/x-gzip";
$mime['h'] = "text/plain";
$mime['hdf'] = "application/x-hdf";
$mime['hlp'] = "application/winhlp";
$mime['hqx'] = "application/mac-binhex40";
$mime['hta'] = "application/hta";
$mime['htc'] = "text/x-component";
$mime['htm'] = "text/html";
$mime['html'] = "text/html";
$mime['htt'] = "text/webviewhtml";
$mime['ice'] = "x-conference/x-cooltalk";
$mime['ico'] = "image/x-icon";
$mime['ief'] = "image/ief";
$mime['igs'] = "model/iges";
$mime['iii'] = "application/x-iphone";
$mime['imd'] = "application/immedia";
$mime['ims'] = "application/immedia";
$mime['ins'] = "application/x-insight";
$mime['ins'] = "application/x-internet-signup";
$mime['insight'] = "application/x-insight";
$mime['inst'] = "application/x-install";
$mime['isp'] = "application/x-internet-signup";
$mime['iv'] = "application/x-inventor";
$mime['ivr'] = "i-world/I-vrml";
$mime['jfif'] = "image/pipeg";
$mime['jpe'] = "image/jpeg";
$mime['jpeg'] = "image/jpeg";
$mime['jpg'] = "image/jpeg";
$mime['js'] = "application/x-javascript";
$mime['latex'] = "application/x-latex";
$mime['lha'] = "application/octet-stream";
$mime['lic'] = "application/x-enterlicense";
$mime['licmgr'] = "application/x-licensemgr";
$mime['lsf'] = "video/x-la-asf";
$mime['lsx'] = "video/x-la-asf";
$mime['lzh'] = "application/octet-stream";
$mime['m13'] = "application/x-msmediaview";
$mime['m14'] = "application/x-msmediaview";
$mime['m3u'] = "audio/x-mpegurl";
$mime['m3u'] = "audio/x-mpegurl";
$mime['mail'] = "application/x-mailfolder";
$mime['maker'] = "application/x-framemaker";
$mime['man'] = "application/x-troff-man";
$mime['mcf'] = "image/vasa";
$mime['mdb'] = "application/x-msaccess";
$mime['me'] = "application/x-troff-me";
$mime['mht'] = "message/rfc822";
$mime['mhtml'] = "message/rfc822";
$mime['mid'] = "audio/mid";
$mime['mid'] = "audio/midi";
$mime['mid'] = "audio/x-midi";
$mime['mif'] = "application/vnd.mif";
$mime['mif'] = "application/x-mif";
$mime['mny'] = "application/x-msmoney";
$mime['mol'] = "chemical/x-mdl-molfile";
$mime['mov'] = "video/quicktime";
$mime['movie'] = "video/x-sgi-movie";
//$mime['mp2'] = "audio/mpeg";
$mime['mp2'] = "video/mpeg";
$mime['mp2a'] = "audio/x-mpeg2";
$mime['mp2v'] = "video/x-mpeg2";
//$mime['mp3'] = "audio/mpeg";
$mime['mp3'] = "audio/x-mpeg";
$mime['mp3url '] = "audio/x-mpegurl";
$mime['mpa'] = "video/mpeg";
$mime['mpa2'] = "audio/x-mpeg2";
$mime['mpe'] = "video/mpeg";
$mime['mpeg'] = "video/mpeg";
$mime['mpg'] = "video/mpeg";
$mime['mpga'] = "audio/mpeg";
$mime['mpp'] = "application/vnd.ms-project";
$mime['mps'] = "video/x-mpeg-system";
//$mime['mpv2'] = "video/mpeg";
$mime['mpv2'] = "video/x-mpeg2";
$mime['ms'] = "application/x-troff-ms";
$mime['msh'] = "model/mesh";
$mime['mv'] = "video/x-sgi-movie";
$mime['mvb'] = "application/x-msmediaview";
$mime['nc'] = "application/x-netcdf";
$mime['nws'] = "message/rfc822";
$mime['oda'] = "application/oda";
$mime['p10'] = "application/pkcs10";
$mime['p12'] = "application/x-pkcs12";
$mime['p7b'] = "application/x-pkcs7-certificates";
$mime['p7c'] = "application/x-pkcs7-mime";
$mime['p7m'] = "application/x-pkcs7-mime";
$mime['p7r'] = "application/x-pkcs7-certreqresp";
$mime['p7s'] = "application/x-pkcs7-signature";
$mime['pat'] = "audio/x-pat";
$mime['pbm'] = "image/x-portable-bitmap";
$mime['pcd'] = "image/x-photo-cd";
$mime['pdb'] = "chemical/x-pdb";
$mime['pdf'] = "application/pdf";
$mime['pfx'] = "application/x-pkcs12";
$mime['pgm'] = "image/x-portable-graymap";
$mime['pgn'] = "application/x-chess-pgn";
$mime['pko'] = "application/ynd.ms-pkipko";
$mime['pma'] = "application/x-perfmon";
$mime['pmc'] = "application/x-perfmon";
$mime['pml'] = "application/x-perfmon";
$mime['pmr'] = "application/x-perfmon";
$mime['pmw'] = "application/x-perfmon";
$mime['png'] = "image/png";
$mime['pnm'] = "image/x-portable-anymap";
$mime['pot,'] = "application/vnd.ms-powerpoint";
$mime['ppm'] = "image/x-portable-pixmap";
$mime['pps'] = "application/vnd.ms-powerpoint";
$mime['ppt'] = "application/powerpoint";
$mime['ppt'] = "application/vnd.ms-powerpoint";
$mime['prf'] = "application/pics-rules";
$mime['ps'] = "application/postscript";
$mime['pub'] = "application/x-mspublisher";
$mime['puz'] = "application/x-crossword";
$mime['qt'] = "video/quicktime";
$mime['ra'] = "audio/x-pn-realaudio";
$mime['ra'] = "audio/x-realaudio";
$mime['ram'] = "audio/x-pn-realaudio";
$mime['ras'] = "image/x-cmu-raster";
$mime['rgb'] = "image/x-rgb";
$mime['rm'] = "audio/x-pn-realaudio";
$mime['rmi'] = "audio/mid";
$mime['roff'] = "application/x-troff";
$mime['rpm'] = "audio/x-pn-realaudio-plugin";
$mime['rtf'] = "application/rtf";
$mime['rtf'] = "text/rtf";
$mime['rtx'] = "text/richtext";
$mime['rxn'] = "chemical/x-mdl-rxn";
$mime['sbk'] = "audio/x-sbk";
$mime['sc'] = "application/x-showcase";
$mime['scd'] = "application/x-msschedule";
$mime['sct'] = "text/scriptlet";
$mime['sds'] = "application/x-onlive";
$mime['setpay'] = "application/set-payment-initiation";
$mime['setreg'] = "application/set-registration-initiation";
$mime['sgi-lpr'] = "application/x-sgi-lpr";
$mime['sgm'] = "text/x-sgml";
$mime['sgml'] = "text/sgml";
$mime['sgml'] = "text/x-sgml";
$mime['sh'] = "application/x-sh";
$mime['shar'] = "application/x-shar";
$mime['sho'] = "application/x-showcase";
$mime['show'] = "application/x-showcase";
$mime['showcase'] = "application/x-showcase";
$mime['sit'] = "application/x-stuffit";
$mime['skc'] = "chemical/x-mdl-isis";
$mime['skd'] = "application/x-koan";
$mime['skm'] = "application/x-koan";
$mime['skp'] = "application/x-koan";
$mime['skt'] = "application/x-koan";
$mime['slides'] = "application/x-showcase";
$mime['smd'] = "chemical/x-smd";
$mime['smi'] = "application/smil";
$mime['smi'] = "chemical/x-daylight-smiles";
$mime['snd'] = "audio/basic";
$mime['spc'] = "application/x-pkcs7-certificates";
$mime['spl'] = "application/futuresplash";
$mime['spl'] = "application/x-futuresplash";
$mime['spr'] = "application/x-sprite";
$mime['sprite'] = "application/x-sprite";
$mime['src'] = "application/x-wais-source";
$mime['sst'] = "application/vnd.ms-pkicertstore";
$mime['stl'] = "application/vnd.ms-pkistl";
$mime['stm'] = "text/html";
$mime['str'] = "audio/x-str";
$mime['sv4cpio'] = "application/x-sv4cpio";
$mime['sv4crc'] = "application/x-sv4crc";
$mime['svr'] = "x-world/x-svr";
$mime['swf'] = "application/x-shockwave-flash";
$mime['sys'] = "video/x-mpeg-system";
$mime['t'] = "application/x-troff";
$mime['talk'] = "text/x-speech";
$mime['tar'] = "application/x-tar";
$mime['tardist'] = "application/x-tardist";
$mime['tcl'] = "application/x-tcl";
$mime['tex'] = "application/x-tex";
$mime['texi'] = "application/x-texinfo";
$mime['texinfo'] = "application/x-texinfo";
$mime['tgz'] = "application/x-compressed";
$mime['tif'] = "image/tiff";
$mime['tiff'] = "image/tiff";
$mime['tr'] = "application/x-troff";
$mime['trm'] = "application/x-msterminal";
$mime['tsi'] = "audio/tsplayer";
$mime['tsp'] = "application/dsptype";
$mime['tsv'] = "text/tab-separated-values";
$mime['tvm'] = "application/x-tvml";
$mime['tvml'] = "application/x-tvml";
$mime['txt'] = "text/plain";
$mime['uls'] = "text/iuls";
$mime['ustar'] = "application/x-ustar";
$mime['vcd'] = "application/x-cdlink";
$mime['vcf'] = "text/x-vcard";
$mime['viv'] = "video/vivo";
$mime['vivo'] = "video/vivo";
$mime['vmd'] = "application/vocaltec-media-desc";
$mime['vmf'] = "application/vocaltec-media-file";
$mime['vox'] = "audio/voxware";
$mime['vrj'] = "x-world/x-vrt";
$mime['vrml'] = "x-world/x-vrml";
$mime['vrt'] = "x-world/x-vrt";
$mime['wav'] = "audio/x-wav";
$mime['wbmp'] = "image/vnd.wap.wbmp";
$mime['wcm'] = "application/vnd.ms-works";
$mime['wdb'] = "application/vnd.ms-works";
$mime['wks'] = "application/vnd.ms-works";
$mime['wkz'] = "application/x-wingz";
$mime['wmf'] = "application/x-msmetafile";
$mime['wml'] = "text/vnd.wap.wml";
$mime['wmlc'] = "application/vnd.wap.wmlc";
$mime['wmls'] = "text/vnd.wap.wmlscript";
$mime['wmlsc'] = "application/vnd.wap.wmlscriptc";
$mime['wmv'] = "video/x-msvideo";
$mime['wps'] = "application/vnd.ms-works";
$mime['wri'] = "application/x-mswrite";
$mime['wrl'] = "model/vrml";
$mime['wrl'] = "x-world/x-vrml";
$mime['wrz'] = "x-world/x-vrml";
$mime['xaf'] = "x-world/x-vrml";
$mime['xar'] = "application/vnd.xara";
$mime['xbm'] = "image/x-xbitmap";
$mime['xla'] = "application/vnd.ms-excel";
$mime['xlc'] = "application/vnd.ms-excel";
$mime['xlm'] = "application/vnd.ms-excel";
$mime['xls'] = "application/vnd.ms-excel";
$mime['xlt'] = "application/vnd.ms-excel";
$mime['xlw'] = "application/vnd.ms-excel";
$mime['xml'] = "text/xml";
$mime['xof'] = "x-world/x-vrml";
$mime['xpm'] = "image/x-xpixmap";
$mime['xvd'] = "video/x-xvid";
$mime['xvid'] = "video/x-xvid";
$mime['xwd'] = "image/x-xwindowdump";
$mime['xyz'] = "chemical/x-pdb";
$mime['Z'] = "application/x-compress";
$mime['zip'] = "application/x-zip-compressed";
//$mime['zip'] = "application/zip";
$mime['ztardist'] = "application/x-ztardist";

//============================================================+
// END OF FILE                                                 
//============================================================+
?>