<?php
//============================================================+
// File name   : tce_general_constants.php
// Begin       : 2002-03-01
// Last Update : 2004-12-30
// 
// Description : Configuration file for general constants.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Configuration file for general constants.
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2002-03-01
 */

/**
 * number of seconds in one minute
 */
define ("K_SECONDS_IN_MINUTE", 60);

/**
 * number of seconds in one hour
 */
define ("K_SECONDS_IN_HOUR", 60 * K_SECONDS_IN_MINUTE);

/**
 * number of seconds in one day
 */
define ("K_SECONDS_IN_DAY", 24 * K_SECONDS_IN_HOUR);

/**
 * number of seconds in one week
 */
define ("K_SECONDS_IN_WEEK", 7 * K_SECONDS_IN_DAY);

/**
 * number of seconds in one month
 */
define ("K_SECONDS_IN_MONTH", 30 * K_SECONDS_IN_DAY);

/**
 * number of seconds in one year
 */
define ("K_SECONDS_IN_YEAR", 365 * K_SECONDS_IN_DAY);

/**
 * string used as a seed for some security code generation please change this value and keep it secret
 */
define ("K_RANDOM_SECURITY", "5hs6fel9"); 

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
