<?php
//============================================================+
// File name   : tce_config.php
// Begin       : 2002-02-24
// Last Update : 2006-09-26
// 
// Description : Shared configuration file.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Shared configuration file.
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2002-02-24
 */

/**
 * TCExam version (do not change)
 */
define ("K_TCEXAM_VERSION", "4.0.006");

/**
 * 2-letters language code
 */
define ("K_LANGUAGE", "en");

ini_set("zend.ze1_compatibility_mode", false); // disable PHP4 compatibility mode

// -- INCLUDE files -- 
require_once('../../shared/config/tce_paths.php');
require_once('../../shared/config/tce_general_constants.php');

/**
 * number of difficulty levels for questions
 */
define ("K_QUESTION_DIFFICULTY_LEVELS", 10);

/**
 * popup window height in pixels for test info
 */
define ("K_TEST_INFO_HEIGHT", 400);

/**
 * popup window width in pixels for test info
 */
define ("K_TEST_INFO_WIDTH", 700);

/**
 * number of columns for answer textarea
 */
define ("K_ANSWER_TEXTAREA_COLS", 70);

/**
 * number of rows for answer textarea
 */
define ("K_ANSWER_TEXTAREA_ROWS", 15);

/**
 * user's session life time in seconds
 */
define ("K_SESSION_LIFE", K_SECONDS_IN_HOUR);

/**
 * define timestamp format using PHP notation
 */
define ("K_TIMESTAMP_FORMAT", "Y-m-d H:i:s");

/**
 * define max line length in chars for question navigator on test execution interface
 */
define ("K_QUESTION_LINE_MAX_LENGTH", 70);

/**
 * if true allows the user to leave a comment on test
 */
define ("K_TEST_COMMENT", TRUE);

// Client Cookie settings

/**
 * cookie domain
 */
define ("K_COOKIE_DOMAIN", "");

/**
 * cookie path
 */
define ("K_COOKIE_PATH", "/");

/**
 * if true use secure cookies
 */
define ("K_COOKIE_SECURE", FALSE); 

/**
 * expiration time for cookies
 */
define ("K_COOKIE_EXPIRE", K_SECONDS_IN_DAY); //cookie expire time (one year)

/**
 * various pages redirection modes after login(valid values are 1,2 and 3).
 */
define ("K_REDIRECT_LOGIN_MODE", 3);

// Error settings

/**
 * define error reporting types for debug
 */
define ("K_ERROR_TYPES", E_ALL | E_STRICT);
//define ("K_ERROR_TYPES", E_ERROR | E_WARNING | E_PARSE);

/**
 * enable error logs (../log/tce_errors.log)
 */
define ("K_USE_ERROR_LOG", FALSE);

/**
 * if true display messages and errors on Javascript popup window
 */
define ("K_ENABLE_JSERRORS", false);

/**
 * error handlers
 */
require_once('../../shared/code/tce_functions_errmsg.php');

// load language resources
require_once('../../shared/code/tce_tmx.php'); // TMX class
$lang_resources = new TMXResourceBundle(K_PATH_TMX_FILE, K_LANGUAGE, K_PATH_CACHE.basename(K_PATH_TMX_FILE, ".xml")."_".K_LANGUAGE.".php"); // istantiate new TMXResourceBundle object
$l = $lang_resources->getResource(); // language array

set_magic_quotes_runtime(0); //disable magic quotes
ini_set("arg_separator.output", "&amp;");
ini_set("magic_quotes_gpc", "On");
ini_set("magic_quotes_runtime", "Off");
ini_set("register_long_arrays", "On");

// --- get posted and get variables (to be compatible with register_globals off)
foreach ($_REQUEST as $postkey => $postvalue) {
	$$postkey = $postvalue;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
