<?php
//============================================================+
// File name   : tce_functions_general.php
// Begin       : 2001-09-08
// Last Update : 2006-03-31
// 
// Description : General functions.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * General functions.
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-09-08
 */

/**
 * Count rows of the given table.
 * @param string $dbtable database table name
 * @param string $where optional where SQL clause (including the WHERE keyword).
 * @return number of rows
 */
function F_count_rows($dbtable, $where="") {
	global $db;
		require_once('../config/tce_config.php');
	
	$numofrows = 0;
	$sql = "SELECT COUNT(*) AS numrows FROM ".$dbtable." ".$where."";
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$numofrows = $m['numrows'];
		} 
	}
	else {
		F_display_db_error();
	}
	return($numofrows);
}

/**
 * Prepare field value for SQL query.<br>
 * Returns the quoted string if not empty, NULL otherwise.
 * @param string $str string to check.
 * @return string $str quoted if not empty, NULL otherwise
 */
function F_empty_to_null($str) {
	if (strlen($str) > 0) {
		return "'".$str."'";
	}
	return "NULL";
}

/**
 * Prepare field value for SQL query.<br>
 * Returns the num if different from zero, NULL otherwise.
 * @param string $num string to check.
 * @return string $num if != 0, NULL otherwise
 */
function F_zero_to_null($num) {
	if ($num == 0) {
		return "NULL";
	}
	return $num;
}

/**
 * Returns boolean value from string.<br>
 * This function is needed to get the right boolean value from boolean field returned by PostgreSQL query.
 * @param string $str string to check.
 * @return boolean value.
 */
function F_getBoolean($str) {
	if (is_string($str) AND ((strncasecmp($str, "t", 1) == 0) OR (strncasecmp($str, "1", 1) == 0))) {
		return true;
	}
	return false;
}

/**
 * Check if specified fields are unique on table.
 * @param string $table table name
 * @param string $where SQL where clause
 * @param mixed $fieldname name of table column to check
 * @param mixed $fieldid ID of table row to check
 * @return bool true if unique, false otherwise
 */
function F_check_unique($table, $where, $fieldname=FALSE, $fieldid=FALSE) {
		require_once('../config/tce_config.php');

	global $db;
	
	$sqlc = "SELECT * FROM ".$table." WHERE ".$where." LIMIT 1";
	if($rc = F_db_query($sqlc, $db)) {
		if (($fieldname==FALSE) AND ($fieldid==FALSE) AND (F_db_num_rows($rc) > 0)) {
			return FALSE;
		}
		if($mc = F_db_fetch_array($rc)) {
			if($mc[$fieldname] == $fieldid) {
				return TRUE; // the values are unchanged
			}
		}
		else {
			// the new values are not yet present on table
			return TRUE;
		} 
	}
	else {
		F_display_db_error();
	}
	// another table row contains the same values
	return FALSE;
}

/**
 * Reverse function for htmlentities.
 * @param string $text_to_convert input string to convert
 * @param boolean $preserve_tagsign if true preserve <> symbols, default=FALSE
 * @return converted string
 */
function unhtmlentities($text_to_convert, $preserve_tagsign=FALSE) {
	$trans_tbl = get_html_translation_table(HTML_ENTITIES);
	$trans_tbl = array_flip($trans_tbl);
	if ($preserve_tagsign) {
		$trans_tbl['&lt;']="&lt;"; //do not convert '<' equivalent
		$trans_tbl['&gt;']="&gt;"; //do not convert '>' equivalent
	}
	$return_text = strtr($text_to_convert, $trans_tbl);
	$return_text = preg_replace('/\&\#([0-9]+)\;/me', "chr('\\1')", $return_text);
	return $return_text;
}

/**
 * Remove the following characters:
 * <ul>
 * <li>"\t" (ASCII 9 (0x09)), a tab.</li>
 * <li>"\n" (ASCII 10 (0x0A)), a new line (line feed)</li> 
 * <li>"\r" (ASCII 13 (0x0D)), a carriage return</li>
 * <li>"\0" (ASCII 0 (0x00)), the NUL-byte</li>
 * <li>"\x0B" (ASCII 11 (0x0B)), a vertical tab</li>
 * </ul>
 * @param string $string input string to convert
 * @return converted string
 */
function F_compact_string($string) {
	$repTable = array("\t" => " ","\n" => " ","\r" => " ","\0" => " ","\x0B" => " "); //to escape quotes
	return strtr($string, $repTable);
}

/**
 * Replace angular parenthesis with html equivalents (html entities).
 * @param string $str input string to convert
 * @return converted string
 */
function F_replace_angulars($str) {
	$replaceTable = array("<" => "&lt;", ">" => "&gt;");
	return strtr($str, $replaceTable);
}

/**
 * Return part of a string removing remaining non-ASCII characters.
 * @param string $str input string
 * @param int $start substring start index
 * @param int $length substring max lenght
 * @return substring
 */
function F_substr_utf8($str, $start=0, $length) {
	if (strlen($str) > $length) {
		$i = $length - 1;
		// remove non-ASCII characters from the string end
		while (($i >= 0) AND (ord($str{$i}) > 0x7F)) {
			$i--;
		}
		$str = substr($str, 0, $i+1);
	}
	return $str;
}

/**
 * Escape some special characters (&lt; &gt; &amp;).
 * @param string $str input string to convert
 * @return converted string
 */
function F_text_to_xml($str) {
	$replaceTable = array("&" => "&amp;", "<" => "&lt;", ">" => "&gt;");
	return strtr($str, $replaceTable);
}

/**
 * Unescape some special characters (&lt; &gt; &amp;).
 * @param string $str input string to convert
 * @return converted string
 */
function F_xml_to_text($str) {
	$replaceTable = array("&amp;" => "&", "&lt;" => "<", "&gt;" => ">");
	return strtr($str, $replaceTable);
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
