<?php
//============================================================+
// File name   : tce_functions_form.php
// Begin       : 2001-11-07
// Last Update : 2006-09-29
// 
// Description : Functions to handle XHTML Form Fields.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Functions to handle XHTML Form Fields.
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-11-07
 */

/**
 */

$formstatus = TRUE; //reset form status

// check buttons actions
if(isset($_POST['update'])) {
	$menu_mode = "update";
} elseif(isset($_POST['delete'])) {
	$menu_mode = "delete";
} elseif(isset($_POST['forcedelete'])) {
	$menu_mode = "forcedelete";
} elseif(isset($_POST['cancel'])) {
	$menu_mode = "cancel";
} elseif(isset($_POST['add'])) {
	$menu_mode = "add";
} elseif(isset($_POST['clear'])) {
	$menu_mode = "clear";
} elseif(isset($_POST['upload'])) {
	$menu_mode = "upload";
} elseif(isset($_POST['addquestion'])) {
	$menu_mode = "addquestion";
}
if(!isset($menu_mode)) {
	$menu_mode = "";
}

/**
 * Returns an array containing form fields.
 * @return array containing form fields
 */
function F_decode_form_fields() {
	$formvars = "HTTP_".$_SERVER['REQUEST_METHOD']."_VARS";
	global $$formvars;
	return $$formvars;
}

/**
 * Check Required Form Fields.<br>
 * Returns a string containing a list of missing fields (comma separated).
 * @param string $formfields input array containing form fields
 * @return array containing a list of missing fields (if any)
 */
function F_check_required_fields($formfields) {
	
	if(empty($formfields) OR !array_key_exists("ff_required", $formfields) OR strlen($formfields['ff_required']) <= 0) {
		return FALSE;
	}
	$missing_fields = "";
	$required_fields = explode(",",$formfields['ff_required']);
	$required_fields_labels = explode(",",$formfields['ff_required_labels']); // form fields labels
	for($i=0; $i<count($required_fields); $i++) { //for each required field
		$fieldname = trim($required_fields[$i]);
		if(!array_key_exists($fieldname, $formfields) OR strlen($formfields[$fieldname]) <= 0) { //if is empty
			if ($required_fields_labels[$i]) { // check if field has label
				$fieldname = $required_fields_labels[$i];
			}
			$missing_fields .= ", ".stripslashes($fieldname);
		}
	}
	if(strlen($missing_fields)>1) {
		$missing_fields = substr($missing_fields, 1); // cuts first comma
	} 
	return ($missing_fields);
}

/**
 * Check fields format using regular expression comparisons.<br>
 * Returns a string containing a list of wrong fields (comma separated).
 * 
 * NOTE:
 * to check a field create a new hidden field with the same name starting with "x_"
 * 
 * An example powerful regular expression for email check is:
 *  ^([a-zA-Z0-9_\.\-]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$
 * @param string $formfields input array containing form fields
 * @return array containing a list of wrongfields (if any)
 */
function F_check_fields_format($formfields) {
	if(empty($formfields)) {
		return "";
	}
	reset($formfields);
	$wrongfields = "";
	while(list($key,$value) = each($formfields)) {
		if(substr($key,0,2)=="x_") {
			$fieldname = substr($key,2);
			if(array_key_exists($fieldname, $formfields) AND strlen($formfields[$fieldname]) > 0) { //if is not empty
				if(!eregi(stripslashes($value),$formfields[$fieldname])) { //check regular expression
					if ($formfields['xl_'.$fieldname]) { //check if field has label
						$fieldname = $formfields['xl_'.$fieldname];
					}
					$wrongfields .= ", ".stripslashes($fieldname);
				}
			}
		}
	}
	if(strlen($wrongfields) > 1) {
		$wrongfields = substr($wrongfields, 2); // cuts first 2 chars
	} 
	return ($wrongfields);
}

/**
 * Check Form Fields.
 * see: F_check_required_fields, F_check_fields_format
 * @return false in case of error, true otherwise
 */
function F_check_form_fields() {
	require_once('../config/tce_config.php');
	global $l;
	
	$formfields = F_decode_form_fields(); //decode form fields
	
	//check missing fields
	if($missing_fields = F_check_required_fields($formfields)) {
		F_print_error("WARNING", $l['m_form_missing_fields'].": ".$missing_fields);
		F_stripslashes_formfields();
		return FALSE;
	}
	
	//check fields format
	if($wrong_fields = F_check_fields_format($formfields)) {
		F_print_error("WARNING", $l['m_form_wrong_fields'].": ".$wrong_fields);
		F_stripslashes_formfields();
		return FALSE;
	}
	return TRUE;
}

/**
 * Strip slashes from posted form fields.
 */
function F_stripslashes_formfields() {
	foreach ($_POST as $key => $value) {
		if (is_string($value)) {
			global $$key;
			$$key = stripslashes($value);
		}	
	}
}

/**
 * Returns XHTML code string to display a window close button
 * @return XHTML code string
 */
function F_close_button() {
		require_once('../config/tce_config.php');
	global $l;
	
	$str = "";
	$str .= "<div class=\"row\">";
	$str .= "<form action=\"".$_SERVER['SCRIPT_NAME']."\" id=\"closeform\">";
	$str .= "<div>";
	$str .= "<input type=\"button\" name=\"wclose\" id=\"wclose\" value=\"".$l['w_close']."\" title=\"".$l['h_close_window']."\" onclick=\"window.close()\" />";
	$str .= "</div>";
	$str .= "</form>";
	$str .= "</div>";
	return $str;
}

/**
 * Returns XHTML code string to display Form Submit Button.
 * @param string $name button name
 * @param string $value label for button
 * @param string $title button title, default=""
 * @return XHTML code string
 */
function F_submit_button($name, $value, $title="") {
	echo "<input type=\"submit\" name=\"".$name."\" id=\"".$name."\" value=\"".$value."\" title=\"".$title."\" />";
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
