<?php
//============================================================+
// File name   : tce_functions_authorization.php
// Begin       : 2001-09-26
// Last Update : 2006-09-30
// 
// Description : Functions for Authorization / LOGIN
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Functions for Authorization / LOGIN
 * @package com.tecnick.tcexam.shared
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-09-26
 */

/**
 * Returns XHTML / CSS formatted string for login form.<br>
 * The CSS classes used are:
 * <ul>
 * <li>div.login_form : container for login box</li>
 * <li>div.login_form div.login_row : container for label + input field or button</li>
 * <li>div.login_form div.login_row span.label : container for input label</li>
 * <li>div.login_form div.login_row span.formw : container for input form</li>
 * </ul>
 * @param faction String action attribute
 * @param fid String form ID attribute
 * @param fmethod String method attribute (get/post)
 * @param fenctype String enctype attribute
 * @param username String user name
 * @param password String password
 * @param isize int enctype input fields horizontal size
 * @return XHTML string for login form
 */
function F_loginForm($faction, $fid, $fmethod, $fenctype, $username, $password, $isize=20) {
	global $l;
		require_once('../config/tce_config.php');
	
	$str = "";
	$str .= "\n<div class=\"container\">";
	$str .= "\n<div class=\"tceformbox\">";
	$str .= "\n<form action=\"".$faction."\" method=\"".$fmethod."\" id=\"".$fid."\" enctype=\"".$fenctype."\">";
	// user name
	$str .= "\n<div class=\"row\">";
	$str .= "\n<span class=\"label\">";
	$str .= "\n<label for=\"xuser_name\">".$l['w_username']."</label>";
	$str .= "\n</span>";
	$str .= "\n<span class=\"formw\">";
	$str .= "\n<input type=\"text\" name=\"xuser_name\" id=\"xuser_name\" value=\"".$username."\" size=\"".$isize."\" maxlength=\"255\" title=\"".$l['h_login_name']."\" />";
	$str .= "\n</span>";
	$str .= "\n</div>";
	// password
	$str .= "\n<div class=\"row\">";
	$str .= "\n<span class=\"label\">";
	$str .= "\n<label for=\"xuser_password\">".$l['w_password']."</label>";
	$str .= "\n</span>";
	$str .= "\n<span class=\"formw\">";
	$str .= "\n<input type=\"password\" name=\"xuser_password\" id=\"xuser_password\" value=\"\" size=\"".$isize."\" maxlength=\"255\" title=\"".$l['h_password']."\" />";
	$str .= "\n</span>";
	$str .= "\n</div>";
	// buttons
	$str .= "\n<div class=\"row\">";
	// the following field is used to check if form has been submitted
	$str .= "\n<input type=\"submit\" name=\"login\" id=\"login\" value=\"".$l['w_login']."\" title=\"".$l['h_login_button']."\" />";
	$str .= "\n<input type=\"hidden\" name=\"logaction\" id=\"logaction\" value=\"login\" />";
	$str .= "\n</div>";
	$str .= "\n</form>";
	$str .= "\n</div>";
	$str .= "<div class=\"pagehelp\">".$l['hp_login']."</div>";
	$str .= "\n</div>";
	return $str;
}

/**
 * Display login page.<br>
 * NOTE: This function calls exit() after execution.
 */
function F_login_form() {
	global $l, $thispage_title;
	global $xuser_name, $xuser_password;
		require_once('../config/tce_config.php');
	require_once('../../shared/code/tce_functions_form.php');
	
	$thispage_title = $l['t_login_form']; //set page title
	require_once('../code/tce_page_header.php');
	echo F_loginForm($_SERVER['SCRIPT_NAME'], "form_login", "post", "multipart/form-data", $xuser_name, $xuser_password, 20);
	require_once('../code/tce_page_footer.php');
	exit(); //break page here
}


/**
 * Display logout form.
 * @return XHTML string for logout form.
 */
function F_logout_form() {
	global $l;
		require_once('../config/tce_config.php');
	require_once('../../shared/code/tce_functions_form.php');
	
	$str = "";
    $str .= "\n<div class=\"container\">";
    $str .= "\n<div class=\"tceformbox\">";
    $str .= "<form action=\"../code/tce_logout.php\" method=\"post\" id=\"form_logout\" enctype=\"multipart/form-data\">";
    // description
    $str .= "\n<div class=\"row\">";
	$str .= $l['d_logout_desc'];
    $str .= "\n</div>";
    // buttons
    $str .= "\n<div class=\"row\">";
    // the following field is used to check if form has been submitted
	$str .= "\n<input type=\"hidden\" name=\"current_page\" id=\"current_page\" value=\"".$_SERVER['SCRIPT_NAME']."\" />";
	$str .= "\n<input type=\"hidden\" name=\"logaction\" id=\"logaction\" value=\"\" />";
	$str .= "\n<input type=\"submit\" name=\"login\" id=\"login\" value=\"".$l['w_logout']."\" />";
    $str .= "\n</div>";
    $str .= "\n</form>";
    $str .= "\n</div>";
    return $str;
}

/**
 * Display logout page.<br>
 * NOTE: This function calls exit() after execution.
 */
function F_logout_page() {
	global $l, $thispage_title;
		require_once('../config/tce_config.php');
	
	$thispage_title = $l['t_logout_form']; // set page title
	require_once('../code/tce_page_header.php');
	echo F_logout_form();
	require_once('../code/tce_page_footer.php');
	exit();
}

/**
 * Returns true if the current user is authorized to update and delete the selected database record.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-11
 * @param string $table table to be modified
 * @param string $field_id_name name of the main ID field of the table
 * @param int $value_id value of the ID field of the table
 * @param string $field_user_id name of the foreign key to to user_id
 * @return boolean true if the user is authorized, false otherwise
 */
function F_isAuthorizedUser($table, $field_id_name, $value_id, $field_user_id) {
	global $l,$db;
	require_once('../config/tce_config.php');
	
	// check for administrator
	if ($_SESSION['session_user_level'] >= K_AUTH_ADMINISTRATOR) {
		return true;
	}
	
	// check for original author
	if (F_count_rows($table."
		WHERE ".$field_id_name."=".$value_id."
			AND ".$field_user_id."=".$_SESSION['session_user_id']."
		LIMIT 1") > 0) {
		return true;
	}
	
	// check for author's groups
	// get author ID
	$author_id = 0;
	$sql = "SELECT ".$field_user_id."
		FROM ".$table."
		WHERE ".$field_id_name."=".$value_id."
		LIMIT 1";
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$author_id = $m[0];
		}
	} else {
		F_display_db_error();
	}
	if (($author_id > 1) 
		AND (F_count_rows(K_TABLE_USERGROUP." AS ta, ".K_TABLE_USERGROUP." AS tb
		WHERE ta.usrgrp_group_id=tb.usrgrp_group_id
			AND ta.usrgrp_user_id=".$author_id."
			AND tb.usrgrp_user_id=".$_SESSION['session_user_id']."
			LIMIT 1") > 0)) {
		return true;
	}
	
	return false;
}

/**
 * Returns a comma separated string of ID of the users that belong to the same groups.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-11
 * @param int $user_id user ID
 * @return int user group ID, 0 in case of error
 */
function F_getAuthorizedUsers($user_id) {
	global $l,$db;
	require_once('../config/tce_config.php');
	
	$str = ""; // string to return
	
	$sql = "SELECT tb.usrgrp_user_id
		FROM ".K_TABLE_USERGROUP." AS ta, ".K_TABLE_USERGROUP." AS tb
		WHERE ta.usrgrp_group_id=tb.usrgrp_group_id
			AND ta.usrgrp_user_id=".$user_id."";
	if($r = F_db_query($sql, $db)) {
		while($m = F_db_fetch_array($r)) {
			$str .= $m[0].",";
		}
	} else {
		F_display_db_error();
	}
	if (!empty($str)) {
		// remove last comma
		$str = substr($str,0,-1);
	}
	return $str;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
