<?php
//============================================================+
// File name   : tce_db_dal_mysql.php
// Begin       : 2003-10-12
// Last Update : 2006-10-01
// 
// Description : MySQL driver for TCExam Database Abstraction
//               Layer (DAL).
//               This abstraction use the same SQL syntax
//               of MySQL.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * MySQL driver for TCExam Database Abstraction Layer (DAL).
 * This abstraction layer uses the same SQL syntax of MySQL.
 * @package com.tecnick.tcexam.shared.mysql
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2003-10-12
 */

/**
 * Open a connection to a MySQL Server and select a database.
 * If a second call is made to mysql_connect() with the same arguments, no new link will be established, but instead, the link identifier of the already opened link will be returned.
 * @param string $server Database server path. It can also include a port number. e.g. "hostname:port" or a path to a local socket e.g. ":/path/to/socket" for the localhost. Note: Whenever you specify "localhost" or "localhost:port" as server, the MySQL client library will override this and try to connect to a local socket (named pipe on Windows). If you want to use TCP/IP, use "127.0.0.1" instead of "localhost". If the MySQL client library tries to connect to the wrong local socket, you should set the correct path as mysql.default_host in your PHP configuration and leave the server field blank.
 * @param string $username Name of the user that owns the server process.
 * @param string $password Password of the user that owns the server process.
 * @param string $database Database name.
 * @return MySQL link identifier on success, or FALSE on failure. 
 */
function F_db_connect($host = 'localhost', $port = '3306', $username = 'root', $password = '', $database = '') {
	if(!$db = @mysql_connect($host.":".$port, $username, $password)) {
		return FALSE;
	}
	if((strlen($database) > 0) AND (!@mysql_select_db($database, $db))) {
		return FALSE;
	}
	// set the correct charset encoding
	mysql_query("SET NAMES 'utf8'");
	mysql_query("SET CHARACTER_SET 'utf8'");
	return $db;
}

/**
 * Closes the non-persistent connection to a database associated with the given connection resource.
 * @param resource $link_identifier database link identifier.
 * @return bool TRUE on success or FALSE on failure
 */
function F_db_close($link_identifier) {
	return mysql_close($link_identifier);
}

/**
 * Returns the text of the error message from previous database operation
 * @return string error message.
 */
function F_db_error() {
	return "[".mysql_errno()."]: ".mysql_error()."";

}

/**
 * Sends a query to the currently active database on the server that's associated with the specified link identifier.<br>
 * NOTE: Convert PostgreSQL RANDOM() function to MySQL RAND() on ORDER BY clause of selection queries.
 * @param string $query The query tosend. The query string should not end with a semicolon. 
 * @param resource $link_identifier database link identifier.
 * @return FALSE in case of error, TRUE or resource-identifier in case of success.
 */
function F_db_query($query, $link_identifier) {
	// convert PostgreSQL RANDOM() function to MySQL RAND()
	$query = preg_replace("/ORDER BY RANDOM\(\)/i", "ORDER BY RAND()", $query);
	return mysql_query($query, $link_identifier);
}

/**
 * Fetch a result row as an associative and numeric array.
 * Note: This function sets NULL fields to PHP NULL value.
 * @param resource $result result resource to the query result.
 * @return Returns an array that corresponds to the fetched row, or FALSE if there are no more rows.
*/
function F_db_fetch_array($result) {
	return mysql_fetch_array($result);
}

/**
 * Returns number of rows (tuples) affected by the last INSERT, UPDATE or DELETE query associated with link_identifier.
 * @param resource $link_identifier database link identifier.
 * @param resource $result result resource to the query result [UNUSED].
 * @return Number of rows.
 */
function F_db_affected_rows($link_identifier, $result) {
	return mysql_affected_rows($link_identifier);
}

/**
 * Get number of rows in result.
 * @param resource $result result resource to the query result.
 * @return Number of affected rows.
 */
function F_db_num_rows($result) {
	return mysql_num_rows($result);
}

/**
 * Get the ID generated from the previous INSERT operation
 * @param resource $link_identifier database link identifier.
 * @param string Table name.
 * @param string Field name (column name).
 * @return int ID generated from the last INSERT operation.
 */
function F_db_insert_id($link_identifier, $tablename = '', $fieldname = '') {
	return mysql_insert_id($link_identifier);
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>