<?php
//============================================================+
// File name   : cp_class_mailer.php
// Begin       : 2001-10-20
// Last Update : 2006-03-08
// 
// Description : Extend PHPMailer class with inheritance
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * PHPMailer class extension.
 * @package PHPMailer
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2005-02-24
 */

/**
 */

require_once('../config/tce_config.php');

require_once('../../shared/config/tce_email_config.php'); //Include default public variables

// Set the custom error handler function 
// This suppress the warnings due to the fact that phpmailer class is written in PHP4
$old_error_handler = set_error_handler("F_error_handler", E_ERROR | E_WARNING | E_PARSE);
// include the phpmailer class
require_once("../../shared/phpmailer/class.phpmailer.php");

/**
 * C_mailer - PHPMailer class extension
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @package PHPMailer
 * @since 2005-02-24
 */
class C_mailer extends PHPMailer {

	/**
     * language array
     * @var string array
     */
	public $language;
		
	/**
	 * Replace the default SetError
	 * @var string $msg error message
	 * @access public
     * @return void
	 */
	public function SetError($msg) {
        $this->error_count++;
        $this->ErrorInfo = $msg;
        F_print_error("ERROR", $msg);
		exit;
    }
	
	/**
     * Returns a message in the appropriate language.
     * (override original Lang method).
     * @var string $key language key
     * @access private
     * @return string
     */
    public function Lang($key) {
        if(isset($this->language["m_mailerror_".$key])) {
            return $this->language["m_mailerror_".$key];
        }
        else {
            return "UNKNOW ERROR: [".$key."]";
        }
    }
} //end of class

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
