<?php
//============================================================+
// File name   : tce_config.php
// Begin       : 2001-10-23
// Last Update : 2006-09-26
//
// Description : Configuration file for public section.
//
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Configuration file for public section.
 * @package com.tecnick.tcexam.public
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-10-23
 */

/**
 */

// -- INCLUDE files -- 
require_once('../../shared/config/tce_config.php');

// -- DEFAULT META Tags --

/**
 * default site name
 */
define ("K_SITE_TITLE", "TCExam");

/**
 * default site description
 */
define ("K_SITE_DESCRIPTION", "TCExam by Tecnick.com");

/**
 * default site author
 */
define ("K_SITE_AUTHOR", "Nicola Asuni - Tecnick.com S.r.l.");

/**
 * default html reply-to meta tag
 */
define ("K_SITE_REPLY", "");

/**
 * default keywords
 */
define ("K_SITE_KEYWORDS", "TCExam, eExam, e-exam, web, exam");

/**
 * path to default html icon
 */
define ("K_SITE_ICON", "../../favicon.ico");

/**
 * path to public CSS stylesheet
 */
define ("K_SITE_STYLE", K_PATH_STYLE_SHEETS."default.css");

// -- Options / COSTANTS --

/**
 * max number of rows to display in tables
 */
define ("K_MAX_ROWS_PER_PAGE", 50);

/**
 * max file size to be uploaded [bytes]
 */
define ("K_MAX_UPLOAD_SIZE", 1000000);

/**
 * max memory limit for a PHP script
 */
define ("K_MAX_MEMORY_LIMIT", "8M");

/**
 * main page (homepage)
 */
define ("K_MAIN_PAGE", "index.php");

// -- INCLUDE files -- 
require_once('../../shared/config/tce_db_config.php');
require_once('../../shared/code/tce_db_connect.php');
require_once('../../shared/code/tce_functions_general.php');

ini_set("memory_limit", K_MAX_MEMORY_LIMIT); //set memory limit
ini_set("session.use_trans_sid", 0); //if =1 use PHPSESSID (for clients that do not support cookies)

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
