<?php
//============================================================+
// File name   : tce_xhtml_header.php
// Begin       : 2004-04-24
// Last Update : 2006-03-02
// 
// Description : Output defaults XHTML header (doctype + head).
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Outputs default XHTML header (doctype + head).
 * @package com.tecnick.tcexam.public
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-04-24
 * int $pagelevel page access level (0-10), default 0
 * string $thispage_title page title, default K_SITE_TITLE
 * string $thispage_description page description, default K_SITE_DESCRIPTION
 * string $thispage_author page author, default K_SITE_AUTHOR
 * string $thispage_reply page reply to, default K_SITE_REPLY_TO
 * string $thispage_keywords page keywords, default K_SITE_KEYWORDS
 * string $thispage_icon page icon, default K_SITE_ICON
 * string $thispage_style page CSS file name, default K_SITE_STYLE
 */

/**
 */

// if necessary load default values
if(!isset($pagelevel) OR empty($pagelevel)) {$pagelevel = 0;}
if(!isset($thispage_title) OR empty($thispage_title)) {$thispage_title = K_SITE_TITLE;}
if(!isset($thispage_description) OR empty($thispage_description)) {$thispage_description = K_SITE_DESCRIPTION;}
if(!isset($thispage_author) OR empty($thispage_author)) {$thispage_author = K_SITE_AUTHOR;}
if(!isset($thispage_reply) OR empty($thispage_reply)) {$thispage_reply = K_SITE_REPLY;}
if(!isset($thispage_keywords) OR empty($thispage_keywords)) {$thispage_keywords = K_SITE_KEYWORDS;}
if(!isset($thispage_icon) OR empty($thispage_icon)) {$thispage_icon = K_SITE_ICON;}
if(!isset($thispage_style) OR empty($thispage_style)) {$thispage_style = K_SITE_STYLE;}

echo "<"."?"."xml version=\"1.0\" encoding=\"".$l['a_meta_charset']."\" "."?".">\n";
echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
echo "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"".$l['a_meta_language']."\" lang=\"".$l['a_meta_language']."\" dir=\"".$l['a_meta_dir']."\">\n\n";

echo "<head>\n";
echo "<title>".htmlspecialchars($thispage_title, ENT_NOQUOTES, $l['a_meta_charset'])."</title>\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$l['a_meta_charset']."\" />\n";
echo "<meta name=\"tcexam_level\" content=\"".$pagelevel."\" />\n";
echo "<meta name=\"description\" content=\"".htmlspecialchars($thispage_description, ENT_COMPAT, $l['a_meta_charset'])."\" />\n";
echo "<meta name=\"author\" content=\"".htmlspecialchars($thispage_author, ENT_COMPAT, $l['a_meta_charset'])."\" />\n";
echo "<meta name=\"reply-to\" content=\"".htmlspecialchars($thispage_reply, ENT_COMPAT, $l['a_meta_charset'])."\" />\n";
echo "<meta name=\"keywords\" content=\"".htmlspecialchars($thispage_keywords, ENT_COMPAT, $l['a_meta_charset'])."\" />\n";
echo "<link rel=\"stylesheet\" href=\"".$thispage_style."\" type=\"text/css\" />\n";
echo "<link rel=\"shortcut icon\" href=\"".$thispage_icon."\" />\n";
echo "</head>\n\n";

echo "<body>\n";

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
