<?php
//============================================================+
// File name   : tce_test_results.php
// Begin       : 2004-06-10
// Last Update : 2006-09-26
// 
// Description : Display test results for current user.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display test results for current user.
 * @package com.tecnick.tcexam.public
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-06-10
 * @uses F_lockUserTest
 * @uses F_getUserTestStat
 * @uses F_testInfoLink
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = 1;
$thispage_title = $l['t_test_results'];
$thispage_description = $l['hp_test_execute'];
require_once('../../shared/code/tce_authorization.php');

$formname = "testform";

require_once('../code/tce_page_header.php');

echo "<div class=\"container\">\n";

if (isset($_REQUEST['testid']) AND ($_REQUEST['testid'] > 0)) {
	require_once('../../shared/code/tce_functions_test.php');
	require_once('../../shared/code/tce_functions_test_stats.php');
	
	$K_ENABLE_RESULTS_TO_USERS = false;
	$sql = "SELECT test_id, test_results_to_users 
		FROM ".K_TABLE_TESTS." 
		WHERE test_id=".$_REQUEST['testid']."";
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) { // for each active test
			$K_ENABLE_RESULTS_TO_USERS = $m['test_results_to_users'];
		}
	} else {
		F_display_db_error();
	}
	
	if ($K_ENABLE_RESULTS_TO_USERS) {
		//lock user's test
		F_lockUserTest($_REQUEST['testid'], $_SESSION['session_user_id']);
		
		// get user's test stats
		$usrtestdata = F_getUserTestStat($_REQUEST['testid'], $_SESSION['session_user_id']);
		
		// display results
		
		echo "<div class=\"container\">\n";
		echo "<div class=\"tceformbox\">\n";
		
		echo "<div class=\"row\"><span class=\"label\">";
		echo "<span title=\"".$l['h_test_name']."\">".$l['w_test'].": </span>\n";
		echo "</span><span class=\"formw\">";
		echo "".F_getTestName($_REQUEST['testid'])." [".F_testInfoLink($m['test_id'], $l['w_info'])."]";
		echo "</span></div>\n";
		
		echo "<div class=\"row\"><span class=\"label\">";
		echo "<span title=\"".$l['h_score']."\">".$l['w_score'].": </span>\n";
		echo "</span><span class=\"formw\">";
		echo "".$usrtestdata['score']."";
		echo " (".round(100 * $usrtestdata['score'] / $usrtestdata['max_score'])."%)";
		echo "</span></div>\n";
		
		echo "<div class=\"row\"><span class=\"label\">";
		echo "<span title=\"".$l['h_answers_right']."\">".$l['w_answers_right'].": </span>\n";
		echo "</span><span class=\"formw\">";
		echo "".$usrtestdata['right']."";
		echo " (".round(100 * $usrtestdata['right'] / $usrtestdata['all'])."%)";
		echo "</span></div>\n";
		
		echo "<div class=\"row\"><span class=\"label\">";
		echo "<span title=\"".$l['h_answers_wrong']."\">".$l['w_answers_wrong'].": </span>\n";
		echo "</span><span class=\"formw\">";
		echo "".$usrtestdata['wrong']."";
		echo " (".round(100 * $usrtestdata['wrong'] / $usrtestdata['all'])."%)";
		echo "</span></div>\n";
		
		echo "<div class=\"row\"><span class=\"label\">";
		echo "<span title=\"".$l['h_questions_unanswered']."\">".$l['w_questions_unanswered'].": </span>\n";
		echo "</span><span class=\"formw\">";
		echo "".$usrtestdata['unanswered']."";
		echo " (".round(100 * $usrtestdata['unanswered'] / $usrtestdata['all'])."%)";
		echo "</span></div>\n";
		
		echo "<div class=\"row\"><span class=\"label\">";
		echo "<span title=\"".$l['h_questions_undisplayed']."\">".$l['w_questions_undisplayed'].": </span>\n";
		echo "</span><span class=\"formw\">";
		echo "".$usrtestdata['undisplayed']."";
		echo " (".round(100 * $usrtestdata['undisplayed'] / $usrtestdata['all'])."%)";
		echo "</span></div>\n";
		
		echo "<div class=\"spacer\"></div>";
		
		echo "</div>\n";
		echo "</div>\n";
	}
}

echo "<a href=\"index.php\" title=\"".$l['h_index']."\">&lt; ".$l['w_index']."</a>\n";

echo "<div class=\"pagehelp\">".$l['hp_test_results']."</div>\n";

echo "</div>\n"; // container

require_once('../code/tce_page_footer.php');

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
