<?php
//============================================================+
// File name   : tce_test_execute.php
// Begin       : 2004-05-29
// Last Update : 2006-11-08
// 
// Description : execute a specific test
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Execute a specific test.
 * @package com.tecnick.tcexam.public
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-05-29
 * @uses F_executeTest
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = 1;
$thispage_title = $l['t_test_execute'];
$thispage_description = $l['hp_test_execute'];
require_once('../../shared/code/tce_authorization.php');
require_once('../../shared/code/tce_functions_form.php');

$formname = "testform";

if (isset($_REQUEST['testid']) AND ($_REQUEST['testid'] > 0)) {
	require_once('../../shared/code/tce_functions_test.php');
	if (F_executeTest($_REQUEST['testid'])) {
		
		if (isset($_REQUEST['forceterminate']) AND (!empty($_REQUEST['forceterminate']))) {
			// terminate the test (lock the test to status=4
			F_terminateUserTest($_REQUEST['testid']);
			// logout the user
			require_once('tce_logout.php');
			exit;
		}
		
		// the user is authorized to execute the selected test
		$thispage_title .= ": ".F_getTestName($_REQUEST['testid']);
		
		require_once('../code/tce_page_header.php');
		echo "<div class=\"container\">\n";
		
		echo "[".F_testInfoLink($_REQUEST['testid'], $l['w_info'])."]<br /><br />";
		
		if (!isset($_REQUEST['terminationform'])) {
			if (isset($_REQUEST['testlogid']) AND F_isRightTestlogUser($_REQUEST['testid'], $_REQUEST['testlogid'])) {
				// the form has been submitted, update testlogid data
				if (!isset($_REQUEST['answerid'])) {
					$_REQUEST['answerid'] = 0;
				}
				if (!isset($_REQUEST['answertext'])) {
					$_REQUEST['answertext'] = "";
				}
				
				F_updateQuestionLog($_REQUEST['testid'], $_REQUEST['testlogid'], $_REQUEST['answerid'], $_REQUEST['answertext']);
				
				// update user's test comment
				if (isset($_REQUEST['testcomment'])) {
					F_updateTestComment($_REQUEST['testid'], $_REQUEST['testcomment']);
				}
				
				if (isset($_REQUEST['nextquestion']) AND ($_REQUEST['nextquestionid']>0)) {
					$_REQUEST['testlogid'] = 0 + $_REQUEST['nextquestionid'];
				} elseif (isset($_REQUEST['prevquestion']) AND ($_REQUEST['prevquestionid']>0)) {
					$_REQUEST['testlogid'] = $_REQUEST['prevquestionid'];
				} else {
					while(list($key,$value) = each($_POST)) {
						if (preg_match("/jumpquestion_([0-9]+)/", $key, $matches) > 0) {
							$_REQUEST['testlogid'] = $matches[1];
							break;
						}
					}
				}
			} else {
				$_REQUEST['testlogid'] = 0;
			}
		}
		// confirmation form to terminate the test
		if (isset($_REQUEST['terminatetest']) AND (!empty($_REQUEST['terminatetest']))) {
			F_print_error("WARNING", $l['m_confirm_test_termination']);
			?>
			<div class="confirmbox">
			<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_test_terminate">
			<div>
			<input type="hidden" name="testid" id="testid" value="<?php echo $_REQUEST['testid']; ?>" />
			<input type="hidden" name="testlogid" id="testlogid" value="<?php echo $_REQUEST['testlogid']; ?>" />
			<input type="hidden" name="terminationform" id="terminationform" value="1" />
			<?php 
			F_submit_button("forceterminate", $l['w_terminate'], $l['w_terminate_exam']);
			F_submit_button("cancel", $l['w_cancel'], $l['h_cancel']);
			?>
			</div>
			</form>
			</div>
			<?php
		} else {
			echo "<form action=\"".$_SERVER['SCRIPT_NAME']."\" method=\"post\" enctype=\"multipart/form-data\" id=\"".$formname."\">\n";
			echo "<div>\n";
			
			// display questions + navigation menu
			echo F_questionForm($_REQUEST['testid'], $_REQUEST['testlogid'], $formname);
			
			// the $finish variable is used to check if the form has been automatically submitted
			// at the end of the time.
			if (isset($_REQUEST['finish']) AND ($_REQUEST['finish'] > 0)) {
				$finish = 1;
			} else {
				$finish = 0;
			}
			echo "<input type=\"hidden\" name=\"finish\" id=\"finish\" value=\"".$finish."\" />\n";
			
			// textarea field for user's comment
			echo F_testComment($_REQUEST['testid']);
			
			// test termination button
			F_submit_button("terminatetest", $l['w_terminate_exam'], $l['w_terminate_exam']);
			
			echo "\n</div>\n";
			echo "</form>\n";
		}
		
		// start the countdown if disabled
		if (isset($examtime)) {
			echo "<script type=\"text/javascript\">\n";
			echo "//<![CDATA[\n";
			echo "if(!enable_countdown) {\n";
			echo "	FJ_start_timer('true', ".(time() - $examtime).", '".addslashes($l['m_exam_end_time'])."');\n";
			echo "}\n";
			echo "//]]>\n";
			echo "</script>\n";
		}
	}
} else {
	require_once('../code/tce_page_header.php');
	echo "<div class=\"container\">\n";
}

echo "<div class=\"pagehelp\">".$l['hp_test_execute']."</div>\n";

echo "</div>\n"; // container

require_once('../code/tce_page_footer.php');

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
