<?php
//============================================================+
// File name   : tce_login.php
// Begin       : 2002-03-21
// Last Update : 2006-03-02
// 
// Description : Display Login interface and redirect to main 
//               page.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display Login interface and redirect to main page.
 * @package com.tecnick.tcexam.public
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2002-03-21
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = 1;
require_once('../../shared/code/tce_authorization.php');

echo "<"."?xml version=\"1.0\" encoding=\"".$l['a_meta_charset']."\"?".">\n";
echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
echo "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"".$l['a_meta_language']."\" lang=\"".$l['a_meta_language']."\" dir=\"".$l['a_meta_dir']."\">\n";
echo "<head>\n";
echo "<title>LOGIN</title>\n";
echo "<meta http-equiv=\"refresh\" content=\"0;url=".K_MAIN_PAGE."\" />\n"; //reload page
echo "</head>\n";
echo "<body>\n";
echo "<a href=\"".htmlspecialchars(urldecode(K_MAIN_PAGE), ENT_COMPAT, $l['a_meta_charset'])."\" target=\"_top\">LOGIN...</a>\n";
echo "</body>\n";
echo "</html>\n";

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
