<?php
//============================================================+
// File name   : tce_config.php
// Begin       : 2001-09-02
// Last Update : 2006-09-26
// 
// Description : Configuration file for administration section.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Configuration file for administration section.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-09-02
 */

/**
 */

// -- INCLUDE files -- 
require_once('../config/tce_auth.php');
require_once('../../shared/config/tce_config.php');

// -- Options / COSTANTS --

/**
 * max memory limit
 */
define ("K_MAX_MEMORY_LIMIT", "512M");

/**
 * max number of rows to display in tables
 */
define ("K_MAX_ROWS_PER_PAGE", 50);

/**
 * max size to be uploaded in bytes
 */
define ("K_MAX_UPLOAD_SIZE", 10000000);

// -- DEFAULT META and BODY Tags --

/**
 * TCExam title
 */
define ("K_TCEXAM_TITLE", "TCExam");

/**
 * TCExam description
 */
define ("K_TCEXAM_DESCRIPTION", "TCExam by Tecnick.com");

/**
 * TCExam Author
 */
define ("K_TCEXAM_AUTHOR", "Nicola Asuni - Tecnick.com S.r.l.");

/**
 * reply-to meta tag
 */
define ("K_TCEXAM_REPLY_TO", "");

/**
 * default html meta keywords
 */
define ("K_TCEXAM_KEYWORDS", "TCExam, eExam, e-exam, web, exam");

/**
 * relative path to html icon
 */
define ("K_TCEXAM_ICON", "../../favicon.ico");

/**
 * full path to CSS stylesheet
 */
define ("K_TCEXAM_STYLE", K_PATH_STYLE_SHEETS."default.css");

/**
 * full path to CSS stylesheet for help file
 */
define ("K_TCEXAM_HELP_STYLE", K_PATH_STYLE_SHEETS."help.css");

/**
 * if true display admin clock in UTC (GMT)
 */
define ("K_CLOCK_IN_UTC", false);

/**
 * max number of chars to display on a selection box
 */
define ("K_SELECT_SUBSTRING", 40);

// -- INCLUDE files -- 
require_once('../../shared/config/tce_db_config.php');
require_once('../../shared/code/tce_db_connect.php');
require_once('../../shared/code/tce_functions_general.php');

ini_set("memory_limit", K_MAX_MEMORY_LIMIT); //set memory limit
ini_set("upload_max_filesize", K_MAX_UPLOAD_SIZE); //set max upload size
ini_set("post_max_size", K_MAX_UPLOAD_SIZE); //set max post size
ini_set("session.use_trans_sid", 0); //if =1 use PHPSESSID 

//============================================================+
// END OF FILE                                                 
//============================================================+
?>