<?php
//============================================================+
// File name   : tce_auth.php
// Begin       : 2002-09-02
// Last Update : 2006-03-11
// 
// Description : Define access levels for each admin page
//               Note:
//                0 = Anonymous user (uregistered user)
//                1 = registered user
//               10 = System Administrator
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Congiguration file: define access levels for each admin page.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2002-09-02
 */

// ************************************************************
// SECURITY WARNING :
// SET THIS FILE AS READ ONLY AFTER MODIFICATIONS   
// ************************************************************

/**
 * required user's level to access index page
 */
define ("K_AUTH_INDEX", 5);

/**
 * required user's level to access "user editor"
 */
define ("K_AUTH_ADMIN_USERS", 5);

/**
 * required user's level to access "tcecode editor"
 */
define ("K_AUTH_ADMIN_TCECODE", 5);

/**
 * required user's level to access "subject editor"
 */
define ("K_AUTH_ADMIN_SUBJECTS", 5);

/**
 * required user's level to access "question editor"
 */
define ("K_AUTH_ADMIN_QUESTIONS", 5);

/**
 * required user's level to access "answer editor"
 */
define ("K_AUTH_ADMIN_ANSWERS", 5);

/**
 * required user's level to access "test editor"
 */
define ("K_AUTH_ADMIN_TESTS", 5);

/**
 * required user's level to access "TCExam information"
 */
define ("K_AUTH_ADMIN_INFO", 0);

/**
 * required user's level to display online users
 */
define ("K_AUTH_ADMIN_ONLINE_USERS", 5);

/**
 * required user's level to upload images
 */
define ("K_AUTH_ADMIN_UPLOAD_IMAGES", 5);

/**
 * required user's level to manually rate free text answers
 */
define ("K_AUTH_ADMIN_RATING", 5);

/**
 * required user's level to display results
 */
define ("K_AUTH_ADMIN_RESULTS", 5);

/**
 * administrator level
 */
define ("K_AUTH_ADMINISTRATOR", 10);

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
