<?php
//============================================================+
// File name   : tce_xml_users.php
// Begin       : 2006-03-17
// Last Update : 2006-09-29
// 
// Description : Functions to export users using XML format.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display all users in XML format.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-17
 */

/**
 */

// send XML headers

// fix for IE catching or PHP bug issue
header("Pragma: public");
// Date in the past
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
// always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header('Content-Description: XML');
// xml content type
//header("Content-type: text/xml");
// force download dialog
header("Content-Type: application/force-download");
header("Content-Type: application/octet-stream", false);
header("Content-Type: application/download", false);
// use the Content-Disposition header to supply a recommended filename and 
// force the browser to display the save dialog.
header("Content-Disposition: attachment; filename=tcexam_users_".$_REQUEST['subject_id']."_".date("YmdHis").".xml;");
/*
The Content-transfer-encoding header should be binary, since the file will be read 
directly from the disk and the raw bytes passed to the downloading computer.
The Content-length header is useful to set for downloads. The browser will be able to 
show a progress meter as a file downloads. The content-lenght can be determines by 
filesize function returns the size of a file. 
*/
header("Content-Transfer-Encoding: binary");

echo F_xml_export_users();

/**
 * Export all users to XML grouped by users' groups.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-17
 * @return XML data
 */
function F_xml_export_users() {
	global $l, $db;
		require_once('../config/tce_config.php');
	
	$boolean = array("false","true");
	
	$xml = ""; // XML data to be returned
	
	$xml .= "<"."?xml version=\"1.0\" encoding=\"UTF-8\" ?".">\n";
	$xml .= "<tcexamusers version=\"".K_TCEXAM_VERSION."\">\n";
	$xml .= "\t<header";
	$xml .= " lang=\"".K_LANGUAGE."\"";
	$xml .= " date=\"".date(K_TIMESTAMP_FORMAT)."\">\n";
	$xml .= "\t</header>\n";
	$xml .= "\t<body>\n";
	
	// add users
	$sqla = "SELECT * 
		FROM ".K_TABLE_USERS."
		ORDER BY user_lastname,user_firstname,user_name";
	if($ra = F_db_query($sqla, $db)) {
		while($ma = F_db_fetch_array($ra)) {
			
			$xml .= "\t\t\t<user id=\"".$ma['user_id']."\">\n";
			
			$xml .= "\t\t\t\t<name>";
			$xml .= F_text_to_xml($ma['user_name']);
			$xml .= "</name>\n";
			
			$xml .= "\t\t\t\t<password>";
			// password cannot be exported because is encrypted
			//$xml .= $ma['user_password'];
			$xml .= "</password>\n";
			
			$xml .= "\t\t\t\t<email>";
			$xml .= $ma['user_email'];
			$xml .= "</email>\n";
			
			$xml .= "\t\t\t\t<regdate>";
			$xml .= $ma['user_regdate'];
			$xml .= "</regdate>\n";
			
			$xml .= "\t\t\t\t<ip>";
			$xml .= $ma['user_ip'];
			$xml .= "</ip>\n";
			
			$xml .= "\t\t\t\t<firstname>";
			$xml .= F_text_to_xml($ma['user_firstname']);
			$xml .= "</firstname>\n";
			
			$xml .= "\t\t\t\t<lastname>";
			$xml .= F_text_to_xml($ma['user_lastname']);
			$xml .= "</lastname>\n";
			
			$xml .= "\t\t\t\t<birthdate>";
			$xml .= $ma['user_birthdate'];
			$xml .= "</birthdate>\n";
			
			$xml .= "\t\t\t\t<birthplace>";
			$xml .= F_text_to_xml($ma['user_birthplace']);
			$xml .= "</birthplace>\n";
			
			$xml .= "\t\t\t\t<regnumber>";
			$xml .= F_text_to_xml($ma['user_regnumber']);
			$xml .= "</regnumber>\n";
			
			$xml .= "\t\t\t\t<ssn>";
			$xml .= F_text_to_xml($ma['user_ssn']);
			$xml .= "</ssn>\n";
			
			$xml .= "\t\t\t\t<level>";
			$xml .= $ma['user_level'];
			$xml .= "</level>\n";
			
			$xml .= "\t\t\t\t<verifycode>";
			$xml .= $ma['user_verifycode'];
			$xml .= "</verifycode>\n";
			
			// add user's groups
			$sqlg = "SELECT * 
				FROM ".K_TABLE_GROUPS.",".K_TABLE_USERGROUP."
				WHERE usrgrp_group_id=group_id
					AND usrgrp_user_id=".$ma['user_id']."
				ORDER BY group_name";
			if($rg = F_db_query($sqlg, $db)) {
				while($mg = F_db_fetch_array($rg)) {
					$xml .= "\t\t\t\t<group id=\"".$mg['group_id']."\">";
					$xml .= $mg['group_name'];
					$xml .= "</group>\n";
				}
			}
			else {
				F_display_db_error();
			}
			
			$xml .= "\t\t\t</user>\n";
		}
	}
	else {
		F_display_db_error();
	}
	
	$xml .= "\t</body>\n";
	$xml .= "</tcexamusers>\n";
	return $xml;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
