<?php
//============================================================+
// File name   : tce_xml_questions.php
// Begin       : 2006-03-06
// Last Update : 2006-03-31
// 
// Description : Functions to export questions using XML
//               format.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display all questions grouped by topic in XML format.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-11
 */

/**
 */

// send XML headers

// fix for IE catching or PHP bug issue
header("Pragma: public");
// Date in the past
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
// always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header('Content-Description: XML');
// xml content type
//header("Content-type: text/xml");
// force download dialog
header("Content-Type: application/force-download");
header("Content-Type: application/octet-stream", false);
header("Content-Type: application/download", false);
// use the Content-Disposition header to supply a recommended filename and 
// force the browser to display the save dialog.
header("Content-Disposition: attachment; filename=tcexam_questions_".$_REQUEST['subject_id']."_".date("YmdHis").".xml;");
/*
The Content-transfer-encoding header should be binary, since the file will be read 
directly from the disk and the raw bytes passed to the downloading computer.
The Content-length header is useful to set for downloads. The browser will be able to 
show a progress meter as a file downloads. The content-lenght can be determines by 
filesize function returns the size of a file. 
*/
header("Content-Transfer-Encoding: binary");

echo F_xml_export_questions($_REQUEST['subject_id']);

/**
 * Export all questions of the selected subject to XML.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-06
 * @param string $subject_id topic ID
 * @return XML data
 */
function F_xml_export_questions($subject_id) {
	global $l, $db;
		require_once('../config/tce_config.php');
	
	$boolean = array("false","true");
	$type = array("single","multiple","text");
	
	$xml = ""; // XML data to be returned
	
	$xml .= "<"."?xml version=\"1.0\" encoding=\"UTF-8\" ?".">\n";
	$xml .= "<tcexamquestions version=\"".K_TCEXAM_VERSION."\">\n";
	$xml .= "\t<header";
	$xml .= " lang=\"".K_LANGUAGE."\"";
	$xml .= " date=\"".date(K_TIMESTAMP_FORMAT)."\">\n";
	$xml .= "\t</header>\n";
	$xml .= "\t<body>\n";
	
	$sql = "SELECT * 
		FROM ".K_TABLE_QUESTIONS."
		WHERE question_subject_id=".$subject_id."";
	if($r = F_db_query($sql, $db)) {
		while($m = F_db_fetch_array($r)) {
			
			$xml .= "\t\t<question>\n";
			
			$xml .= "\t\t\t<enabled>";
			$xml .= $boolean[intval(F_getBoolean($m['question_enabled']))];
			$xml .= "</enabled>\n";
			
			$xml .= "\t\t\t<type>";
			$xml .= $type[$m['question_type']-1];
			$xml .= "</type>\n";
			
			$xml .= "\t\t\t<difficulty>";
			$xml .= $m['question_difficulty'];
			$xml .= "</difficulty>\n";
			
			$xml .= "\t\t\t<description>";
			$xml .=  F_text_to_xml($m['question_description']);
			$xml .= "</description>\n";
			
			if ($m['question_type'] < 3) {
				// add each answer option
				$sqla = "SELECT *
					FROM ".K_TABLE_ANSWERS."
					WHERE answer_question_id='".$m['question_id']."'
					ORDER BY answer_isright DESC";
				if($ra = F_db_query($sqla, $db)) {
					while($ma = F_db_fetch_array($ra)) {
						
						$xml .= "\t\t\t<answer>\n";
						
						$xml .= "\t\t\t\t<enabled>";
						$xml .= $boolean[intval(F_getBoolean($ma['answer_enabled']))];
						$xml .= "</enabled>\n";
						
						$xml .= "\t\t\t\t<isright>";
						$xml .= $boolean[intval(F_getBoolean($ma['answer_isright']))];
						$xml .= "</isright>\n";
						
						$xml .= "\t\t\t\t<description>";
						$xml .=  F_text_to_xml($ma['answer_description']);
						$xml .= "</description>\n";
						
						$xml .= "\t\t\t</answer>\n";
					}
				}
				else {
					F_display_db_error();
				}
			} // end multiple answers
			$xml .= "\t\t</question>\n";
		}
	}
	else {
		F_display_db_error();
	}
	
	$xml .= "\t</body>\n";
	$xml .= "</tcexamquestions>\n";
	return $xml;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
