<?php
//============================================================+
// File name   : tce_show_result_user.php
// Begin       : 2004-06-10
// Last Update : 2006-10-01
// 
// Description : Display test results for specified user.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display test results for specified user.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-06-10
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_RESULTS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_result_user'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../../shared/code/tce_functions_test.php');
require_once('../../shared/code/tce_functions_test_stats.php');
require_once('../code/tce_functions_auth_sql.php');

define("K_EXTEND_TIME_MINUTES",5);

if (isset($selectcategory)) {
	$changecategory = 1;
}

if(isset($_POST['lock'])) {
	$menu_mode = "lock";
} elseif(isset($_POST['unlock'])) {
	$menu_mode = "unlock";
} elseif(isset($_POST['extendtime'])) {
	$menu_mode = "extendtime";
}

switch($menu_mode) {
	
	case "delete":{
		F_stripslashes_formfields(); 
		// ask confirmation
		F_print_error("WARNING", $l['m_delete_confirm']);
		?>
		<div class="confirmbox">
		<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_delete">
		<div>
		
		<input type="hidden" name="testuser_id" id="testuser_id" value="<?php echo $testuser_id; ?>" />
		<?php 
		F_submit_button("forcedelete", $l['w_delete'], $l['h_delete']);
		F_submit_button("cancel", $l['w_cancel'], $l['h_cancel']);
		?>
		</div>
		</form>
		</div>
		<?php
		break;
	}
	
	case "forcedelete":{
		F_stripslashes_formfields(); // Delete
		if($forcedelete == $l['w_delete']) { //check if delete button has been pushed (redundant check)
				$sql = "DELETE FROM ".K_TABLE_TEST_USER." 
					WHERE testuser_id=".$testuser_id."";
				if(!$r = F_db_query($sql, $db)) {
					F_display_db_error();
				} else {
					$testuser_id = false;
					F_print_error("MESSAGE", "".$l['m_deleted']."");
				}
		}
		break;
	}
	
	case "extendtime":{
		// extend the test time by 5 minutes
		// this time extension is obtained moving forward the test starting time
		$sqlu = "UPDATE ".K_TABLE_TEST_USER."
			SET testuser_creation_time=testuser_creation_time+'".(K_EXTEND_TIME_MINUTES*K_SECONDS_IN_MINUTE)."'
			WHERE testuser_id=".$testuser_id."";
		if(!$ru = F_db_query($sqlu, $db)) {
			F_display_db_error();
		} else {
			F_print_error("MESSAGE", $l['m_updated']);
		}
		break;
	}
	
	case "lock":{
		// update test mode to 4 = test locked
		$sqlu = "UPDATE ".K_TABLE_TEST_USER."
			SET testuser_status=4 
			WHERE testuser_id=".$testuser_id."";
		if(!$ru = F_db_query($sqlu, $db)) {
			F_display_db_error();
		} else {
			F_print_error("MESSAGE", $l['m_updated']);
		}
		break;
	}
	
	case "unlock":{
		// update test mode to 1 = test unlocked
		$sqlu = "UPDATE ".K_TABLE_TEST_USER."
			SET testuser_status=1 
			WHERE testuser_id=".$testuser_id."";
		if(!$ru = F_db_query($sqlu, $db)) {
			F_display_db_error();
		} else {
			F_print_error("MESSAGE", $l['m_updated']);
		}
		break;
	}
	
	default: { 
		break;
	}

} //end of switch

// --- Initialize variables

if(!isset($test_id) OR empty($test_id)) {
	// select default test ID
	$sql = F_select_executed_tests_sql()." LIMIT 1";
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$test_id = $m['test_id'];
		} else {
			$test_id = 0;
		}
	}
	else {
		F_display_db_error();
	}
}

if($formstatus) {
	if ((isset($changecategory) AND ($changecategory > 0)) OR (!isset($user_id)) OR empty($user_id)) {
			$sql = "SELECT testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_status, user_lastname, user_firstname, user_name, SUM(testlog_score) AS test_score
				FROM ".K_TABLE_TEST_USER.", ".K_TABLE_TESTS_LOGS.", ".K_TABLE_USERS." 
				WHERE testlog_testuser_id=testuser_id
					AND testuser_user_id=user_id
					AND testuser_test_id=".$test_id." 
					AND testuser_status>0
				GROUP BY testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_status, user_lastname, user_firstname, user_name
				ORDER BY testuser_test_id, user_lastname, user_firstname
				LIMIT 1";
	}
	else {
		$sql = "SELECT testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_status, user_lastname, user_firstname, user_name, SUM(testlog_score) AS test_score
			FROM ".K_TABLE_TEST_USER.", ".K_TABLE_TESTS_LOGS.", ".K_TABLE_USERS." 
			WHERE testlog_testuser_id=testuser_id
				AND testuser_user_id=user_id
				AND testuser_test_id=".$test_id."
				AND testuser_user_id=".$user_id."
				AND testuser_status>0
			GROUP BY testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_status, user_lastname, user_firstname, user_name
			LIMIT 1";
	}
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$testuser_id = $m['testuser_id'];
			$test_id = $m['testuser_test_id'];
			$user_id = $m['testuser_user_id'];
			$user_lastname = $m['user_lastname'];
			$user_firstname = $m['user_firstname'];
			$user_name = $m['user_name'];
			$test_start_time = $m['testuser_creation_time'];
			$test_score = $m['test_score'];
			$testuser_status = $m['testuser_status'];
			$usrtestdata = F_getUserTestStat($test_id, $user_id);
		}
		else {
			$testuser_id = "";
			$testlog_test_id = "";
			$testlog_user_id = "";
			$user_lastname = "";
			$user_firstname = "";
			$user_name = "";
			$test_start_time = "";
			$test_score = "";
			$testuser_status = 0;
		}
	}
	else {
		F_display_db_error();
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_resultuser">

<div class="row">
<span class="label">
<label for="test_id"><?php echo $l['w_test']; ?></label>
</span>
<span class="formw">
<input type="hidden" name="testuser_id" id="testuser_id" value="<?php echo $testuser_id; ?>" />
<input type="hidden" name="changecategory" id="changecategory" value="" />
<select name="test_id" id="test_id" size="0" onchange="document.getElementById('form_resultuser').changecategory.value=1;document.getElementById('form_resultuser').submit()" title="<?php echo $l['h_test']; ?>">
<?php
$sql = F_select_executed_distinct_tests_sql();
if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['test_id']."\"";
		if($m['test_id'] == $test_id) {
			echo " selected=\"selected\"";
		}
		echo ">".substr($m['test_begin_time'], 0, 10)." ".htmlspecialchars($m['test_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
	}
}
else {
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectcategory" id="selectcategory" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row">
<span class="label">
<label for="user_id"><?php echo $l['w_user']; ?></label>
</span>
<span class="formw">
<select name="user_id" id="user_id" size="0" onchange="document.getElementById('form_resultuser').submit()" title="<?php echo $l['h_select_user']; ?>">
<?php
$sql = "SELECT user_id, user_lastname, user_firstname, user_name
	FROM ".K_TABLE_TEST_USER.", ".K_TABLE_USERS." 
	WHERE testuser_user_id=user_id
	AND testuser_test_id=".$test_id."
	ORDER BY user_lastname, user_firstname, user_name";
if($r = F_db_query($sql, $db)) {
	$usrcount = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['user_id']."\"";
		if($m['user_id'] == $user_id) {
			echo " selected=\"selected\"";
		}
		echo ">";
		echo "".$usrcount.". ";
		echo "".htmlspecialchars(strtoupper($m['user_lastname'])." ".$m['user_firstname']." - ".$m['user_name']."", ENT_NOQUOTES, $l['a_meta_charset'])."";
		echo "</option>\n";
		$usrcount++;
	}
}
else {
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row"><hr /></div>

<?php
if (isset($usrtestdata)) {
?>

<div class="row">
<span class="label">
<span title="<?php echo $l['h_time_begin']; ?>"><?php echo $l['w_time_begin']; ?>:</span>
</span>
<span class="formw">
<?php
echo "".$test_start_time." ";
if (isset($test_id) AND ($test_id > 0) AND isset($user_id) AND ($user_id > 0)) {
	F_submit_button("extendtime", "+".K_EXTEND_TIME_MINUTES." min", $l['h_add_five_minutes']);
}
?>
&nbsp;
</span>
</div>

<div class="row">
<span class="label">
<span title="<?php echo $l['h_score_total']; ?>"><?php echo $l['w_score']; ?>:</span>
</span>
<span class="formw">
<?php 
echo "".$test_score." (".round(100 * $usrtestdata['score'] / $usrtestdata['max_score'])."%)";
?>
&nbsp;
</span>
</div>

<div class="row">
<span class="label">
<span title="<?php echo $l['h_answers_right']; ?>"><?php echo $l['w_answers_right']; ?>:</span>
</span>
<span class="formw">
<?php 
echo "".$usrtestdata['right']." (".round(100 * $usrtestdata['right'] / $usrtestdata['all'])."%)";
?>
&nbsp;
</span>
</div>

<div class="row">
<span class="label">
<span title="<?php echo $l['h_testcomment']; ?>"><?php echo $l['w_comment']; ?>:</span>
</span>
<span class="formw">
<?php 
echo "".F_decode_tcecode($usrtestdata['comment'])."";
?>
&nbsp;
</span>
</div>

<div class="rowl">
<?php
if (isset($testuser_id) AND (!empty($testuser_id))) {
	// display user questions
	$sql = "SELECT * 
		FROM ".K_TABLE_QUESTIONS.",".K_TABLE_TESTS_LOGS." 
		WHERE question_id=testlog_question_id 
		AND testlog_testuser_id=".$testuser_id."
		ORDER BY testlog_id";
	if($r = F_db_query($sql, $db)) {
		echo "<ol class=\"question\">\n";
		while($m = F_db_fetch_array($r)) {
			echo "<li>\n";
			// display question stats
			echo "<strong>[".$m['testlog_score']."]\n";
			echo " (";
			echo "".$m['testlog_user_ip']."\n";
			if (isset($m['testlog_display_time']) AND (strlen($m['testlog_display_time']) > 0)) {
				echo " | ".substr($m['testlog_display_time'], 11, 8)."\n";
			}
			else {
				echo " | --:--:--\n";
			}
			if (isset($m['testlog_change_time']) AND (strlen($m['testlog_change_time']) > 0)) {
				echo " | ".substr($m['testlog_change_time'], 11, 8)."\n";
			}
			else {
				echo " | --:--:--\n";
			}
			if (isset($m['testlog_display_time']) AND isset($m['testlog_change_time'])) {
				echo " | ".date("i:s", (strtotime($m['testlog_change_time']) - strtotime($m['testlog_display_time'])))."";
			}
			else {
				echo " | --:--\n";
			}
			
			echo ")</strong>\n";
			echo "<br />\n";
			// display question description
			echo F_decode_tcecode($m['question_description'])."\n";
			
			if ($m['question_type'] == 3) {
				// display textarea field
				echo "<ul class=\"answer\"><li>\n";
				echo F_decode_tcecode($m['testlog_answer_text']);
				echo "&nbsp;</li></ul>\n";
			}
			else {
				// display multiple answers
				echo "<ol class=\"answer\">\n";
				// display each answer option
				$sqla = "SELECT answer_id, answer_description, answer_isright, logansw_selected
					FROM ".K_TABLE_LOG_ANSWER.", ".K_TABLE_ANSWERS."
					WHERE logansw_answer_id=answer_id
						AND logansw_testlog_id='".$m['testlog_id']."'
					ORDER BY logansw_order";
				if($ra = F_db_query($sqla, $db)) {
					while($ma = F_db_fetch_array($ra)) {
						echo "<li>";
						echo "[";
						if (F_getBoolean($ma['logansw_selected'])) {
							echo "<strong title=\"".$l['h_answer_selected']."\">x</strong>";
						}
						else {
							echo "&nbsp;";
						}
						echo "]";
						//echo "[";
						if (F_getBoolean($ma['answer_isright'])) {
							echo "<strong title=\"".$l['h_answer_right']."\">&reg;</strong>";
						}
						else {
							echo "&nbsp;";
						}
						//echo "] ";
						echo " ";
						echo F_decode_tcecode($ma['answer_description']);
						echo "</li>\n";
					}
				}
				else {
					F_display_db_error();
				}
				echo "</ol>\n";
			} // end multiple answers
			echo "</li>\n";
		}
		echo "</ol>\n";
	}
	else {
		F_display_db_error();
	}
}
?>
</div>

<div class="row">
<?php
// show buttons by case
if (isset($test_id) AND ($test_id > 0) AND isset($user_id) AND ($user_id > 0)) {
	F_submit_button("delete", $l['w_delete'], $l['h_delete']);
	
	if($testuser_status < 4) {
		// lock test button
		F_submit_button("lock", $l['w_lock'], $l['w_lock']);
	} else {
		// unlock test button
		F_submit_button("unlock", $l['w_unlock'], $l['w_unlock']);
	}
	
	echo "<br /><br />";
	echo "<a href=\"".pdfLink(3, $test_id, $user_id, "")."\" class=\"xmlbutton\" title=\"".$l['h_pdf']."\">".$l['w_pdf']."</a> ";
	echo "<a href=\"tce_email_results.php?testid=".$test_id."&amp;userid=".$user_id."\" class=\"xmlbutton\" title=\"".$l['h_email_result']."\">".$l['w_email_result']."</a> ";
}
?>
<!-- comma separated list of required fields -->
<input type="hidden" name="ff_required" id="ff_required" value="" />
<input type="hidden" name="ff_required_labels" id="ff_required_labels" value="" />
</div>

<?php
} // end "if (isset($usrtestdata))"
?>

</form>

</div>
<?php

echo "<div class=\"pagehelp\">".$l['hp_result_user']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
