<?php
//============================================================+
// File name   : tce_show_result_questions.php
// Begin       : 2004-06-10
// Last Update : 2006-06-26
// 
// Description : Display questions statistics for the selected
//               test.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display questions statistics for the selected test.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-06-10
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_RESULTS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_result_questions'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../../shared/code/tce_functions_test.php');
require_once('../../shared/code/tce_functions_test_stats.php');
require_once('../code/tce_functions_auth_sql.php');

// --- Initialize variables

if(!isset($order_field) OR empty($order_field)) {
	$order_field = "recurrence DESC,average_score DESC";
}
else {
	$order_field = addslashes($order_field);
}
if(!isset($orderdir) OR empty($orderdir)) {
	$orderdir=0; $nextorderdir=1; $full_order_field = $order_field;
}
else {
	$orderdir=1; $nextorderdir=0; $full_order_field = $order_field." DESC";
}

if($formstatus) {
	if(!isset($test_id) OR empty($test_id)) {
		$sql = F_select_executed_tests_sql()." LIMIT 1";
	}
	else {
		$sql = "SELECT testuser_test_id, testuser_creation_time
			FROM ".K_TABLE_TEST_USER." 
			WHERE testuser_test_id=".$test_id." 
			ORDER BY testuser_creation_time
			LIMIT 1";
	}
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$test_id = $m['testuser_test_id'];
			$test_start_time = $m['testuser_creation_time'];
		}
		else {
			$test_id = 0;
			$test_start_time = "";
		}
	}
	else {
		F_display_db_error();
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_resultquestions">

<div class="row">
<span class="label">
<label for="test_id"><?php echo $l['w_test']; ?></label>
</span>
<span class="formw">
<select name="test_id" id="test_id" size="0" onchange="document.getElementById('form_resultquestions').submit()" title="<?php echo $l['h_test']; ?>">
<?php
$sql = F_select_executed_distinct_tests_sql();
if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['test_id']."\"";
		if($m['test_id'] == $test_id) {
			echo " selected=\"selected\"";
		}
		echo ">".substr($m['test_begin_time'], 0, 10)." ".htmlspecialchars($m['test_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
	}
}
else {
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row"><hr /></div>

<div class="row">
<span class="label">
<span title="<?php echo $l['h_time_begin']; ?>"><?php echo $l['w_time_begin']; ?>:</span>
</span>
<span class="formw">
<?php echo $test_start_time; ?>
&nbsp;
</span>
</div>

<div class="rowl">
<table class="userselect">
<tr>
<th>#</th>
<?php

echo F_stats_table_header_element($test_id, "recurrence", $nextorderdir, $l['h_question_recurrence'], $l['w_recurrence'], $order_field);
echo F_stats_table_header_element($test_id, "average_score", $nextorderdir, $l['h_score_average'], $l['w_score'], $order_field);
echo F_stats_table_header_element($test_id, "average_time", $nextorderdir, $l['h_answer_time'], $l['w_answer_time'], $order_field);

echo "<th title=\"".$l['h_answers_right']."\">".$l['w_answers_right']."</th>\n";
echo "<th title=\"".$l['h_answers_wrong']."\">".$l['w_answers_wrong']."</th>\n";
echo "<th title=\"".$l['h_questions_unanswered']."\">".$l['w_questions_unanswered']."</th>\n";
echo "<th title=\"".$l['h_questions_undisplayed']."\">".$l['w_questions_undisplayed']."</th>\n";
echo "<th title=\"".$l['h_questions_unrated']."\">".$l['w_questions_unrated']."</th>\n";
?>
</tr>
<?php
// output questions stats
$sqlr = "SELECT question_id, question_description, COUNT(question_id) AS recurrence, AVG(testlog_score) AS average_score, AVG(testlog_change_time - testlog_display_time) AS average_time
	FROM ".K_TABLE_TESTS_LOGS.", ".K_TABLE_TEST_USER.", ".K_TABLE_QUESTIONS." 
	WHERE testlog_testuser_id=testuser_id
		AND testlog_question_id=question_id 
		AND testuser_test_id=".$test_id."
	GROUP BY question_id, question_description 
	ORDER BY ".$full_order_field."";
if($rr = F_db_query($sqlr, $db)) {
	$itemcount = 1;
	while($mr = F_db_fetch_array($rr)) {
		echo "<tr>";
		echo "<td rowspan=\"2\" valign=\"top\"><a href=\"tce_edit_question.php?question_id=".$mr['question_id']."\" title=\"".$l['t_questions_editor']."\">".$itemcount."</a></td>\n";
		echo "<td>".$mr['recurrence']."</td>\n";
		echo "<td>".number_format($mr['average_score'], 3, ".", "")."</td>\n";
		if (stripos($mr['average_time'], ":") !== FALSE) {
			// PostgreSQL returns formatted time, while MySQL returns the number of seconds
			$mr['average_time'] = strtotime($mr['average_time']);
		}
		echo "<td>&nbsp;".date("i:s", $mr['average_time'])."</td>\n";
		$qsttestdata = F_getQuestionTestStat($test_id, $mr['question_id']);
		echo "<td>".$qsttestdata['right']."</td>\n";
		echo "<td>".$qsttestdata['wrong']."</td>\n";
		echo "<td>".$qsttestdata['unanswered']."</td>\n";
		echo "<td>".$qsttestdata['undisplayed']."</td>\n";
		echo "<td>".$qsttestdata['unrated']."</td>\n";
		echo "</tr>";
		echo "<tr>";
		echo "<td colspan=\"8\" align=\"left\">".F_decode_tcecode($mr['question_description'])."</td>\n";
		echo "</tr>";
		$itemcount++;
	}
}
else {
	F_display_db_error();
}
?>
</table>
</div>

<div class="row">
<?php
// show buttons by case
if (isset($test_id) AND ($test_id > 0)) {
	echo "<a href=\"".pdfLink(2, $test_id, "", $full_order_field)."\" class=\"xmlbutton\" title=\"".$l['h_pdf']."\">".$l['w_pdf']."</a> ";
}
?>
<input type="hidden" name="order_field" id="order_field" value="<?php echo $order_field; ?>" />
<input type="hidden" name="orderdir" id="orderdir" value="<?php echo $orderdir; ?>" />
	
<!-- comma separated list of required fields -->
<input type="hidden" name="ff_required" id="ff_required" value="" />
<input type="hidden" name="ff_required_labels" id="ff_required_labels" value="" />

</div>

</form>

</div>
<?php

echo "<div class=\"pagehelp\">".$l['hp_result_questions']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');

// ------------------------------------------------------------

/**
 * Display table header element with order link.
 * @param string $test_id test ID
 * @param string $order_field name of table field
 * @param string $orderdir order direction
 * @param string $title title field of anchor link
 * @param string $name column name
 * @param string $current_order_field current order field name
 * @return table header element string
 */
function F_stats_table_header_element($test_id, $order_field, $orderdir, $title, $name, $current_order_field="") {
	global $l;
	require_once('../config/tce_config.php');
	
	$ord = "";
	if ($order_field == $current_order_field) {
		if ($orderdir) {
			$ord = "<acronym title=\"".$l['w_ascent']."\">&gt;</acronym>";
		} else {
			$ord = "<acronym title=\"".$l['w_descent']."\">&lt;</acronym>";
		}
	}
	$str = "<th><a href=\"".$_SERVER['SCRIPT_NAME']."?test_id=".$test_id."&amp;firstrow=0&amp;order_field=".$order_field."&amp;orderdir=".$orderdir."\" title=\"".$title."\">".$name."</a> ".$ord."</th>\n";
	return $str;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
