<?php
//============================================================+
// File name   : tce_show_result_allusers.php
// Begin       : 2004-06-10
// Last Update : 2006-10-01
// 
// Description : Display test results summary for all users.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display test results summary for all users.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-06-10
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_RESULTS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_result_all_users'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../../shared/code/tce_functions_test.php');
require_once('../../shared/code/tce_functions_test_stats.php');
require_once('../code/tce_functions_auth_sql.php');

if(isset($_POST['lock'])) {
	$menu_mode = "lock";
} elseif(isset($_POST['unlock'])) {
	$menu_mode = "unlock";
}

switch($menu_mode) {

	case "delete":{
		F_stripslashes_formfields(); 
		// ask confirmation
		F_print_error("WARNING", $l['m_delete_confirm']);
		?>
		<div class="confirmbox">
		<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_delete">
		<div>
		
		<input type="hidden" name="test_id" id="test_id" value="<?php echo $test_id; ?>" />
		<?php 
		F_submit_button("forcedelete", $l['w_delete'], $l['h_delete']);
		F_submit_button("cancel", $l['w_cancel'], $l['h_cancel']);
		?>
		</div>
		</form>
		</div>
		<?php
		break;
	}

	case "forcedelete":{
		F_stripslashes_formfields(); // Delete
		if($forcedelete == $l['w_delete']) { //check if delete button has been pushed (redundant check)
			$sql = "DELETE FROM ".K_TABLE_TEST_USER." 
				WHERE testuser_test_id=".$test_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				$test_id = false;
				F_print_error("MESSAGE", "".$l['m_deleted']."");
			}
		}
		break;
	}
	
	case "lock":{
		// update test mode to 4 = test locked
		$sqlu = "UPDATE ".K_TABLE_TEST_USER."
			SET testuser_status=4 
			WHERE testuser_test_id=".$test_id."";
		if(!$ru = F_db_query($sqlu, $db)) {
			F_display_db_error();
		} else {
			F_print_error("MESSAGE", $l['m_updated']);
		}
		break;
	}
	
	case "unlock":{
		// update test mode to 1 = test unlocked
		$sqlu = "UPDATE ".K_TABLE_TEST_USER."
			SET testuser_status=1 
			WHERE testuser_test_id=".$test_id."";
		if(!$ru = F_db_query($sqlu, $db)) {
			F_display_db_error();
		} else {
			F_print_error("MESSAGE", $l['m_updated']);
		}
		break;
	}
	
	default: { 
		break;
	}

} //end of switch

// --- Initialize variables

if(!isset($order_field) OR empty($order_field)) {
	$order_field = "total_score, user_lastname, user_firstname";
}
else {
	$order_field = addslashes($order_field);
}

if(!isset($orderdir) OR empty($orderdir)) {
	$orderdir=0; $nextorderdir=1; $full_order_field = $order_field;
}
else {
	$orderdir=1; $nextorderdir=0; $full_order_field = $order_field." DESC";
}

if($formstatus) {
	if(!isset($test_id) OR empty($test_id)) {
		$sql = F_select_executed_tests_sql()." LIMIT 1";
	}
	else {
		$sql = "SELECT testuser_test_id, testuser_creation_time
			FROM ".K_TABLE_TEST_USER." 
			WHERE testuser_test_id=".$test_id."
				AND testuser_status>0
			ORDER BY testuser_creation_time DESC
			LIMIT 1";
	}
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$test_id = $m['testuser_test_id'];
			$test_start_time = $m['testuser_creation_time'];
		}
		else {
			$test_id = 0;
			$test_start_time = "";
		}
	}
	else {
		F_display_db_error();
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_resultallusers">

<div class="row">
<span class="label">
<label for="test_id"><?php echo $l['w_test']; ?></label>
</span>
<span class="formw">
<select name="test_id" id="test_id" size="0" onchange="document.getElementById('form_resultallusers').submit()" title="<?php echo $l['h_test']; ?>">
<?php
$sql = F_select_executed_distinct_tests_sql();
if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['test_id']."\"";
		if($m['test_id'] == $test_id) {
			echo " selected=\"selected\"";
		}
		echo ">".substr($m['test_begin_time'], 0, 10)." ".htmlspecialchars($m['test_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
	}
}
else {
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row"><hr /></div>

<div class="row">
<span class="label">
<span title="<?php echo $l['h_time_begin']; ?>"><?php echo $l['w_time_begin']; ?>:</span>
</span>
<span class="formw">
<?php echo $test_start_time; ?>
&nbsp;
</span>
</div>

<div class="rowl">
<table class="userselect">
<tr>
<th>#</th>
<?php 

echo F_allresults_table_header_element($test_id, "total_score", $nextorderdir, $l['h_score_total'], $l['w_score'], $order_field);
echo F_allresults_table_header_element($test_id, "user_lastname", $nextorderdir, $l['h_lastname'], $l['w_lastname'], $order_field);
echo F_allresults_table_header_element($test_id, "user_firstname", $nextorderdir, $l['h_firstname'], $l['w_firstname'], $order_field);
echo F_allresults_table_header_element($test_id, "user_name", $nextorderdir, $l['h_login_name'], $l['w_user'], $order_field);

echo "<th title=\"".$l['h_answers_right']."\">".$l['w_answers_right']."</th>\n";
echo "<th title=\"".$l['h_answers_wrong']."\">".$l['w_answers_wrong']."</th>\n";
echo "<th title=\"".$l['h_questions_unanswered']."\">".$l['w_questions_unanswered']."</th>\n";
echo "<th title=\"".$l['h_questions_undisplayed']."\">".$l['w_questions_undisplayed']."</th>\n";
echo "<th title=\"".$l['h_questions_unrated']."\">".$l['w_questions_unrated']."</th>\n";
echo "<th title=\"".$l['w_status']."\">".$l['w_status']."</th>\n";
echo "<th title=\"".$l['h_testcomment']."\">".$l['w_comment']."</th>\n";
?>
</tr>
<?php
// output users stats
$sqlr = "SELECT testuser_id, testuser_status, user_id, user_lastname, user_firstname, user_name, SUM(testlog_score) AS total_score 
	FROM ".K_TABLE_TESTS_LOGS.", ".K_TABLE_TEST_USER.", ".K_TABLE_USERS." 
	WHERE testlog_testuser_id=testuser_id
		AND testuser_user_id=user_id 
		AND testuser_test_id=".$test_id."
	GROUP BY testuser_id, user_id, user_lastname, user_firstname, user_name,testuser_status
	ORDER BY ".$full_order_field."";
if($rr = F_db_query($sqlr, $db)) {
	$itemcount = 1;
	while($mr = F_db_fetch_array($rr)) {
		$usrtestdata = F_getUserTestStat($test_id, $mr['user_id']);
		echo "<tr>";
		echo "<td><a href=\"tce_show_result_user.php?testuser_id=".$mr['testuser_id']."&amp;test_id=".$test_id."&amp;user_id=".$mr['user_id']."\" title=\"".$l['h_view_details']."\">".$itemcount."</a></td>\n";
		echo "<td>".$mr['total_score']." (".round(100 * $usrtestdata['score'] / $usrtestdata['max_score'])."%)</td>\n";
		echo "<td align=\"left\">&nbsp;".$mr['user_lastname']."</td>\n";
		echo "<td align=\"left\">&nbsp;".$mr['user_firstname']."</td>\n";
		echo "<td align=\"left\"><a href=\"tce_edit_user.php?user_id=".$mr['user_id']."\">".$mr['user_name']."</a></td>\n";
		echo "<td>".$usrtestdata['right']." (".round(100 * $usrtestdata['right'] / $usrtestdata['all'])."%)</td>\n";
		echo "<td>".$usrtestdata['wrong']." (".round(100 * $usrtestdata['wrong'] / $usrtestdata['all'])."%)</td>\n";
		echo "<td>".$usrtestdata['unanswered']." (".round(100 * $usrtestdata['unanswered'] / $usrtestdata['all'])."%)</td>\n";
		echo "<td>".$usrtestdata['undisplayed']." (".round(100 * $usrtestdata['undisplayed'] / $usrtestdata['all'])."%)</td>\n";
		echo "<td>".$usrtestdata['unrated']." (".round(100 * $usrtestdata['unrated'] / $usrtestdata['all'])."%)</td>\n";
		echo "<td>";
		if ($mr['testuser_status'] == 4) {
			echo "<strong>".$l['w_locked']."</strong>";
		} else {
			echo "".$l['w_unlocked']."";
		}
		echo "</td>\n";
		if (!empty($usrtestdata['comment'])) {
			echo "<td title=\"".substr(F_compact_string(htmlspecialchars($usrtestdata['comment'], ENT_NOQUOTES, $l['a_meta_charset'])),0,255)."\">".$l['w_yes']."</td>\n";
		} else {
			echo "<td>&nbsp;</td>\n";
		}
		echo "</tr>";
		$itemcount++;
	}
}
else {
	F_display_db_error();
}
?>
</table>
</div>

<div class="row">
<?php
// show buttons by case
if (isset($test_id) AND ($test_id > 0)) {
	F_submit_button("delete", $l['w_delete'], $l['h_delete']);
	F_submit_button("lock", $l['w_lock'], $l['w_lock']);
	F_submit_button("unlock", $l['w_unlock'], $l['w_unlock']);
	echo "<br /><br />";
	echo "<a href=\"tce_csv_result_allusers.php?testid=".$test_id."&amp;order_field=".urlencode($full_order_field)."\" class=\"xmlbutton\" title=\"".$l['h_csv_export']."\">CSV</a> ";
	echo "<a href=\"".pdfLink(1, $test_id, "", $full_order_field)."\" class=\"xmlbutton\" title=\"".$l['h_pdf']."\">".$l['w_pdf']."</a> ";
	echo "<a href=\"".pdfLink(4, $test_id, "", $full_order_field)."\" class=\"xmlbutton\" title=\"".$l['h_pdf_all']."\">".$l['w_pdf_all']."</a> ";
	echo "<a href=\"tce_email_results.php?testid=".$test_id."&amp;userid=0&amp;menu_mode=startlongprocess\" class=\"xmlbutton\" title=\"".$l['h_email_all_results']."\">".$l['w_email_all_results']."</a> ";
}
?>
<input type="hidden" name="order_field" id="order_field" value="<?php echo $order_field; ?>" />
<input type="hidden" name="orderdir" id="orderdir" value="<?php echo $orderdir; ?>" />
<!-- comma separated list of required fields -->
<input type="hidden" name="ff_required" id="ff_required" value="" />
<input type="hidden" name="ff_required_labels" id="ff_required_labels" value="" />

</div>

</form>

</div>
<?php

echo "<div class=\"pagehelp\">".$l['hp_result_alluser']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');

// ------------------------------------------------------------

/**
 * Display table header element with order link.
 * @param string $test_id test ID
 * @param string $order_field name of table field
 * @param string $orderdir order direction
 * @param string $title title field of anchor link
 * @param string $name column name
 * @param string $current_order_field current order field name
 * @return table header element string
 */
function F_allresults_table_header_element($test_id, $order_field, $orderdir, $title, $name, $current_order_field="") {
	global $l;
	require_once('../config/tce_config.php');
	
	$ord = "";
	if ($order_field == $current_order_field) {
		if ($orderdir) {
			$ord = "<acronym title=\"".$l['w_ascent']."\">&gt;</acronym>";
		} else {
			$ord = "<acronym title=\"".$l['w_descent']."\">&lt;</acronym>";
		}
	}
	$str = "<th><a href=\"".$_SERVER['SCRIPT_NAME']."?test_id=".$test_id."&amp;firstrow=0&amp;order_field=".$order_field."&amp;orderdir=".$orderdir."\" title=\"".$title."\">".$name."</a> ".$ord."</th>\n";
	return $str;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
