<?php
//============================================================+
// File name   : tce_show_all_questions.php
// Begin       : 2005-07-06
// Last Update : 2006-06-19
// 
// Description : Display all questions grouped by topic.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display all questions grouped by topic.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2005-07-06
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_RESULTS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_questions_list'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../code/tce_functions_auth_sql.php');

// --- Initialize variables

// set default values
if(!isset($wherequery)) {$wherequery="";}
if(!isset($order_field)) {$order_field="question_description";}
if(!isset($orderdir)) {$orderdir=0;}
if(!isset($firstrow)) {$firstrow=0;}
if(!isset($rowsperpage)) {$rowsperpage=K_MAX_ROWS_PER_PAGE;}

if (isset($changecategory) AND ($changecategory > 0)) {
	$wherequery="";
	$order_field="question_description";
	$firstrow=0;
	$orderdir=0;
}

if($formstatus) {
	if(!isset($subject_id) OR empty($subject_id)) {
		$sql = F_select_subjects_sql()." LIMIT 1";
	}
	else {
		$sql = "SELECT * 
			FROM ".K_TABLE_SUBJECTS." 
			WHERE subject_id=".$subject_id." 
			LIMIT 1";
	}
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$subject_id = $m['subject_id'];
		}
		else {
			$subject_id = 0;
		}
	}
	else {
		F_display_db_error();
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_selectquestions">

<div class="row">
<span class="label">
<label for="subject_id"><?php echo $l['w_subject']; ?></label>
</span>
<span class="formw">
<input type="hidden" name="changecategory" id="changecategory" value="" />
<select name="subject_id" id="subject_id" size="0" onchange="document.getElementById('form_selectquestions').changecategory.value=1;document.getElementById('form_selectquestions').submit()" title="<?php echo $l['h_subject']; ?>">
<?php
$sql = F_select_subjects_sql();
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['subject_id']."\"";
		if($m['subject_id'] == $subject_id) {
			echo " selected=\"selected\"";
		}
		echo ">".$countitem.". ";
		if (F_getBoolean($m['subject_enabled'])) {
			echo "+";
		} else {
			echo "-";
		}
		echo " ".htmlspecialchars($m['subject_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
		$countitem++;
	}
}
else {
	echo "</select></span></div>\n";
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row"><hr /></div>

<?php 
// display questions statistics
$qtype = array("<acronym class=\"offbox\" title=\"".$l['w_single_answer']."\">S</acronym>", "<acronym class=\"offbox\" title=\"".$l['w_multiple_answers']."\">M</acronym>", "<acronym class=\"offbox\" title=\"".$l['w_free_answer']."\">T</acronym>"); // question types
$qstat = "";
$nqsum = 0;
$sql = "SELECT question_type, COUNT(*) as numquestions 
	FROM ".K_TABLE_QUESTIONS." 
	WHERE question_subject_id=".$subject_id." 
	GROUP BY question_type";
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		$nqsum += $m['numquestions'];
		$qstat .= " + ".$m['numquestions']." ".$qtype[($m['question_type']-1)]."";
	}
}
else {
	F_display_db_error();
}

echo "<div class=\"rowl\">";
echo "".$l['w_questions'].": ".$nqsum." = ".$qstat."";
echo "</div>\n";
?>

<div class="row"><hr /></div>

<div class="rowl">
<?php 
if (isset($subject_id) AND ($subject_id > 0)) {
	F_show_select_questions($wherequery, $subject_id, $order_field, $orderdir, $firstrow, $rowsperpage); 
}
?>
&nbsp;
</div>

<div class="row">
<?php
// show buttons by case
if (isset($subject_id) AND ($subject_id > 0)) {
	$pdflink = "tce_pdf_all_questions.php?";
	$pdflink .= "subject_id=".$subject_id."";
	if (isset($order_field) AND (!empty($order_field))) {
		$pdflink .= "&amp;order_field=".urlencode($order_field)."";
	}
	echo "<a href=\"".$pdflink."\" class=\"xmlbutton\" title=\"".$l['h_pdf']."\">PDF</a> ";
	echo "<a href=\"tce_xml_questions.php?subject_id=".$subject_id."\" class=\"xmlbutton\" title=\"".$l['h_xml_export']."\">XML</a>";
}
?>
&nbsp;

<input type="hidden" name="firstrow" id="firstrow" value="<?php echo $firstrow; ?>" />
<input type="hidden" name="order_field" id="order_field" value="<?php echo $order_field; ?>" />
<input type="hidden" name="orderdir" id="orderdir" value="<?php echo $orderdir; ?>" />
<input type="hidden" name="submitted" id="submitted" value="0" />
<input type="hidden" name="usersearch" id="usersearch" value="" />
</div>

</form>

</div>
<?php

echo "<div class=\"pagehelp\">".$l['hp_select_all_questions']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');

// ------------------------------

/**
 * Display question selection XHTML table.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2005-07-06
 * @param string $wherequery question selection query
 * @param string $subject_id topic ID
 * @param string $order_field order by column name
 * @param int $orderdir oreder direction
 * @param int $firstrow number of first row to display
 * @param int $rowsperpage number of rows per page
 * @return false in case of empty database, true otherwise
 */
function F_show_select_questions($wherequery, $subject_id, $order_field, $orderdir, $firstrow, $rowsperpage) {
	global $l, $db;
		require_once('../config/tce_config.php');
	require_once('../../shared/code/tce_functions_page.php');
	
	$order_field = addslashes($order_field);
	if($orderdir == 0) {$nextorderdir=1; $full_order_field = $order_field;}
	else {$nextorderdir=0; $full_order_field = $order_field." DESC";}
	
	if(!F_count_rows(K_TABLE_QUESTIONS)) { //if the table is void (no items) display message
		F_print_error("MESSAGE", $l['m_databasempty']);
		return FALSE;
	}
	
	if(empty($wherequery)) {
		$wherequery = "WHERE question_subject_id=".$subject_id."";
	}
	else {
		$wherequery .= " AND question_subject_id=".$subject_id."";
	}
	
	$sql = "SELECT * 
		FROM ".K_TABLE_QUESTIONS."
		".$wherequery."
		ORDER BY ".$full_order_field." 
		LIMIT ".$rowsperpage." OFFSET ".$firstrow."";
	
	if($r = F_db_query($sql, $db)) {
		$questlist = "";
		$itemcount = 1 + $firstrow;
		while($m = F_db_fetch_array($r)) {
			$questlist .= "<li>\n";
			$questlist .= "".$itemcount++.". ";
			// display question description
			if (F_getBoolean($m['question_enabled'])) {
				$questlist .= "<acronym class=\"onbox\" title=\"".$l['w_enabled']."\">+</acronym>";
			}
			else {
				$questlist .= "<acronym class=\"offbox\" title=\"".$l['w_disabled']."\">-</acronym>";
			}
			switch ($m['question_type']) {
				case 1: {
					$questlist .= " <acronym class=\"offbox\" title=\"".$l['w_single_answer']."\">S</acronym>";
					break;
				}
				case 2: {
					$questlist .= " <acronym class=\"offbox\" title=\"".$l['w_multiple_answers']."\">M</acronym>";
					break;
				}
				case 3: {
					$questlist .= " <acronym class=\"offbox\" title=\"".$l['w_free_answer']."\">T</acronym>";
					break;
				}
			}
			$questlist .= " <acronym class=\"offbox\" title=\"".$l['h_question_difficulty']."\">".$m['question_difficulty']."</acronym>";
			
			$questlist .= " <a href=\"tce_edit_question.php?question_subject_id=".$subject_id."&amp;question_id=".$m['question_id']."\" title=\"".$l['t_questions_editor']." [ID = ".$m['question_id']."]\" class=\"xmlbutton\">".$l['w_edit']."</a>";

			$questlist .= "<br /><br />";
			$questlist .=  "<div class=\"paddingleft\">".F_decode_tcecode($m['question_description'])."</div>\n";
			if ($m['question_type'] < 3) {
				// display each answer option
				$sqla = "SELECT *
					FROM ".K_TABLE_ANSWERS."
					WHERE answer_question_id='".$m['question_id']."'
					ORDER BY answer_isright DESC";
				if($ra = F_db_query($sqla, $db)) {
					$answlist = "";
					while($ma = F_db_fetch_array($ra)) {
						$answlist .= "<li>";
						if (F_getBoolean($ma['answer_enabled'])) {
							$answlist .= "<acronym class=\"onbox\" title=\"".$l['w_enabled']."\">+</acronym>";
						}
						else {
							$answlist .= "<acronym class=\"offbox\" title=\"".$l['w_disabled']."\">-</acronym>";
						}
						if (F_getBoolean($ma['answer_isright'])) {
							$answlist .= " <acronym class=\"okbox\" title=\"".$l['h_answer_right']."\">T</acronym>";
						}
						else {
							$answlist .= " <acronym class=\"nobox\" title=\"".$l['h_answer_wrong']."\">F</acronym>";
						}
						
						$answlist .= " <a href=\"tce_edit_answer.php?question_subject_id=".$subject_id."&amp;answer_question_id=".$m['question_id']."&amp;answer_id=".$ma['answer_id']."\" title=\"".$l['t_answers_editor']." [ID = ".$ma['answer_id']."]\" class=\"xmlbutton\">".$l['w_edit']."</a>";
						$answlist .= " ";
						$answlist .= "".F_decode_tcecode($ma['answer_description'])."";
						$answlist .= "</li>\n";
					}
					if (strlen($answlist) > 0) {
						$questlist .= "<ol class=\"answer\">\n".$answlist."</ol><br /><br />\n";
					}
				}
				else {
					F_display_db_error();
				}
			} // end multiple answers
			$questlist .= "</li>\n";
		}
		if (strlen($questlist) > 0) {
			echo "<ul class=\"question\">\n".$questlist."</ul>\n";
		}
		
		// ---------------------------------------------------------------
		// -- page jumper (menu for successive pages)
		$sql = "SELECT count(*) AS total FROM ".K_TABLE_QUESTIONS." ".$wherequery."";
		if (!empty($order_field)) {$param_array = "&amp;subject_id=".$subject_id."&amp;order_field=".urlencode($order_field)."";}
		if (!empty($orderdir)) {$param_array .= "&amp;orderdir=".$orderdir."";}
		$param_array .= "&amp;submitted=1";
		F_show_page_navigator($_SERVER['SCRIPT_NAME'], $sql, $firstrow, $rowsperpage, $param_array);
	}
	else {
		F_display_db_error();
	}
	return TRUE;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
