<?php
//============================================================+
// File name   : tce_pdf_testgen.php
// Begin       : 2004-06-13
// Last Update : 2006-09-30
// 
// Description : Creates PDF documents for offline testing.
// 
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Creates PDF documents for Pen-and-Paper testing.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-06-13
 * @param int $_REQUEST['testid'] test ID
 * @param int $_REQUEST['num'] number of tests to generate
 */

/**
 */

require_once('../config/tce_config.php');

require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../../shared/code/tce_functions_test.php');
require_once('../../shared/config/tce_pdf.php');
require_once('../../shared/code/tcpdf.php');

// --- Initialize variables

if(isset($_REQUEST['testid'])) {
	$test_id = $_REQUEST['testid'];
}
else {
	echo $l['m_authorization_denied'];
	exit;
}

if(isset($_REQUEST['num'])) {
	$test_num = $_REQUEST['num'];
}
else {
	$test_num = 1;
}

$doc_title = strtoupper(unhtmlentities($l['w_test']));
$doc_description = F_compact_string(unhtmlentities($l['h_test']));
$page_elements = 6;
// define symbols for answers list
$listpoint = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
$qtype = array("S", "M", "T"); // symbols for question type

// --- create pdf document

$isunicode = (strcasecmp($l['a_meta_charset'], "UTF-8") == 0);
//create new PDF document (document units are set by default to millimeters)
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, $isunicode); 

// set document information
$pdf->SetCreator("TCExam ver.".K_TCEXAM_VERSION."");
$pdf->SetAuthor(PDF_AUTHOR);
$pdf->SetTitle($doc_title);
$pdf->SetSubject($doc_description);
$pdf->SetKeywords("TCExam, ".$doc_title);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor

$pdf->setHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

//set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->setHeaderMargin(PDF_MARGIN_HEADER);
$pdf->setFooterMargin(PDF_MARGIN_FOOTER);

$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

$pdf->setLanguageArray($l); //set language items

//initialize document
$pdf->AliasNbPages();

// calculate some sizes
$page_width = $pdf->getPageWidth() - PDF_MARGIN_LEFT - PDF_MARGIN_RIGHT;
$data_cell_height = round((K_CELL_HEIGHT_RATIO * PDF_FONT_SIZE_DATA) / $pdf->getScaleFactor(), 2);
$main_cell_height = round((K_CELL_HEIGHT_RATIO * PDF_FONT_SIZE_MAIN) / $pdf->getScaleFactor(), 2);
$data_cell_width = round($page_width / $page_elements, 2);
$data_cell_width_third = round($data_cell_width / 3, 2);
$data_cell_width_half = round($data_cell_width / 2, 2);

// get test data
$testdata = F_getTestData($test_id);

// NOTE: PDF tests are always random

for ($item = 1; $item <= $test_num; $item++) {
	// generate $test_num tests
	
	// --- start page data ---
	
	$pdf->AddPage();
	
	// set barcode
	$pdf->setBarcode("".$test_id.":".$item.":".date(K_TIMESTAMP_FORMAT));
	
	$pdf->SetFillColor(204, 204, 204);
	$pdf->SetLineWidth(0.1);
	$pdf->SetDrawColor(0, 0, 0);
	
	// print document name (title)
	$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA * K_TITLE_MAGNIFICATION);
	$pdf->Cell(0, $main_cell_height * K_TITLE_MAGNIFICATION, $doc_title, 1, 1, 'C', 1);
	
	$pdf->Ln(5);
	
	// display user info input boxes
	
	// calculate some sizes
	$user_elements = 4;
	$user_data_cell_width = round($page_width / $user_elements, 2);
	
	// print table headings
	$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA);
	
	$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_lastname'], "LTRB", 0, 'C', 1);
	$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_firstname'], "LTRB", 0, 'C', 1);
	$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_code'], "LTRB", 0, 'C', 1);
	$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_score'], "LTRB", 1, 'C', 1);
	
	$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
	
	$pdf->Cell($user_data_cell_width, (1.5 * $data_cell_height), "", "LTRB", 0, 'C', 0);
	$pdf->Cell($user_data_cell_width, (1.5 * $data_cell_height), "", "LTRB", 0, 'C', 0);
	$pdf->Cell($user_data_cell_width, (1.5 * $data_cell_height), "", "LTRB", 0, 'C', 0);
	$pdf->Cell($user_data_cell_width, (1.5 * $data_cell_height), "", "LTRB", 1, 'C', 0);
	
	$pdf->Ln(5);
	
	// --- display test info ---
	
	$info_cell_width = round($page_width / 4, 2);
	
	$boxStartY = $pdf->GetY(); // store current Y position
	
	// test name
	$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA * HEAD_MAGNIFICATION);
	$pdf->Cell($page_width, $data_cell_height * HEAD_MAGNIFICATION, strtoupper($l['w_test']).": ".$testdata['test_name'], "LRTB", 1, 'L', 1);
	
	$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
	
	$infoStartY = $pdf->GetY() + 2; // store current Y position
	$pdf->SetY($infoStartY);
	
	// test duration
	$pdf->Cell(1.5*$data_cell_width, $data_cell_height, $l['w_test_time']." [".$l['w_minutes']."]: ", 0, 0, 'R', 0);
	$pdf->Cell($data_cell_width, $data_cell_height, $testdata['test_duration_time'], 0, 1, 'L', 0);
	
	// test start time (to be compiled by the user)
	$pdf->Cell(1.5*$data_cell_width, $data_cell_height, $l['w_time_begin'].": ", 0, 0, 'R', 0);
	$pdf->Cell($data_cell_width, $data_cell_height, "", 0, 1, 'L', 0);
	
	// test end time (to be compiled by the user)
	$pdf->Cell(1.5*$data_cell_width, $data_cell_height, $l['w_time_end'].": ", 0, 0, 'R', 0);
	$pdf->Cell($data_cell_width, $data_cell_height, "", 0, 1, 'L', 0);
	
	// basic score for each question difficulty level
	//$pdf->Cell($data_cell_width, $data_cell_height, $l['w_score_right'].": ", 0, 0, 'R', 0);
	//$pdf->Cell($data_cell_width, $data_cell_height, $testdata['test_score_right'], 0, 1, 'L', 0);
	
	$boxEndY = $pdf->GetY();
	
	$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
	
	// test description
	$pdf->writeHTMLCell(0, ($boxEndY - $infoStartY + 4), (PDF_MARGIN_LEFT + ($info_cell_width * 2)), $infoStartY - 2, F_decode_tcecode($testdata['test_description']), "LRTB", 1);
	
	// print box around test info
	$pdf->SetY($boxStartY);
	$pdf->Cell($page_width, ($boxEndY - $boxStartY + 2), "", "LTRB", 1, 'C', 0);
	
	// --- end test info ---
	
	$pdf->Ln(5);
	
	/*
	$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA);
	$pdf->Cell($data_cell_width_third, $data_cell_height, "#", "LTRB", 0, 'C', 1);
	$pdf->Cell($data_cell_width_third, $data_cell_height, $l['w_score'], "LTRB", 0, 'C', 1);
	$pdf->Cell(0, $data_cell_height, $l['w_question'], "LTRB", 1, 'C', 1);
	$pdf->Ln($data_cell_height);
	$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
	*/
	
	$itemcount = 1; // count questions
	
	// selected questions IDs
	$selected_questions = "0";
	
	// 1. for each set of subjects
	// ------------------------------
	$sql = "SELECT *
		FROM ".K_TABLE_TEST_SUBJSET."
		WHERE tsubset_test_id=".$test_id."
		ORDER BY tsubset_type,tsubset_difficulty";
	if($r = F_db_query($sql, $db)) {
		while ($m = F_db_fetch_array($r)) {
			
			// 2. select questions
			// ------------------------------
			$sqlq = "SELECT question_id, question_type, question_difficulty, question_description
				FROM ".K_TABLE_QUESTIONS."";
			if ($m['tsubset_type'] < 3) {
				$sqlq .= ", ".K_TABLE_ANSWERS."";
			}
			$sqlq .= " WHERE question_subject_id IN (
						SELECT subjset_subject_id
						FROM ".K_TABLE_SUBJECT_SET."
						WHERE subjset_tsubset_id=".$m['tsubset_id']."
						ORDER BY RAND()
					)
					AND question_type=".$m['tsubset_type']." 
					AND question_difficulty=".$m['tsubset_difficulty']." 
					AND question_enabled='1'
					AND question_id NOT IN (".$selected_questions.")";
			if ($m['tsubset_type'] < 3) {
				// single question or multiple question
				// check if the selected question has enough answers
				$sqlq .= "  
					AND answer_question_id=question_id
					AND answer_enabled='1'
					AND answer_isright='1'
					AND question_id IN (
						SELECT answer_question_id
						FROM ".K_TABLE_ANSWERS."
						WHERE answer_enabled='1'";
				if ($m['tsubset_type'] == 1) {
					// single question
					$sqlq .= " AND answer_isright='0'";
				}
					$sqlq .= "  
						GROUP BY answer_question_id
						HAVING (COUNT(answer_id)>=".($m['tsubset_answers'] - 1).")
					)";
			}
			$sqlq .= " 
			 	GROUP BY question_id, question_type, question_difficulty, question_description
				ORDER BY RAND() 
				LIMIT ".$m['tsubset_quantity']."";
			
			if($rq = F_db_query($sqlq, $db)) {
				while ($mq = F_db_fetch_array($rq)) {
					
					$selected_questions .= ",".$mq['question_id']."";
					
					// 3. add question
					// ------------------------------
					// add question number
					$pdf->Cell($data_cell_width_third, $data_cell_height, $itemcount." ".$qtype[($mq['question_type']-1)], "LTRB", 0, 'R', 0);
					// add max points
					$pdf->Cell($data_cell_width_third, $data_cell_height, ($mq['question_difficulty'] * $testdata['test_score_right']), "LTRB", 0, 'R', 0);
					// add question description
					$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + (2 * $data_cell_width_third)), $pdf->GetY(), F_decode_tcecode($mq['question_description']), "LRTB", 1);
					
					$itemcount++;
					
					// 4. add answers
					// ------------------------------
					if ($mq['question_type'] == 3) {
						// print space for user text answer
						$restspace = $pdf->getPageHeight() - $pdf->GetY() - $pdf->getBreakMargin();
						$pdf->Cell(2*$data_cell_width_third, $data_cell_height, "", 0, 0, 'R', 0);
						if ($restspace > PDF_TEXTANSWER_HEIGHT) {
							$pdf->Cell(0, PDF_TEXTANSWER_HEIGHT, "", "LTRB", 1, 'C', 0);
						}
						else {
							// split text area across two pages
							$pdf->Cell(0, $restspace, "", "LTR", 1, 'C', 0);
							$pdf->Cell(2*$data_cell_width_third, $data_cell_height, "", 0, 0, 'R', 0);
							$pdf->Cell(0, (PDF_TEXTANSWER_HEIGHT - $restspace), "", "LRB", 1, 'C', 0);
						}
						$pdf->Ln($data_cell_height);
					} else {
						// multiple-choice question
						$answers_ids = array(); // to store answers IDs
						// select first random right answer
						$answers_ids += F_selectAnswers($mq['question_id'], true, 1, 1, 0);
						// select remaining answers
						$answers_ids += F_selectAnswers($mq['question_id'], ($m['tsubset_type'] == 1), 0, ($m['tsubset_answers'] - 1), 1);
						// randomizes the order of the answers
						shuffle($answers_ids); 
						// add answers
						
						// display multiple answers
						while (list($key, $answer_id) = each($answers_ids)) {
							// display each answer option
							$sqla = "SELECT answer_description 
								FROM ".K_TABLE_ANSWERS." 
								WHERE answer_id=".$answer_id." 
								LIMIT 1";
							if($ra = F_db_query($sqla, $db)) {
								if($ma = F_db_fetch_array($ra)) {
									$pdf->Cell(2*$data_cell_width_third, $data_cell_height, "", 0, 0, 'C', 0);
									$pdf->Cell($data_cell_width_third, $data_cell_height, "", "LTRB", 0, 'C', 0);
									$pdf->Cell($data_cell_width_third, $data_cell_height, $listpoint[$key], "LTRB", 0, 'C', 0);
									$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + $data_cell_width + $data_cell_width_third), $pdf->GetY(), F_decode_tcecode($ma['answer_description']), "LRTB", 1);
								}
							}
							else {
								F_display_db_error();
							}
						}
						$pdf->Ln($data_cell_height);
					} // -- end if multiple-choice question
					
				} // end while select questions
			} else {
				F_display_db_error();
			}
		} // end while type of questions
	} else {
		F_display_db_error();
	}
} //end for test_num

//Close and outputs PDF document
$pdf->Output();

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
