<?php
//============================================================+
// File name   : tce_pdf_results.php
// Begin       : 2004-06-10
// Last Update : 2006-10-01
// 
// Description : Create PDF document to display test results   
//               summary for all users.
// 
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Create PDF document to display users' tests results.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-06-11
 * @param int $_REQUEST['mode'] document mode: 1=all users results, 2=questions stats, 3=detailed report for single user 4=all users details
 * @param int $_REQUEST['testid'] test ID
 * @param int $_REQUEST['userid'] user ID
 * @param string $_REQUEST['orderfield'] ORDER BY portion of SQL selection query
 */

/**
 */

require_once('../config/tce_config.php');

require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../../shared/code/tce_functions_test.php');
require_once('../../shared/code/tce_functions_test_stats.php');
require_once('../../shared/config/tce_pdf.php');
require_once('../../shared/code/tcpdf.php');

if(!isset($_REQUEST['mode'])) {
	$_REQUEST['mode'] = "";
}

switch ($_REQUEST['mode']) {
	case 1: {
		// all users results
		$doc_title = unhtmlentities($l['t_result_all_users']);
		$doc_description = F_compact_string(unhtmlentities($l['hp_result_alluser']));
		$page_elements = 9;
		$temp_order_field = "total_score, user_lastname, user_firstname";
		break;
	}
	case 2: {
		// questions stats
		$doc_title = unhtmlentities($l['t_result_questions']);
		$doc_description = F_compact_string(unhtmlentities($l['hp_result_questions']));
		$page_elements = 9;
		$temp_order_field = "recurrence DESC,average_score DESC";
		break;
	}
	case 3: // detailed report for specific user
	case 4: { // detailed report for all users
		$doc_title = unhtmlentities($l['t_result_user']);
		$doc_description = F_compact_string(unhtmlentities($l['hp_result_user']));
		$page_elements = 6;
		$temp_order_field = "";
		if (isset($_REQUEST['userid']) AND $_REQUEST['userid']) {
			$user_id = $_REQUEST['userid'];
		}
		// define symbols for answers list
		$listpoint = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
		$qtype = array("S", "M", "T"); // symbols for question type
		break;
	}
	default: {
		echo $l['m_authorization_denied'];
		exit;
	}
}

// set sql select limit
if ($_REQUEST['mode'] == 4) {
	$sql_limit = "";
}
else {
	$sql_limit = " LIMIT 1";
}

// order fields for SQL query
if(isset($_REQUEST['orderfield'])) {
	$full_order_field = urldecode($_REQUEST['orderfield']);
}
else {
	$full_order_field = $temp_order_field;
}

// --- create pdf document

$isunicode = (strcasecmp($l['a_meta_charset'], "UTF-8") == 0);
//create new PDF document (document units are set by default to millimeters)
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, $isunicode); 

// set document information
$pdf->SetCreator("TCExam ver.".K_TCEXAM_VERSION."");
$pdf->SetAuthor(PDF_AUTHOR);
$pdf->SetTitle($doc_title);
$pdf->SetSubject($doc_description);
$pdf->SetKeywords("TCExam, ".$doc_title);

$pdf->setHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

//set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

$pdf->setHeaderMargin(PDF_MARGIN_HEADER);
$pdf->setFooterMargin(PDF_MARGIN_FOOTER);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

$pdf->setLanguageArray($l); //set language items

//initialize document
$pdf->AliasNbPages();

// calculate some sizes
$page_width = $pdf->getPageWidth() - PDF_MARGIN_LEFT - PDF_MARGIN_RIGHT;
$data_cell_height = round((K_CELL_HEIGHT_RATIO * PDF_FONT_SIZE_DATA) / $pdf->getScaleFactor(), 2);
$main_cell_height = round((K_CELL_HEIGHT_RATIO * PDF_FONT_SIZE_MAIN) / $pdf->getScaleFactor(), 2);
$data_cell_width = round($page_width / $page_elements, 2);
$data_cell_width_third = round($data_cell_width / 3, 2);
$data_cell_width_half = round($data_cell_width / 2, 2);


// get test data
if(isset($_REQUEST['testid'])) {
	$test_id = $_REQUEST['testid'];
	$sql = "SELECT * 
		FROM ".K_TABLE_TESTS." 
		WHERE test_id=".$test_id."";
} else {
	$sql = "SELECT ".K_TABLE_TESTS.".* 
		FROM ".K_TABLE_TESTS.", ".K_TABLE_TEST_USER." 
		WHERE test_id=testuser_test_id
			AND testuser_status>0
		ORDER BY test_begin_time DESC, test_name 
		LIMIT 1";
}
if($r = F_db_query($sql, $db)) {
	if($m = F_db_fetch_array($r)) {
		$test_id = $m['test_id'];
		$test_name = $m['test_name'];
		$test_description = $m['test_description'];
		$test_begin_time = $m['test_begin_time'];
		$test_end_time = $m['test_end_time'];
		$test_duration_time = $m['test_duration_time'];
		$test_ip_range = $m['test_ip_range'];
		$test_random_questions = F_getBoolean($m['test_random_questions']);
		$test_results_to_users = F_getBoolean($m['test_results_to_users']);
		$test_score_right = $m['test_score_right'];
		$test_max_score = $m['test_max_score'];	
	}
}
else {
	F_display_db_error();
}

if (($_REQUEST['mode'] == 3) AND (isset($_REQUEST['userid']))) { // detailed report for single user
	$user_id = $_REQUEST['userid'];
	$sql = "SELECT testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_comment, user_lastname, user_firstname, user_name, SUM(testlog_score) AS test_score
		FROM ".K_TABLE_TEST_USER.", ".K_TABLE_TESTS_LOGS.", ".K_TABLE_USERS." 
		WHERE testlog_testuser_id=testuser_id
			AND testuser_user_id=user_id
			AND testuser_test_id=".$test_id."
			AND testuser_user_id=".$user_id."
			AND testuser_status>0
		GROUP BY testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_comment, user_lastname, user_firstname, user_name
		".$sql_limit."";
}
else {
	$sql = "SELECT testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_comment, user_lastname, user_firstname, user_name, SUM(testlog_score) AS test_score
		FROM ".K_TABLE_TEST_USER.", ".K_TABLE_TESTS_LOGS.", ".K_TABLE_USERS." 
		WHERE testlog_testuser_id=testuser_id
			AND testuser_user_id=user_id
			AND testuser_test_id=".$test_id." 
			AND testuser_status>0
		GROUP BY testuser_id, testuser_test_id, testuser_user_id, testuser_creation_time, testuser_comment, user_lastname, user_firstname, user_name
		ORDER BY testuser_test_id, user_lastname, user_firstname
		".$sql_limit."";
}

if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		$testuser_id = $m['testuser_id'];
		$test_id = $m['testuser_test_id'];
		$user_id = $m['testuser_user_id'];
		$user_lastname = $m['user_lastname'];
		$user_firstname = $m['user_firstname'];
		$user_name = $m['user_name'];
		$test_start_time = $m['testuser_creation_time'];
		$test_score = $m['test_score'];	
		$testuser_comment = F_decode_tcecode($m['testuser_comment']);	
		
		// ------------------------------------------------------------
		// --- start page data ---
		
		$pdf->AddPage();
		
		// set barcode
		$pdf->setBarcode($test_id.":".$user_id.":".$test_start_time);
		
		$pdf->SetFillColor(204, 204, 204);
		$pdf->SetLineWidth(0.1);
		$pdf->SetDrawColor(0, 0, 0);
		
		// print document name (title)
		$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA * K_TITLE_MAGNIFICATION);
		$pdf->Cell(0, $main_cell_height * K_TITLE_MAGNIFICATION, $doc_title, 1, 1, 'C', 1);
		
		$pdf->Ln(5);
		
		// display user info
		if ($_REQUEST['mode'] >= 3) {
			
			// calculate some sizes
			$user_elements = 4;
			$user_data_cell_width = round($page_width / $user_elements, 2);
			
			// print table headings
			$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA);
			
			$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_lastname'], "LTRB", 0, 'C', 1);
			$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_firstname'], "LTRB", 0, 'C', 1);
			$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_user'], "LTRB", 0, 'C', 1);
			$pdf->Cell($user_data_cell_width, $data_cell_height, $l['w_score'], "LTRB", 1, 'C', 1);
			
			$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
			
			$pdf->Cell($user_data_cell_width, $data_cell_height, $user_lastname, "LTRB", 0, 'C', 0);
			$pdf->Cell($user_data_cell_width, $data_cell_height, $user_firstname, "LTRB", 0, 'C', 0);
			$pdf->Cell($user_data_cell_width, $data_cell_height, $user_name, "LTRB", 0, 'C', 0);
			$pdf->Cell($user_data_cell_width, $data_cell_height, $test_score." (".round(100 * $test_score / $test_max_score)."%)", "LTRB", 1, 'C', 0);
			
			$pdf->Ln(5);
		}
		
		// --- display test info ---
		
		$info_cell_width = round($page_width / 4, 2);
		
		$boxStartY = $pdf->GetY(); // store current Y position
		
		// test name
		$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA * HEAD_MAGNIFICATION);
		$pdf->Cell($page_width, $data_cell_height * HEAD_MAGNIFICATION, strtoupper($l['w_test']).": ".$test_name, "LRTB", 1, 'L', 1);
		
		$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
		
		$infoStartY = $pdf->GetY() + 2; // store current Y position
		$pdf->SetY($infoStartY);
		
		$column_names_width = round($info_cell_width * 1.2, 2);
		// test start time
		$pdf->Cell($column_names_width, $data_cell_height, $l['w_time_begin'].": ", 0, 0, 'R', 0);
		$pdf->Cell($info_cell_width, $data_cell_height, $test_start_time, 0, 1, 'L', 0);
		
		// test duration
		$pdf->Cell($column_names_width, $data_cell_height, $l['w_test_time']." [".$l['w_minutes']."]: ", 0, 0, 'R', 0);
		$pdf->Cell($info_cell_width, $data_cell_height, $test_duration_time, 0, 1, 'L', 0);
		
		// authorized IPs
		//$pdf->Cell($column_names_width, $data_cell_height, $l['w_ip_range'].": ", 0, 0, 'R', 0);
		//$pdf->Cell($info_cell_width, $data_cell_height, $test_ip_range, 0, 1, 'L', 0);
		
		// score for right answer
		$pdf->Cell($column_names_width, $data_cell_height, $l['w_score_right'].": ", 0, 0, 'R', 0);
		$pdf->Cell($info_cell_width, $data_cell_height, $test_score_right, 0, 1, 'L', 0);
		
		// max score
		$pdf->Cell($column_names_width, $data_cell_height, $l['w_max_score'].": ", 0, 0, 'R', 0);
		$pdf->Cell($info_cell_width, $data_cell_height, $test_max_score, 0, 1, 'L', 0);
		
		// right answers
		$usrtestdata = F_getUserTestStat($test_id, $user_id);
		$pdf->Cell($column_names_width, $data_cell_height, $l['w_answers_right'].": ", 0, 0, 'R', 0);
		$pdf->Cell($info_cell_width, $data_cell_height, $usrtestdata['right']." (".round(100 * $usrtestdata['right'] / $usrtestdata['all'])."%)", 0, 1, 'L', 0);
		
		$boxEndY = $pdf->GetY();
		
		$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
		
		// test description
		$pdf->writeHTMLCell(0, ($boxEndY - $infoStartY + 4), (PDF_MARGIN_LEFT + ($info_cell_width * 2)), $infoStartY - 2, $test_description, "LRTB", 1);
		
		// print box around test info
		$pdf->SetY($boxStartY);
		$pdf->Cell($page_width, ($boxEndY - $boxStartY + 2), "", "LTRB", 1, 'C', 0);
		
		// --- end test info ---
		
		// print user's comments
		if (!empty($testuser_comment)) {
			$pdf->Cell($page_width, $data_cell_height, '', 0, 1, 'L', 0);
			$pdf->writeHTMLCell($page_width, $data_cell_height, '', '', $testuser_comment, "LRTB", 1);
		}
		
		$pdf->Ln(5);
		
		// display different things by case
		switch ($_REQUEST['mode']) {
			case 1: {
				// all users results
				
				// print table headings
				$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA);
				
				$pdf->Cell($data_cell_width_third, $data_cell_height, "#", "LTRB", 0, 'C', 1);
				$pdf->Cell(2 * $data_cell_width_third, $data_cell_height, $l['w_score'], "LTRB", 0, 'C', 1);
				$pdf->Cell(2 * $data_cell_width, $data_cell_height, $l['w_lastname'], "LTRB", 0, 'C', 1);
				$pdf->Cell(2 * $data_cell_width, $data_cell_height, $l['w_firstname'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_user'], "LTRB", 0, 'C', 1);
				
				$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, $l['w_answers_right_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, $l['w_answers_wrong_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, $l['w_questions_unanswered_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, $l['w_questions_undisplayed_th'], "LTRB", 1, 'C', 1);
				// print table rows
				
				$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
				
				$sqlr = "SELECT testuser_id, user_id, user_lastname, user_firstname, user_name, SUM(testlog_score) AS total_score 
					FROM ".K_TABLE_TESTS_LOGS.", ".K_TABLE_TEST_USER.", ".K_TABLE_USERS." 
					WHERE testlog_testuser_id=testuser_id
						AND testuser_user_id=user_id 
						AND testuser_test_id=".$test_id."
					GROUP BY testuser_id, user_id, user_lastname, user_firstname, user_name
					ORDER BY ".$full_order_field."";
				if($rr = F_db_query($sqlr, $db)) {
					$itemcount = 1;
					while($mr = F_db_fetch_array($rr)) {
						
						$usrtestdata = F_getUserTestStat($test_id, $mr['user_id']);
						
						$pdf->Cell($data_cell_width_third, $data_cell_height, $itemcount, "LTRB", 0, 'R', 0);
						$pdf->Cell(2 * $data_cell_width_third, $data_cell_height, round($mr['total_score'],1)." (".round(100 * $usrtestdata['score'] / $usrtestdata['max_score'])."%)", "LTRB", 0, 'C', 0);
						$pdf->Cell(2 * $data_cell_width, $data_cell_height, $mr['user_lastname'], "LTRB", 0, 'L', 0);
						$pdf->Cell(2 * $data_cell_width, $data_cell_height, $mr['user_firstname'], "LTRB", 0, 'L', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $mr['user_name'], "LTRB", 0, 'L', 0);
						$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, "".$usrtestdata['right']." (".round(100 * $usrtestdata['right'] / $usrtestdata['all'])."%)", "LTRB", 0, 'R', 0);
						$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, "".$usrtestdata['wrong']." (".round(100 * $usrtestdata['wrong'] / $usrtestdata['all'])."%)", "LTRB", 0, 'R', 0);
						$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, "".$usrtestdata['unanswered']." (".round(100 * $usrtestdata['unanswered'] / $usrtestdata['all'])."%)", "LTRB", 0, 'R', 0);
						$pdf->Cell($data_cell_width * 3 / 4, $data_cell_height, "".$usrtestdata['undisplayed']." (".round(100 * $usrtestdata['undisplayed'] / $usrtestdata['all'])."%)", "LTRB", 1, 'R', 0);
						//$usrtestdata->undisplayed
						
						$itemcount++;
					}
				}
				else {
					F_display_db_error();
				}
				break;
			}
			case 2: {
				// questions stats
				
				// print table headings
				
				$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA);
				
				$pdf->Cell(2 * $data_cell_width_third, $data_cell_height, "#", "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_recurrence'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_score'], "LTRB", 0, 'C', 1);
				$pdf->Cell(4 * $data_cell_width_third, $data_cell_height, $l['w_answer_time'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_answers_right_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_answers_wrong_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_questions_unanswered_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_questions_undisplayed_th'], "LTRB", 0, 'C', 1);
				$pdf->Cell($data_cell_width, $data_cell_height, $l['w_questions_unrated_th'], "LTRB", 1, 'C', 1);
				$pdf->Ln(2);
				
				// print table rows
				
				$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
				
				// output questions stats
				$sqlr = "SELECT question_id, question_description, COUNT(question_id) AS recurrence, AVG(testlog_score) AS average_score, AVG(testlog_change_time - testlog_display_time) AS average_time
					FROM ".K_TABLE_TESTS_LOGS.", ".K_TABLE_TEST_USER.", ".K_TABLE_QUESTIONS." 
					WHERE testlog_testuser_id=testuser_id
						AND testlog_question_id=question_id 
						AND testuser_test_id=".$test_id."
					GROUP BY question_id, question_description 
					ORDER BY ".$full_order_field."";
				if($rr = F_db_query($sqlr, $db)) {
					$itemcount = 1;
					while($mr = F_db_fetch_array($rr)) {
						
						$qsttestdata = F_getQuestionTestStat($test_id, $mr['question_id']);
						
						$pdf->Cell(2 * $data_cell_width_third, $data_cell_height, $itemcount, "LTRB", 0, 'R', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $mr['recurrence'], "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, number_format($mr['average_score'], 3, ".", ""), "LTRB", 0, 'C', 0);
						if (stripos($mr['average_time'], ":") !== FALSE) {
							// PostgreSQL returns formatted time, while MySQL returns the number of seconds
							$mr['average_time'] = strtotime($mr['average_time']);
						}
						$pdf->Cell(4 * $data_cell_width_third, $data_cell_height, date("i:s", $mr['average_time']), "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $qsttestdata['right'], "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $qsttestdata['wrong'], "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $qsttestdata['unanswered'], "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $qsttestdata['undisplayed'], "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $qsttestdata['unrated'], "LTRB", 1, 'C', 0);
						$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + (2 * $data_cell_width_third)), $pdf->GetY(), F_decode_tcecode($mr['question_description']), "LRTB", 1);
						
						$pdf->Ln(2);
						
						$itemcount++;
					}
				}
				else {
					F_display_db_error();
				}
				break;
			}
			case 3:
			case 4: {
				// detailed report for single user
				$sqlq = "SELECT * 
					FROM ".K_TABLE_QUESTIONS.",".K_TABLE_TESTS_LOGS." 
					WHERE question_id=testlog_question_id 
					AND testlog_testuser_id=".$testuser_id."
					ORDER BY testlog_id";
				if($rq = F_db_query($sqlq, $db)) {
					
					$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA);
					
					$pdf->Cell($data_cell_width_third, $data_cell_height, "#", "LTRB", 0, 'C', 1);
					$pdf->Cell($data_cell_width, $data_cell_height, $l['w_score'], "LTRB", 0, 'C', 1);
					$pdf->Cell($data_cell_width, $data_cell_height, $l['w_ip'], "LTRB", 0, 'C', 1);
					$pdf->Cell($data_cell_width + $data_cell_width_third, $data_cell_height, $l['w_start']." [".$l['w_time_hhmmss']."]", "LTRB", 0, 'C', 1);
					$pdf->Cell($data_cell_width + $data_cell_width_third, $data_cell_height, $l['w_end']." [".$l['w_time_hhmmss']."]", "LTRB", 0, 'C', 1);
					$pdf->Cell($data_cell_width, $data_cell_height, $l['w_time']." [".$l['w_time_mmss']."]", "LTRB", 1, 'C', 1);
					$pdf->Ln($data_cell_height);
					
					// print table rows
					
					$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
					$itemcount = 1;
					
					while($mq = F_db_fetch_array($rq)) {
						$pdf->Cell($data_cell_width_third, $data_cell_height, $itemcount." ".$qtype[($mq['question_type']-1)], "LTRB", 0, 'R', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $mq['testlog_score'], "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $mq['testlog_user_ip'], "LTRB", 0, 'C', 0);
						
						
						if (isset($mq['testlog_display_time']) AND (strlen($mq['testlog_display_time']) > 0)) {
							$display_time =  substr($mq['testlog_display_time'], 11, 8);
						}
						else {
							$display_time =  "--:--:--";
						}
						if (isset($mq['testlog_change_time']) AND (strlen($mq['testlog_change_time']) > 0)) {
							$change_time = substr($mq['testlog_change_time'], 11, 8);
						}
						else {
							$change_time = "--:--:--";
						}
						if (isset($mq['testlog_display_time']) AND isset($mq['testlog_change_time'])) {
							$diff_time = date("i:s", (strtotime($mq['testlog_change_time']) - strtotime($mq['testlog_display_time'])));
						}
						else {
							$diff_time = "--:--";
						}
						
						$pdf->Cell($data_cell_width + $data_cell_width_third, $data_cell_height, $display_time, "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width + $data_cell_width_third, $data_cell_height, $change_time, "LTRB", 0, 'C', 0);
						$pdf->Cell($data_cell_width, $data_cell_height, $diff_time, "LTRB", 1, 'C', 0);
						
						$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + $data_cell_width_third), $pdf->GetY(), F_decode_tcecode($mq['question_description']), "LRTB", 1);
						
						if ($mq['question_type'] == 3) {
							// free-text question
							// print user text answer
							$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + (2 * $data_cell_width_third)), $pdf->GetY(), F_decode_tcecode($mq['testlog_answer_text']), "LRTB", 1);
						}
						else {
							// display each answer option
							$sqla = "SELECT answer_id, answer_description, answer_isright, logansw_selected
								FROM ".K_TABLE_LOG_ANSWER.", ".K_TABLE_ANSWERS."
								WHERE logansw_answer_id=answer_id
									AND logansw_testlog_id='".$mq['testlog_id']."'
								ORDER BY logansw_order";
							if($ra = F_db_query($sqla, $db)) {
								$idx = 0; // count items
								$maxidx = count($listpoint) - 1;
								while($ma = F_db_fetch_array($ra)) {
									if ($idx > $maxidx) {
										$itemnum = $idx + 1; // we are out of symbols array range
									} else {
										$itemnum = $listpoint[$idx]; // use symbol to indicate item
									}
									
									$pdf->Cell($data_cell_width_third, $data_cell_height, "", 0, 0, 'C', 0);
									if (F_getBoolean($ma['logansw_selected'])) {
										$pdf->Cell($data_cell_width_third, $data_cell_height, "X", "LTRB", 0, 'C', 1);
									}
									else {
										$pdf->Cell($data_cell_width_third, $data_cell_height, "", "LTRB", 0, 'C', 0);
									}
									if (F_getBoolean($ma['answer_isright'])) {
										$pdf->Cell($data_cell_width_third, $data_cell_height, $itemnum, "LTRB", 0, 'C', 1);
									}
									else {
										$pdf->Cell($data_cell_width_third, $data_cell_height, $itemnum, "LTRB", 0, 'C', 0);
									}
									$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + $data_cell_width), $pdf->GetY(), F_decode_tcecode($ma['answer_description']), "LRTB", 1);
									$idx++;
								}
							}
							else {
								F_display_db_error();
							}
						} // end multiple answers
						$pdf->Ln($data_cell_height);
						$itemcount++;
					}
				}
				else {
					F_display_db_error();
				}
				break;
			}
		}
		// END page data
		// ------------------------------------------------------------
	}
}
else {
	F_display_db_error();
}

// Send PDF output
$pdf->Output();

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
