<?php
//============================================================+
// File name   : tce_pdf_all_questions.php
// Begin       : 2004-06-10
// Last Update : 2006-03-12
// 
// Description : Create PDF document to display all questions
//               of a specified topic.
// 
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Create PDF document to display all questions of a specified topic.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2005-07-06
 * @param int $_REQUEST['subject_id'] topic ID
 * @param string $_REQUEST['order_field'] ORDER BY portion of SQL selection query
 */

/**
 */

require_once('../config/tce_config.php');

require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../../shared/config/tce_pdf.php');
require_once('../../shared/code/tcpdf.php');


$doc_title = unhtmlentities($l['t_questions_list']);
$doc_description = F_compact_string(unhtmlentities($l['hp_select_all_questions']));
$page_elements = 6;
$temp_order_field = "question_description";

// define symbols for answers list
$listpoint = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
$qtype = array("S", "M", "T"); // question types 
$qright = array(" ", "*"); // question types 

// order fields for SQL query
if(isset($_REQUEST['order_field'])) {
	$full_order_field = urldecode($_REQUEST['order_field']);
}
else {
	$full_order_field = $temp_order_field;
}

// --- create pdf document

$isunicode = (strcasecmp($l['a_meta_charset'], "UTF-8") == 0);
//create new PDF document (document units are set by default to millimeters)
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, $isunicode); 

// set document information
$pdf->SetCreator("TCExam ver.".K_TCEXAM_VERSION."");
$pdf->SetAuthor(PDF_AUTHOR);
$pdf->SetTitle($doc_title);
$pdf->SetSubject($doc_description);
$pdf->SetKeywords("TCExam, ".$doc_title);

$pdf->setHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

//set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

$pdf->setHeaderMargin(PDF_MARGIN_HEADER);
$pdf->setFooterMargin(PDF_MARGIN_FOOTER);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 

$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

$pdf->setLanguageArray($l); //set language items

//initialize document
$pdf->AliasNbPages();

// calculate some sizes
$page_width = $pdf->getPageWidth() - PDF_MARGIN_LEFT - PDF_MARGIN_RIGHT;
$data_cell_height = round((K_CELL_HEIGHT_RATIO * PDF_FONT_SIZE_DATA) / $pdf->getScaleFactor(), 2);
$main_cell_height = round((K_CELL_HEIGHT_RATIO * PDF_FONT_SIZE_MAIN) / $pdf->getScaleFactor(), 2);
$data_cell_width = round($page_width / $page_elements, 2);
$data_cell_width_third = round($data_cell_width / 3, 2);
$data_cell_width_half = round($data_cell_width / 2, 2);


// get subject data
$sql = "SELECT * 
	FROM ".K_TABLE_SUBJECTS." 
	WHERE subject_id=".$subject_id." 
	LIMIT 1";
if($r = F_db_query($sql, $db)) {
	if($m = F_db_fetch_array($r)) {
		$subject_id = $m['subject_id'];
		$subject_name = $m['subject_name'];
		$subject_description = F_decode_tcecode($m['subject_description']);
		$subject_enabled = F_getBoolean($m['subject_enabled']);
	}
}
else {
	F_display_db_error();
}

// ------------------------------------------------------------
// --- start page data ---
		
$pdf->AddPage();

// set barcode
$pdf->setBarcode($subject_id);

$pdf->SetFillColor(204, 204, 204);
$pdf->SetLineWidth(0.1);
$pdf->SetDrawColor(0, 0, 0);

// print document name (title)
$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA * K_TITLE_MAGNIFICATION);
$pdf->Cell(0, $main_cell_height * K_TITLE_MAGNIFICATION, $doc_title, 1, 1, 'C', 1);

$pdf->Ln(5);

// --- display subject info ---
$pdf->SetFont(PDF_FONT_NAME_DATA, 'B', PDF_FONT_SIZE_DATA * HEAD_MAGNIFICATION);
$pdf->Cell($page_width, $data_cell_height * HEAD_MAGNIFICATION, strtoupper($l['w_subject']).": ".$subject_name, "LRTB", 1, 'L', 1);	
$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
$pdf->writeHTMLCell(0, $data_cell_height, PDF_MARGIN_LEFT, $pdf->GetY(), $subject_description, "LRTB", 1);	
// --- end subject info ---
		
$pdf->Ln(5);		

// select all questions for a specified subject
$sqlq = "SELECT * 
	FROM ".K_TABLE_QUESTIONS."
	WHERE question_subject_id=".$subject_id."
	ORDER BY ".$full_order_field."";
if($rq = F_db_query($sqlq, $db)) {
	$pdf->SetFont(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);
	$itemcount = 1;
	while($mq = F_db_fetch_array($rq)) {
		$question_disabled = 0;
		if (!F_getBoolean($mq['question_enabled'])) {
			$question_disabled = 1;
		}
		$pdf->Cell($data_cell_width_third, $data_cell_height, $itemcount, "LTRB", 0, 'R', $question_disabled);
		
		
		$pdf->Cell($data_cell_width_third/2, $data_cell_height, $qtype[($mq['question_type']-1)], "LTRB", 0, 'C', $question_disabled);
		$pdf->Cell($data_cell_width_third/2, $data_cell_height, $mq['question_difficulty'], "LTRB", 0, 'R', $question_disabled);
		$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + (2 * $data_cell_width_third)), $pdf->GetY(), F_decode_tcecode($mq['question_description']), "LRTB", 1);
		if ($mq['question_type'] < 3) {
			$sqla = "SELECT *
				FROM ".K_TABLE_ANSWERS."
				WHERE answer_question_id='".$mq['question_id']."'
				ORDER BY answer_isright DESC";
			if($ra = F_db_query($sqla, $db)) {
				$idx = 0; // count items
				$maxidx = count($listpoint) - 1;
				while($ma = F_db_fetch_array($ra)) {
					if ($idx > $maxidx) {
						$itemnum = $idx + 1; // we are out of symbols array range
					} else {
						$itemnum = $listpoint[$idx]; // use symbol to indicate item
					}
					$answer_disabled = intval(!F_getBoolean($ma['answer_enabled']));
					$answer_isright = intval(F_getBoolean($ma['answer_isright']));
					
					$pdf->Cell(2*$data_cell_width_third, $data_cell_height, "", 0, 0, 'C', 0);
					$pdf->Cell($data_cell_width_third, $data_cell_height, $itemnum, "LTRB", 0, 'C', $answer_disabled);
					$pdf->Cell($data_cell_width_third/2, $data_cell_height, $qright[$answer_isright], "LTRB", 0, 'C', $answer_disabled);
					$pdf->writeHTMLCell(0, $data_cell_height, (PDF_MARGIN_LEFT + $data_cell_width + ($data_cell_width_third/2)), $pdf->GetY(), F_decode_tcecode($ma['answer_description']), "LRTB", 1);
					$idx++;
				}
			}
			else {
				F_display_db_error();
			}
		} // end multiple answers
		
		$pdf->Ln($data_cell_height);
		$itemcount++;
	}
}
else {
	F_display_db_error();
}

// Send PDF output
$pdf->Output();

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
