<?php
//============================================================+
// File name   : tce_page_menu.php
// Begin       : 2004-04-20
// Last Update : 2006-11-24
// 
// Description : Output XHTML unordered list menu.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Output XHTML unordered list menu.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-04-20
 */

/**
 */

echo "<a name=\"menusection\" id=\"menusection\"></a>";

// link to skip navigation
echo "<div class=\"hidden\">";
echo "<a href=\"#topofdoc\" accesskey=\"2\" title=\"[2] ".$l['w_skip_navigation']."\">".$l['w_skip_navigation']."</a>";
echo "</div>\n";

echo "<ul>";
echo "<li>".F_menu_link("index.php", $l['h_index'], $l['w_index'], "1")."</li>\n";
echo "<li>".F_menu_link("tce_edit_user.php", $l['t_user_editor'], $l['w_users'])."<ul>\n";
echo "<li>".F_menu_link("tce_edit_group.php", $l['t_group_editor'], $l['w_groups'])."</li>\n";
echo "<li>".F_menu_link("tce_select_users.php", $l['t_user_select'], $l['w_select'])."</li>\n";
echo "<li>".F_menu_link("tce_show_online_users.php", $l['t_online_users'], $l['w_online'])."</li>\n";
echo "<li>".F_menu_link("tce_import_xml_users.php", $l['t_user_importer'], $l['w_import'])."</li>\n";
echo "</ul></li>\n";
echo "<li>".F_menu_link("tce_edit_subject.php", $l['t_subjects_editor'], $l['w_subjects'])."<ul>\n";
echo "<li>".F_menu_link("tce_edit_question.php", $l['t_questions_editor'], $l['w_questions'])."<ul>\n";
echo "<li>".F_menu_link("tce_edit_answer.php", $l['t_answers_editor'], $l['w_answers'])."</li>\n";
echo "</ul></li>\n";
echo "<li>".F_menu_link("tce_show_all_questions.php", $l['t_questions_list'], $l['w_list'])."</li>\n";
echo "<li>".F_menu_link("tce_import_xml_questions.php", $l['t_question_importer'], $l['w_import'])."</li>\n";
echo "</ul></li>\n";
echo "<li>".F_menu_link("tce_edit_test.php", $l['t_tests_editor'], $l['w_tests'])."<ul>\n";
echo "<li>".F_menu_link("tce_edit_rating.php", $l['t_rating_editor'], $l['w_rating'])."</li>\n";
echo "<li>".F_menu_link("tce_show_result_allusers.php", $l['t_result_all_users'], $l['w_results'])."<ul>\n";
echo "<li>".F_menu_link("tce_show_result_user.php", $l['t_result_user'], $l['w_users'])."</li>\n";
echo "</ul></li>\n";
echo "<li>".F_menu_link("tce_show_result_questions.php", $l['t_result_questions'], $l['w_stats'])."</li>\n";
echo "</ul></li>\n";
echo "<li>".F_menu_link("tce_page_guide.php", $l['h_guide'], $l['w_guide'])."</li>\n";
echo "<li>".F_menu_link("tce_page_info.php", $l['h_info'], $l['w_info'])."</li>\n";
echo "<li>".F_menu_link("tce_logout.php", $l['h_logout_link'], $l['w_logout'], "", ($_SESSION['session_user_level']>1))."</li>\n";
echo "</ul>";

/**
 * Returns a menu element link.
 * If the link refers to the current page, only the name will be returned.
 * @param string $link URL
 * @param string $title title attribute
 * @param string $name link caption
 * @param string $accesskey html accesskey attribute value
 * @param boolean $enabled set to false to disable the link
 * @return string a list element contining a menu element
 */
function F_menu_link($link, $title, $name, $accesskey="", $enabled=true) {
	if ($enabled && ($link != basename($_SERVER['SCRIPT_NAME']))) {
		$str = "<a href=\"".$link."\" title=\"".$title."\"";
		if (!empty($accesskey)) {
			$str .= " accesskey=\"".$accesskey."\"";
		}
		$str .= ">".$name."</a>\n";
	} else {
		//disabled link
		$str = "".$name."\n";
	}
	return $str;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
