<?php
//============================================================+
// File name   : tce_functions_levels.php
// Begin       : 2001-10-18
// Last Update : 2006-09-29
// 
// Description : Functions to display online users' data.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Functions to display online users' data.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-10-18
 */

/**
 * Display online users form using F_list_online_users function.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-10-18
 * @param string $wherequery users selection query
 * @param string $order_field order by column name
 * @param string $orderdir oreder direction
 * @param string $firstrow number of first row to display
 * @param string $rowsperpage number of rows per page
 * @return false in case of empty database, true otherwise
 * @uses F_list_online_users
 */
function F_show_online_users($wherequery, $order_field, $orderdir, $firstrow, $rowsperpage) {
	global $l;
	require_once('../config/tce_config.php');
	F_list_online_users($wherequery, $order_field, $orderdir, $firstrow, $rowsperpage);
	return true;
}

/**
 * Display online users.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-10-18
 * @param string $wherequery users selection query
 * @param string $order_field order by column name
 * @param int $orderdir oreder direction
 * @param int $firstrow number of first row to display
 * @param int $rowsperpage number of rows per page
 * @return false in case of empty database, true otherwise
 */
function F_list_online_users($wherequery, $order_field, $orderdir, $firstrow, $rowsperpage) {
	global $l, $db;
	require_once('../config/tce_config.php');
	require_once('../../shared/code/tce_functions_page.php');
	
	//initialize variables
	$order_field = addslashes($order_field);
	if($orderdir == 0) {$nextorderdir=1; $full_order_field = $order_field;}
	else {$nextorderdir=0; $full_order_field = $order_field." DESC";}
	
	if(!F_count_rows(K_TABLE_SESSIONS)) { //if the table is void (no items) display message
		echo "<h2>".$l['m_databasempty']."</h2>";
		return FALSE;
	}
	
	if (empty($wherequery)) {
		$sql = "SELECT * FROM ".K_TABLE_SESSIONS." ORDER BY ".$full_order_field." LIMIT ".$rowsperpage." OFFSET ".$firstrow."";
	}
	else {
		$sql = "SELECT * FROM ".K_TABLE_SESSIONS." ".$wherequery." ORDER BY ".$full_order_field." LIMIT ".$rowsperpage." OFFSET ".$firstrow."";
	}
	
	echo "<div class=\"container\">";
	echo "<table class=\"userselect\">\n";
	echo "<tr>";
	echo "<th>".$l['w_user']."</th>";
	echo "<th>".$l['w_level']."</th>";
	echo "<th>".$l['w_ip']."</th>";
	echo "</tr>";
	
	if($r = F_db_query($sql, $db)) {
		while($m = F_db_fetch_array($r)) {
			
			$this_session = F_session_string_to_array($m['cpsession_data']);
			echo "<tr>";
			echo "<td align=\"left\">";
			echo "<a href=\"tce_edit_user.php?user_id=".$this_session['session_user_id']."\">";
			if ($this_session['session_user_lastname']) {
				echo "".urldecode($this_session['session_user_lastname']).", ";
			}
			if ($this_session['session_user_firstname']) {
				echo "".urldecode($this_session['session_user_firstname'])."";
			}
			echo " (".$this_session['session_user_name'].")";
			echo "</a>";
			echo "</td>";
			echo "<td>";
			echo $this_session['session_user_level'];
			echo "</td>";
			echo "<td>";
			echo $this_session['session_user_ip'];
			echo "</td>";
			echo "</tr>\n";
		}
	}
	else {
		F_display_db_error();
	}
	echo "</table>";
	
	// --- ------------------------------------------------------
	// --- page jump
	$sql = "SELECT count(*) AS total FROM ".K_TABLE_SESSIONS." ".$wherequery."";
	if (!empty($order_field)) {$param_array = "&amp;order_field=".urlencode($order_field)."";}
	if (!empty($orderdir)) {$param_array .= "&amp;orderdir=".$orderdir."";}
	$param_array .= "&amp;submitted=1";
	F_show_page_navigator($_SERVER['SCRIPT_NAME'], $sql, $firstrow, $rowsperpage, $param_array);
	echo "<div class=\"pagehelp\">".$l['hp_online_users']."</div>";
	echo "</div>";
	return TRUE;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
