<?php
//============================================================+
// File name   : tce_functions_user_select.php
// Begin       : 2001-09-13
// Last Update : 2006-09-29
// 
// Description : Functions to display and select registered user.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Functions to display and select registered user.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-09-13
 */

/**
 * Display user selection for using F_show_select_user function.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-09-13
 * @param string $wherequery users selection query
 * @param string $order_field order by column name
 * @param string $orderdir oreder direction
 * @param string $firstrow number of first row to display
 * @param string $rowsperpage number of rows per page
 * @return true
 * @uses F_show_select_user
 */
function F_select_user($wherequery, $order_field, $orderdir, $firstrow, $rowsperpage) {
	global $l;
	require_once('../config/tce_config.php');
	
	F_show_select_user($wherequery, $order_field, $orderdir, $firstrow, $rowsperpage);
	
	return true;
}

/**
 * Display user selection XHTML table.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-09-13
 * @param string $wherequery users selection query
 * @param string $order_field order by column name
 * @param int $orderdir oreder direction
 * @param int $firstrow number of first row to display
 * @param int $rowsperpage number of rows per page
 * @return false in case of empty database, true otherwise
 */
function F_show_select_user($wherequery, $order_field, $orderdir, $firstrow, $rowsperpage) {
	global $l, $db;
	require_once('../config/tce_config.php');
	require_once('../../shared/code/tce_functions_page.php');
	
	$order_field = addslashes($order_field);
	if($orderdir == 0) {
		$nextorderdir=1; 
		$full_order_field = $order_field;
	}
	else {
		$nextorderdir=0; 
		$full_order_field = $order_field." DESC";
	}
	
	if(!F_count_rows(K_TABLE_USERS)) { //if the table is void (no items) display message
		F_print_error("MESSAGE", $l['m_databasempty']);
		return FALSE;
	}
	
	if (empty($wherequery)) {
		$sql = "SELECT * 
		FROM ".K_TABLE_USERS."
		ORDER BY ".$full_order_field." 
		LIMIT ".$rowsperpage." 
		OFFSET ".$firstrow."";
	}
	else {
		$sql = "SELECT * 
		FROM ".K_TABLE_USERS."
		".$wherequery." 
		ORDER BY ".$full_order_field." 
		LIMIT ".$rowsperpage." 
		OFFSET ".$firstrow."";
	}
	
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			// -- Table structure with links:
			echo "<div class=\"container\">";
			echo "<table class=\"userselect\">\n";
			
			// table header
			echo "<tr>\n";
			echo "<th>&nbsp;</th>\n";
			echo F_user_table_header_element("user_lastname", $nextorderdir, $l['h_lastname'], $l['w_lastname'], $order_field);
			echo F_user_table_header_element("user_firstname", $nextorderdir, $l['h_firstname'], $l['w_firstname'], $order_field);
			echo F_user_table_header_element("user_name", $nextorderdir, $l['h_login_name'], $l['w_user'], $order_field);
			echo F_user_table_header_element("user_regnumber", $nextorderdir, $l['h_regcode'], $l['w_regcode'], $order_field);
			echo F_user_table_header_element("user_level", $nextorderdir, $l['h_level'], $l['w_level'], $order_field);
			echo F_user_table_header_element("user_regdate", $nextorderdir, $l['h_regdate'], $l['w_regdate'], $order_field);
			echo "<th title=\"".$l['h_group_name']."\">".$l['w_groups']."</th>\n";
			echo "</tr>\n";
			
			do {
				echo "<tr>\n";
				echo "<td><a href=\"tce_edit_user.php?user_id=".$m['user_id']."\">".$l['w_edit']."</a></td>\n";
				echo "<td>&nbsp;".htmlspecialchars($m['user_lastname'], ENT_NOQUOTES, $l['a_meta_charset'])."</td>\n";
				echo "<td>&nbsp;".htmlspecialchars($m['user_firstname'], ENT_NOQUOTES, $l['a_meta_charset'])."</td>\n";
				echo "<td>&nbsp;".htmlspecialchars($m['user_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</td>\n";
				echo "<td>&nbsp;".htmlspecialchars($m['user_regnumber'], ENT_NOQUOTES, $l['a_meta_charset'])."</td>\n";
				echo "<td>&nbsp;".$m['user_level']."</td>\n";
				echo "<td>&nbsp;".htmlspecialchars($m['user_regdate'], ENT_NOQUOTES, $l['a_meta_charset'])."</td>\n";
				// comma separated list of user's groups
				$grp = "";
				$sqlg = "SELECT * 
					FROM ".K_TABLE_GROUPS.",".K_TABLE_USERGROUP."
					WHERE usrgrp_group_id=group_id
						AND usrgrp_user_id=".$m['user_id']."
					ORDER BY group_name";
				if($rg = F_db_query($sqlg, $db)) {
					while($mg = F_db_fetch_array($rg)) {
						$grp .= $mg['group_name'].", ";
					}
				}
				else {
					F_display_db_error();
				}
				echo "<td>&nbsp;".htmlspecialchars(substr($grp,0,-2), ENT_NOQUOTES, $l['a_meta_charset'])."</td>\n";
				
				echo "</tr>\n";
			} while($m = F_db_fetch_array($r));
			
			echo"</table>\n";
			
			// ---------------------------------------------------------------
			// -- page jumper (menu for successive pages)
			$sql = "SELECT count(*) AS total FROM ".K_TABLE_USERS." ".$wherequery."";
			if (!empty($order_field)) {$param_array = "&amp;order_field=".urlencode($order_field)."";}
			if (!empty($orderdir)) {$param_array .= "&amp;orderdir=".$orderdir."";}
			$param_array .= "&amp;submitted=1";
			F_show_page_navigator($_SERVER['SCRIPT_NAME'], $sql, $firstrow, $rowsperpage, $param_array);
			
			echo "<div class=\"row\">";
			echo "\n<br />";
			echo "<a href=\"tce_xml_users.php\" class=\"xmlbutton\" title=\"".$l['h_xml_export']."\">XML</a> ";
			echo "<a href=\"tce_csv_users.php\" class=\"xmlbutton\" title=\"".$l['h_csv_export']."\">CSV</a>";
			echo "</div>\n";
			
			echo "<div class=\"pagehelp\">".$l['hp_select_users']."</div>";
			echo "</div>\n";
		}
		else {
			F_print_error("MESSAGE", $l['m_search_void']);
		}
	}
	else {
		F_display_db_error();
	}
	return TRUE;
}

/**
 * Display table header element with order link.
 * @param string $order_field name of table field
 * @param string $orderdir order direction
 * @param string $title title field of anchor link
 * @param string $name column name
 * @param string $current_order_field current order field name
 * @return table header element string
 */
function F_user_table_header_element($order_field, $orderdir, $title, $name, $current_order_field="") {
	global $l;
	require_once('../config/tce_config.php');
	
	$ord = "";
	if ($order_field == $current_order_field) {
		if ($orderdir) {
			$ord = "<acronym title=\"".$l['w_ascent']."\">&gt;</acronym>";
		} else {
			$ord = "<acronym title=\"".$l['w_descent']."\">&lt;</acronym>";
		}
	}
	$str = "<th><a href=\"".$_SERVER['SCRIPT_NAME']."?firstrow=0&amp;order_field=".$order_field."&amp;orderdir=".$orderdir."\" title=\"".$title."\">".$name."</a> ".$ord."</th>\n";
	return $str;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
