<?php
//============================================================+
// File name   : tce_functions_upload.php
// Begin       : 2001-11-19
// Last Update : 2006-03-30
// 
// Description : Upload functions.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Functions to upload files.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-11-19
 */

/**
 * Uploads image file to the server.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-11-19
 * @param string $fieldname form field name containing the source file path
 * @param string $uploaddir upload directory
 * @return mixed file name or false in case of error
 */
function F_upload_file($fieldname, $uploaddir) {
	global $l;
		require_once('../config/tce_config.php');
	
	if(move_uploaded_file ($_FILES[$fieldname]['tmp_name'], $uploaddir.$_FILES[$fieldname]['name'])) {
		F_print_error("MESSAGE", htmlspecialchars($_FILES[$fieldname]['name']).": ".$l['m_upload_yes']);
		return $_FILES[$fieldname]['name'];
	}
	
	F_print_error("ERROR", htmlspecialchars($_FILES[$fieldname]['name']).": ".$l['m_upload_not']."");
	return FALSE;
}

/**
 * returns the file size in bytes
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2001-11-19
 * @param string $filetocheck file to check (local path or URL)
 * @return mixed file size in bytes or false in case of error
 */
function F_read_file_size($filetocheck) {
	global $l;
		require_once('../config/tce_config.php');
	
	$filesize = 0;
	
	if($fp = fopen($filetocheck, "rb")) {
		$s_array = fstat($fp);
		if($s_array['size']) {
			$filesize = $s_array['size'];
		}
		else {//read size from remote file (very slow function)
			while(!feof($fp)) {
				$content = fread($fp, 1);
				$filesize++;
			}
		}
		fclose($fp);
		return($filesize);
	}
	
	F_print_error("ERROR", basename($filetocheck).": ".$l['m_openfile_not']);
	return FALSE;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
