<?php
//============================================================+
// File name   : tce_functions_tcecode_editor.php
// Begin       : 2002-02-20
// Last Update : 2006-11-20
// 
// Description : TCExam Code Editor (editor for special mark-up
//               code used to add some text formatting)
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Functions for custom mark-up language editor.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2002-02-20
 */

/**
 */

require_once('../config/tce_config.php');

// upload files
if(isset($_POST['sendfile']) AND ($_FILES['userfile']['name'])) {
	require_once('../code/tce_functions_upload.php');
	$uploadedfile = F_upload_file("userfile", K_PATH_CACHE);
}

/**
 * Display TCExam Code EDITOR Tag Buttons
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-07
 * @param string $callingform name of calling xhtml form
 * @param string $callingfield name of calling form field (textarea where output code will be sent)
 * @return XHTML string
 */
function tcecodeEditorTagButtons($callingform, $callingfield) {
	global $l, $db;
	global $uploadedfile;
		require_once('../config/tce_config.php');
	
	$buttons = "";
	$buttons .= "<script src=\"".K_PATH_SHARED_JSCRIPTS."inserttag.js\" type=\"text/javascript\"></script>\n";
	
	// --- buttons
	
	$onclick = "FJ_undo(document.getElementById('".$callingform."').".$callingfield.")";
	$buttons .= getImageButton($callingform, $callingfield, $l['w_undo'], "", K_PATH_IMAGES."buttons/undo.gif", $onclick, "z");
	
	$onclick = "FJ_redo(document.getElementById('".$callingform."').".$callingfield.")";
	$buttons .= getImageButton($callingform, $callingfield, $l['w_redo'], "", K_PATH_IMAGES."buttons/redo.gif", $onclick, "y");
	
	$onclick = "FJ_insert_tag(document.getElementById('".$callingform."').".$callingfield."";
	$buttons .= getImageButton($callingform, $callingfield, "bold", "[b]", K_PATH_IMAGES."buttons/bold.gif", $onclick, "b");
	$buttons .= getImageButton($callingform, $callingfield, "italic", "[i]", K_PATH_IMAGES."buttons/italic.gif", $onclick, "i");
	$buttons .= getImageButton($callingform, $callingfield, "small", "[small]", K_PATH_IMAGES."buttons/small.gif", $onclick, "s");
	$buttons .= getImageButton($callingform, $callingfield, "subscript", "[sub]", K_PATH_IMAGES."buttons/subscr.gif", $onclick, "v");
	$buttons .= getImageButton($callingform, $callingfield, "superscript", "[sup]", K_PATH_IMAGES."buttons/superscr.gif", $onclick, "a");
	$buttons .= getImageButton($callingform, $callingfield, "link", "[url]", K_PATH_IMAGES."buttons/link.gif", $onclick, "k");
	$buttons .= getImageButton($callingform, $callingfield, "unordered list", "[ulist]", K_PATH_IMAGES."buttons/bullist.gif", $onclick, "u");
	$buttons .= getImageButton($callingform, $callingfield, "ordered list", "[olist]", K_PATH_IMAGES."buttons/numlist.gif", $onclick, "o");
	$buttons .= getImageButton($callingform, $callingfield, "list item", "[li]", K_PATH_IMAGES."buttons/li.gif", $onclick, "l");
	$buttons .= getImageButton($callingform, $callingfield, "code", "[code]", K_PATH_IMAGES."buttons/code.gif", $onclick, "c");
	
	// --- insert image/object
	$buttons .= "<br />\n";
	$buttons .= "<label for=\"selectobject\">".$l['w_image']."/".$l['w_object']."</label>\n";
	$buttons .= "<select name=\"selectobject\" id=\"selectobject\" size=\"0\">\n";
	// read directory for files (only graphics files).
	$handle = opendir(K_PATH_CACHE);
	$buttons .= "<option value=\"\">&nbsp;</option>\n";
		while($file = readdir($handle)) {
			$path_parts = pathinfo($file);
			$file_ext = strtolower($path_parts['extension']);
			if(($file!=".")AND($file!="..")) {
				$buttons .= "<option value=\"".$file."\"";
				if (isset($uploadedfile) AND (strcmp($uploadedfile, $file) == 0)) {
					$buttons .= " selected=\"selected\"";
				}
				$buttons .= ">".$file."</option>\n";
			}
		}
	closedir($handle);
	$buttons .= "</select>\n";
	
	$buttons .= "<br /><label for=\"object_alt\">".$l['w_description']."</label>\n";
	$buttons .= "<input type=\"text\" name=\"object_alt\" id=\"object_alt\" value=\"\" size=\"30\" maxlength=\"255\" title=\"".$l['w_description']."\"/>\n";
	
	$buttons .= "<br /><label for=\"object_width\">".$l['w_width']."</label>\n";
	$buttons .= "<input type=\"text\" name=\"object_width\" id=\"object_width\" value=\"\" size=\"3\" maxlength=\"5\" title=\"".$l['h_object_width']."\"/>\n";
	$buttons .= "<label for=\"object_height\">".$l['w_height']."</label>\n";
	$buttons .= "<input type=\"text\" name=\"object_height\" id=\"object_height\" value=\"\" size=\"3\" maxlength=\"5\" title=\"".$l['h_object_height']."\"/>\n";
	$onclick = "document.getElementById('".$callingform."').selectobject.value=document.getElementById('".$callingform."').selectobject.options[document.getElementById('".$callingform."').selectobject.selectedIndex].value;FJ_insert_text(document.getElementById('".$callingform."').".$callingfield.",'[object]'+document.getElementById('".$callingform."').selectobject.value+'[/object:'+document.getElementById('".$callingform."').object_width.value+':'+document.getElementById('".$callingform."').object_height.value+':'+document.getElementById('".$callingform."').object_alt.value+']');";
	$buttons .= "<input type=\"button\" name=\"addobject\" id=\"addobject\" value=\"".$l['w_add']."\" onclick=\"".$onclick."\" title=\"".$l['h_add_object']."\" />\n";
	
	// --- upload object file
	$buttons .= "<br />\n";
	$buttons .= "<label for=\"userfile\">".$l['w_upload_file']."</label>\n";
	$buttons .= "<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".K_MAX_UPLOAD_SIZE."\" />\n";
	$buttons .= "<input type=\"file\" name=\"userfile\" id=\"userfile\" size=\"20\" title=\"".$l['h_upload_file']."\" />\n";
	$buttons .= "<input type=\"submit\" name=\"sendfile\" id=\"sendfile\" value=\"".$l['w_upload']."\" title=\"".$l['h_upload_file']."\" />";
	
	$buttons .= "<br />&nbsp;\n";
	
	return $buttons;
}

/**
 * Display one tag button
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-07
 * @param string $callingform name of calling xhtml form
 * @param string $callingfield name of calling form field (textarea where output code will be sent)
 * @param string $name name of the button
 * @param string $tag tag value
 * @param string $image image file of button
 * @param string $onclick default onclick action
 * @param string $accesskey accesskey: character for keyboard shortcut
 * @return XHTML string
 */
function getImageButton($callingform, $callingfield, $name, $tag, $image, $onclick="", $accesskey="") {
	if (strlen($tag) > 0) {
		$onclick = $onclick.", '".$tag."')";
	} 
	$str = "<a href=\"#\" onclick=\"".$onclick."\" title=\"".$name." [".$accesskey."]\" accesskey=\"".$accesskey."\">";
	$str .= "<img src=\"".$image."\" alt=\"".$name." [".$accesskey."]\" class=\"button\" />";
	$str .= "</a>\n";
	return $str;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
