<?php
//============================================================+
// File name   : tce_email_results.php
// Begin       : 2005-02-24
// Last Update : 2006-03-17
// 
// Description : Interface to send test reports to users via 
//               email.
// 
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Interface to send email test reports to users.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2005-02-24
 * @uses F_send_report_emails
 */

 /**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_RESULTS;
$thispage_title = $l['t_email_result'];
$thispage_description = $l['hp_email_result'];
require_once('../../shared/code/tce_authorization.php');

require_once('../code/tce_page_header.php');

echo "<div class=\"popupcontainer\">\n";

echo "<div class=\"pagehelp\">".$l['hp_sending_in_progress']."</div>\n";
flush(); // force browser output

if (isset($_REQUEST['testid']) AND ($_REQUEST['testid'] > 0)) {
	$test_id = $_REQUEST['testid'];
	if (isset($_REQUEST['userid']) AND ($_REQUEST['userid'] > 0)) {
		$user_id = $_REQUEST['userid'];
	}
	else {
		$user_id = 0; // select all users
	}
	require_once('tce_functions_email_reports.php');
	F_send_report_emails($test_id, $user_id);
}

F_print_error("MESSAGE", $l['m_process_completed']);

echo "</div>\n";

require_once('../code/tce_page_footer.php');

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
