<?php
//============================================================+
// File name   : tce_edit_test.php
// Begin       : 2004-04-27
// Last Update : 2006-12-15
//  
// Description : Edit Tests
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Edit test.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-04-27
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_TESTS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_tests_editor'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../code/tce_functions_tcecode_editor.php');
require_once('../code/tce_functions_auth_sql.php');

// set default values
if(!isset($test_random_questions) OR (empty($test_random_questions))) {
	$test_random_questions = 0;
}
if(!isset($test_results_to_users) OR (empty($test_results_to_users))) {
	$test_results_to_users = 0;
}
if(!isset($test_score_right) OR (empty($test_score_right))) {
	$test_score_right = 0;
}

if(!isset($subject_id) OR (empty($subject_id))) {
	$subject_id = Array();
}
if(!isset($tsubset_type) OR (empty($tsubset_type))) {
	$tsubset_type = 1;
}
if(!isset($tsubset_difficulty) OR (empty($tsubset_difficulty))) {
	$tsubset_difficulty = 1;
}
if(!isset($tsubset_quantity) OR (empty($tsubset_quantity))) {
	$tsubset_quantity = 1;
}
if(!isset($tsubset_answers) OR (empty($tsubset_answers))) {
	$tsubset_answers = 3;
}

$test_fieldset_name = "";

switch($menu_mode) {

	case "deletesubject":{ // delete subject
		// check referential integrity (NOTE: mysql do not support "ON UPDATE" constraint)
		if(!F_check_unique(K_TABLE_TEST_USER, "testuser_test_id=".$test_id."")) {
			F_print_error("WARNING", $l['m_update_restrict']);
			$formstatus = FALSE; F_stripslashes_formfields();
			break;
		}
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_TESTS, "test_id", $test_id, "test_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		$sql = "DELETE FROM ".K_TABLE_TEST_SUBJSET." WHERE tsubset_id=".$tsubset_id."";
		if(!$r = F_db_query($sql, $db)) {
			F_display_db_error(false);
		} else {
			F_print_error("MESSAGE", $l['m_deleted']);
		}
		break;
	}

	case "addquestion":{ // Add question type
		// check referential integrity (NOTE: mysql do not support "ON UPDATE" constraint)
		if(!F_check_unique(K_TABLE_TEST_USER, "testuser_test_id=".$test_id."")) {
			F_print_error("WARNING", $l['m_update_restrict']);
			$formstatus = FALSE; F_stripslashes_formfields();
			break;
		}
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_TESTS, "test_id", $test_id, "test_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		if($formstatus = F_check_form_fields()) {
			if ((isset($subject_id)) AND (!empty($subject_id)) AND (isset($tsubset_quantity)) AND (isset($tsubset_answers))) {
				
				if ($tsubset_type == 3) {
					// free-text questions do not have alternative answers
					$tsubset_answers = 0;
				} elseif ($tsubset_answers < 2) {
					// questions must have at least 2 alternative answers
					$tsubset_answers = 2;
				}
				// create a comma separated list of subjects IDs
				$subjids = "(";
				foreach ($subject_id as $subid) {
						$subjids .= $subid.",";
				}
				$subjids = substr($subjids,0,-1).")";
				
				// check here if the selected number of questions are available for the current set
				// NOTE: if the same subject is used in multiple sets this control may fail.
				$sqlq = "SELECT COUNT(*) AS numquestions
					FROM ".K_TABLE_QUESTIONS."";
				if ($tsubset_type < 3) {
					$sqlq .= ", ".K_TABLE_ANSWERS."";
				}
				$sqlq .= " WHERE question_subject_id IN ".$subjids." 
						AND question_type=".$tsubset_type." 
						AND question_difficulty=".$tsubset_difficulty." 
						AND question_enabled='1'";
				if ($tsubset_type < 3) {
					// single question or multiple question
					// check if the selected question has enough answers
					$sqlq .= "  
						AND answer_question_id=question_id
						AND answer_enabled='1'
						AND answer_isright='1'
						AND question_id IN (
							SELECT answer_question_id
							FROM ".K_TABLE_ANSWERS."
							WHERE answer_enabled='1'";
					if ($tsubset_type == 1) {
						// single question
						$sqlq .= " AND answer_isright='0'";
					}
					$sqlq .= "  
						GROUP BY answer_question_id
						HAVING (COUNT(answer_id)>=".($tsubset_answers - 1).")
					)";
				}
				$sqlq .= " LIMIT ".$tsubset_quantity."";
				$numofrows = 0;
				if($rq = F_db_query($sqlq, $db)) {
					if($mq = F_db_fetch_array($rq)) {
						$numofrows = $mq['numquestions'];
					} 
				}
				else {
					F_display_db_error();
				}
				if ($numofrows < $tsubset_quantity) {
					F_print_error("WARNING", $l['m_unavailable_questions']);
					break;
				}
				
				if (!empty($subject_id)) {
					// insert new subject
					$sql = "INSERT INTO ".K_TABLE_TEST_SUBJSET." ( 
						tsubset_test_id,
						tsubset_type,
						tsubset_difficulty,
						tsubset_quantity,
						tsubset_answers
						) VALUES (
						'".$test_id."',
						'".$tsubset_type."',
						'".$tsubset_difficulty."',
						'".$tsubset_quantity."',
						'".$tsubset_answers."'
						)";
					if(!$r = F_db_query($sql, $db)) {
						F_display_db_error(false);
					} else {
						$tsubset_id = F_db_insert_id($db, K_TABLE_TEST_SUBJSET, 'tsubset_id');
						// add selected subject_id
						foreach ($subject_id as $subid) {
							$sql = "INSERT INTO ".K_TABLE_SUBJECT_SET." (
								subjset_tsubset_id,
								subjset_subject_id
								) VALUES (
								'".$tsubset_id."', 
								'".$subid."'
								)";
							if(!$r = F_db_query($sql, $db)) {
								F_display_db_error(false);
							}
						}
					}
				}
			}
		}
		break;
	}

	case "delete":{
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_TESTS, "test_id", $test_id, "test_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		F_stripslashes_formfields(); 
		// ask confirmation
		F_print_error("WARNING", $l['m_delete_confirm_test']);
		?>
		<div class="confirmbox">
		<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_delete">
		<div>
		
		<input type="hidden" name="test_id" id="test_id" value="<?php echo $test_id; ?>" />
		<input type="hidden" name="test_name" id="test_name" value="<?php echo $test_name; ?>" />
		<?php 
		F_submit_button("forcedelete", $l['w_delete'], $l['h_delete']);
		F_submit_button("cancel", $l['w_cancel'], $l['h_cancel']);
		?>
		</div>
		</form>
		</div>
		<?php
		break;
	}

	case "forcedelete":{
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_TESTS, "test_id", $test_id, "test_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		F_stripslashes_formfields(); // Delete
		if($forcedelete == $l['w_delete']) { //check if delete button has been pushed (redundant check)
			// delete test
			$sql = "DELETE FROM ".K_TABLE_TESTS." WHERE test_id=".$test_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				$test_id=FALSE;
				F_print_error("MESSAGE", $test_name.": ".$l['m_deleted']);
			}
		}
		break;
	}

	case "update":{ // Update
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_TESTS, "test_id", $test_id, "test_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		if($formstatus = F_check_form_fields()) {
			// check referential integrity (NOTE: mysql do not support "ON UPDATE" constraint)
			if(!F_check_unique(K_TABLE_TEST_USER, "testuser_test_id=".$test_id."")) {
				F_print_error("WARNING", $l['m_update_restrict']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			// check if name is unique
			if(!F_check_unique(K_TABLE_TESTS, "test_name='".$test_name."'", "test_id", $test_id)) {
				F_print_error("WARNING", $l['m_duplicate_name']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			
			$sql = "UPDATE ".K_TABLE_TESTS." SET 
				test_name='".$test_name."',
				test_description='".$test_description."',
				test_begin_time=".F_empty_to_null($test_begin_time).",
				test_end_time=".F_empty_to_null($test_end_time).",
				test_duration_time='".$test_duration_time."',
				test_ip_range='".$test_ip_range."',
				test_random_questions='".$test_random_questions."',
				test_results_to_users='".$test_results_to_users."',
				test_score_right='".$test_score_right."'
				WHERE test_id=".$test_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				F_print_error("MESSAGE", $l['m_updated']);
			}
			
			// delete previous groups
			$sql = "DELETE FROM ".K_TABLE_TEST_GROUPS." 
				WHERE tstgrp_test_id=".$test_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			}
			// update authorized groups
			if (!empty($user_groups)) {
				foreach ($user_groups as $group_id) {
					$sql = "INSERT INTO ".K_TABLE_TEST_GROUPS." (
						tstgrp_test_id,
						tstgrp_group_id
						) VALUES (
						'".$test_id."', 
						'".$group_id."'
						)";
					if(!$r = F_db_query($sql, $db)) {
						F_display_db_error(false);
					}
				}
			}
		}
		break;
	}

	case "add":{ // Add
		if($formstatus = F_check_form_fields()) {
			// check if name is unique
			if(!F_check_unique(K_TABLE_TESTS, "test_name='".$test_name."'")) {
				F_print_error("WARNING", $l['m_duplicate_name']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			
			if (isset($test_id) AND ($test_id > 0)) {
				// save previous test_id.
				$old_test_id = $test_id;
			}
			
			$sql = "INSERT INTO ".K_TABLE_TESTS." ( 
				test_name,
				test_description,
				test_begin_time,
				test_end_time,
				test_duration_time,
				test_ip_range,
				test_random_questions,
				test_results_to_users,
				test_score_right,
				test_user_id
				) VALUES (
				'".$test_name."',
				'".$test_description."',
				".F_empty_to_null($test_begin_time).",
				".F_empty_to_null($test_end_time).",
				'".$test_duration_time."',
				'".$test_ip_range."',
				'".$test_random_questions."',
				'".$test_results_to_users."',
				'".$test_score_right."',
				'".$_SESSION['session_user_id']."'
				)";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				$test_id = F_db_insert_id($db, K_TABLE_TESTS, 'test_id');
			}
			
			// add authorized user's groups
			if (!empty($user_groups)) {
				foreach ($user_groups as $group_id) {
					$sql = "INSERT INTO ".K_TABLE_TEST_GROUPS." (
						tstgrp_test_id,
						tstgrp_group_id
						) VALUES (
						'".$test_id."', 
						'".$group_id."'
						)";
					if(!$r = F_db_query($sql, $db)) {
						F_display_db_error(false);
					}
				}
			}
			
			if (isset($old_test_id) AND ($old_test_id > 0)) {
				// copy here previous selected questions to this new test
				$sql = "SELECT * 
					FROM ".K_TABLE_TEST_SUBJSET."
					WHERE tsubset_test_id='".$old_test_id."'";
				if($r = F_db_query($sql, $db)) {
					while($m = F_db_fetch_array($r)) {
						// insert new subject
						$sqlu = "INSERT INTO ".K_TABLE_TEST_SUBJSET." ( 
							tsubset_test_id,
							tsubset_type,
							tsubset_difficulty,
							tsubset_quantity,
							tsubset_answers
							) VALUES (
							'".$test_id."',
							'".$m['tsubset_type']."',
							'".$m['tsubset_difficulty']."',
							'".$m['tsubset_quantity']."',
							'".$m['tsubset_answers']."'
							)";
						if(!$ru = F_db_query($sqlu, $db)) {
							F_display_db_error();
						} else {
							$tsubset_id = F_db_insert_id($db, K_TABLE_TEST_SUBJSET, 'tsubset_id');
							$sqls = "SELECT *
								FROM ".K_TABLE_SUBJECT_SET."
								WHERE subjset_tsubset_id='".$m['tsubset_id']."'";
							if($rs = F_db_query($sqls, $db)) {
								while($ms = F_db_fetch_array($rs)) {
									$sqlp = "INSERT INTO ".K_TABLE_SUBJECT_SET." (
										subjset_tsubset_id,
										subjset_subject_id
										) VALUES (
										'".$tsubset_id."', 
										'".$ms['subjset_subject_id']."'
										)";
									if(!$rp = F_db_query($sqlp, $db)) {
										F_display_db_error();
									}
								}
							} else {
								F_display_db_error();
							}
						}
					}
				} else {
					F_display_db_error();
				}
			}
		}
		break;
	}

	case "clear":{ // Clear form fields
		$test_name = "";
		$test_description = "";
		$test_begin_time = date(K_TIMESTAMP_FORMAT);
		$test_end_time = date(K_TIMESTAMP_FORMAT, time() + K_SECONDS_IN_DAY);
		$test_duration_time = 60;
		$test_ip_range = "*.*.*.*";
		$test_random_questions = true;
		$test_results_to_users = false;
		$test_score_right = 1;
		break;
	}

	default :{ 
		break;
	}

} //end of switch

// --- Initialize variables

if (!isset($test_num) OR (!empty($test_num))) {
	$test_num = 1; // default number of PDF tests to generate
}

if($formstatus) {
	if (($menu_mode != $l['w_clear']) AND ($menu_mode != unhtmlentities($l['w_clear']))) {
		if(!isset($test_id) OR empty($test_id)) {
			$sql = F_select_tests_sql()." LIMIT 1";
		}
		else {
			$sql = "SELECT * 
			FROM ".K_TABLE_TESTS." 
			WHERE test_id=".$test_id." 
			LIMIT 1";
		}

		if($r = F_db_query($sql, $db)) {
			if($m = F_db_fetch_array($r)) {
				$test_id = $m['test_id'];
				$test_name = $m['test_name'];
				$test_description = $m['test_description'];
				$test_begin_time = $m['test_begin_time'];
				$test_end_time = $m['test_end_time'];
				$test_duration_time = $m['test_duration_time'];
				$test_ip_range = $m['test_ip_range'];
				$test_random_questions = F_getBoolean($m['test_random_questions']);
				$test_results_to_users = F_getBoolean($m['test_results_to_users']);
				$test_score_right = $m['test_score_right'];
				$test_max_score = $m['test_max_score'];
			}
			else {
				$test_name = "";
				$test_description = "";
				$test_begin_time = date(K_TIMESTAMP_FORMAT);
				$test_end_time = date(K_TIMESTAMP_FORMAT, time() + K_SECONDS_IN_DAY);
				$test_duration_time = 60;
				$test_ip_range = "*.*.*.*";
				$test_random_questions = true;
				$test_results_to_users = false;
				$test_score_right = 1;
				$test_max_score = 0;
			}
		}
		else {
			F_display_db_error();
		}
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_testeditor">

<div class="row">
<span class="label">
<label for="test_id"><?php echo $l['w_test']; ?></label>
</span>
<span class="formw">
<select name="test_id" id="test_id" size="0" onchange="document.getElementById('form_testeditor').submit()" title="<?php echo $l['h_test']; ?>">
<?php
$sql = F_select_tests_sql();
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['test_id']."\"";
		if($m['test_id'] == $test_id) {
			echo " selected=\"selected\"";
			$test_fieldset_name = "".substr($m['test_begin_time'], 0, 10)." ".htmlspecialchars($m['test_name'], ENT_NOQUOTES, $l['a_meta_charset'])."";
		}
		echo ">".$countitem.". ".substr($m['test_begin_time'], 0, 10)." ".htmlspecialchars($m['test_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
		$countitem++;
	}
}
else {
	echo "</select></span></div>\n";
	F_display_db_error();
}
?>
</select>
</span>
<br /><br />
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<fieldset>
<legend><?php echo $l['w_test']; ?></legend>

<div class="row">
<span class="label">
<label for="test_name"><?php echo $l['w_name']; ?></label>
</span>
<span class="formw">
<input type="text" name="test_name" id="test_name" value="<?php echo htmlspecialchars($test_name, ENT_COMPAT, $l['a_meta_charset']); ?>" size="30" maxlength="255" title="<?php echo $l['h_test_name']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="test_description"><?php echo $l['w_description']; ?></label>
</span>
<span class="formw">
<textarea cols="30" rows="5" name="test_description" id="test_description" title="<?php echo $l['h_test_description']; ?>"><?php echo htmlspecialchars($test_description, ENT_NOQUOTES, $l['a_meta_charset']); ?></textarea>
</span>
</div>

<div class="row">
<span class="label">
<label for="test_begin_time"><?php echo $l['w_time_begin']." ".$l['w_datetime_format']; ?></label>
</span>
<span class="formw">
<input type="text" name="test_begin_time" id="test_begin_time" value="<?php echo $test_begin_time; ?>" size="20" maxlength="20" title="<?php echo $l['h_time_begin']; ?>" />
<input type="hidden" name="x_test_begin_time" id="x_test_begin_time" value="^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2})\:([0-9]{1,2})\:([0-9]{1,2})$" />
<input type="hidden" name="xl_test_begin_time" id="xl_test_begin_time" value="<?php echo $l['w_time_begin']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="test_end_time"><?php echo $l['w_time_end']." ".$l['w_datetime_format']; ?></label>
</span>
<span class="formw">
<input type="text" name="test_end_time" id="test_end_time" value="<?php echo $test_end_time; ?>" size="20" maxlength="20" title="<?php echo $l['h_time_end']; ?>" />
<input type="hidden" name="x_test_end_time" id="x_test_end_time" value="^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2})\:([0-9]{1,2})\:([0-9]{1,2})$" />
<input type="hidden" name="xl_test_end_time" id="xl_test_end_time" value="<?php echo $l['w_time_end']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="test_duration_time"><?php echo $l['w_test_time']." [".$l['w_minutes']."]"; ?></label>
</span>
<span class="formw">
<input type="text" name="test_duration_time" id="test_duration_time" value="<?php echo $test_duration_time; ?>" size="10" maxlength="20" title="<?php echo $l['h_test_time']; ?>" />
<input type="hidden" name="x_test_duration_time" id="x_test_duration_time" value="^([0-9]*)$" />
<input type="hidden" name="xl_test_duration_time" id="xl_test_duration_time" value="<?php echo $l['w_test_time']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="test_random_questions"><?php echo $l['w_random_questions']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"checkbox\" name=\"test_random_questions\" id=\"test_random_questions\" value=\"1\"";
if($test_random_questions) {echo " checked=\"checked\"";}
echo " title=\"".$l['h_random_questions']."\" />";
?>
</span>
</div>

<div class="row">
<span class="label">
<label for="test_results_to_users"><?php echo $l['w_results_to_users']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"checkbox\" name=\"test_results_to_users\" id=\"test_results_to_users\" value=\"1\"";
if($test_results_to_users) {echo " checked=\"checked\"";}
echo " title=\"".$l['h_results_to_users']."\" />";
?>
</span>
</div>

<div class="row">
<span class="label">
<label for="test_score_right"><?php echo $l['w_score_right']; ?></label>
</span>
<span class="formw">
<input type="text" name="test_score_right" id="test_score_right" value="<?php echo $test_score_right; ?>" size="7" maxlength="20" title="<?php echo $l['h_score_right']; ?>" />
<input type="hidden" name="x_test_score_right" id="x_test_score_right" value="^([0-9\+\-]*)([\.]?)([0-9]*)$" />
<input type="hidden" name="xl_test_score_right" id="xl_test_score_right" value="<?php echo $l['w_score_right']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="test_ip_range"><?php echo $l['w_ip_range']; ?></label>
</span>
<span class="formw">
<input type="text" name="test_ip_range" id="test_ip_range" value="<?php echo $test_ip_range; ?>" size="30" maxlength="255" title="<?php echo $l['h_ip_range']; ?>" />
<input type="hidden" name="x_test_ip_range" id="x_test_ip_range" value="^([0-9\*]{1,3})\.([0-9\*]{1,3})\.([0-9\*]{1,3})\.([0-9\*]{1,3})([,]?)" />
<input type="hidden" name="xl_test_ip_range" id="xl_test_ip_range" value="<?php echo $l['w_ip_range']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="user_groups"><?php echo $l['w_groups']; ?></label>
</span>
<span class="formw">
<select name="user_groups[]" id="user_groups" size="5" multiple="multiple">
<?php
$sql = "SELECT *
	FROM ".K_TABLE_GROUPS."
	ORDER BY group_name";
if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['group_id']."\"";
		if ((isset($test_id)) AND (F_count_rows(K_TABLE_TEST_GROUPS, "WHERE tstgrp_test_id=".$test_id." AND tstgrp_group_id=".$m['group_id']."") > 0)) {
			echo " selected=\"selected\"";
		}
		echo ">".htmlspecialchars($m['group_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
	}
}
else {
	echo "</select></span></div>\n";
	F_display_db_error();
}
?>
</select>
</span>
</div>

<div class="row">
<br />
<?php
// show buttons by case
if (isset($test_id) AND ($test_id > 0)) {
	F_submit_button("update", $l['w_update'], $l['h_update']);
	F_submit_button("delete", $l['w_delete'], $l['h_delete']);
}
F_submit_button("add", $l['w_add'], $l['h_add']);
F_submit_button("clear", $l['w_clear'], $l['h_clear']);
?>
<!-- comma separated list of required fields -->
<input type="hidden" name="ff_required" id="ff_required" value="test_name,test_description,test_ip_range,test_duration_time,test_score_right" />
<input type="hidden" name="ff_required_labels" id="ff_required_labels" value="<?php echo htmlspecialchars($l['w_name'].",".$l['w_description'].",".$l['w_ip_range'].",".$l['w_test_time'].",".$l['w_score_right'], ENT_COMPAT, $l['a_meta_charset']); ?>" />

<br /><br />
</div>

</fieldset>

<?php
// display a list of selected subject_id (topics)
if (isset($test_id) AND ($test_id > 0)) {
?>

<div class="row"><br /></div>

<fieldset>
<legend><?php echo $l['w_questions'].""; ?></legend>

<div class="row">
<span class="label">
&nbsp;
</span>
<span class="formw">
<?php echo $test_fieldset_name; ?>
</span>
</div>

<div class="row">
<span class="label">
<label for="subject_id"><?php echo $l['w_subjects']; ?></label>
</span>
<span class="formw">
<select name="subject_id[]" id="subject_id" size="4" multiple="multiple" title="<?php echo $l['h_subjects']; ?>">
<?php
// select subject_id
$sql = F_select_subjects_sql("subject_enabled='1'");
if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['subject_id']."\"";
		if($m['subject_id'] == $subject_id) {
			echo " selected=\"selected\"";
		}
		echo ">".htmlspecialchars($m['subject_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
	}
}
else {
	echo "</select></span></div>\n";
	F_display_db_error();
}
?>
</select>
</span>
</div>

<div class="row">
<span class="label">
<label for="tsubset_quantity"><?php echo $l['w_num_questions']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"text\" name=\"tsubset_quantity\" id=\"tsubset_quantity\" value=\"".$tsubset_quantity."\" size=\"5\" maxlength=\"20\" title=\"".$l['h_num_questions']."\" />\n";
?>
</span>
</div>

<div class="row">
<span class="label">
<label for="tsubset_type"><?php echo $l['w_type']; ?></label>
</span>
<span class="formw">
<?php
echo "<select name=\"tsubset_type\" id=\"tsubset_type\" size=\"0\" title=\"".$l['h_question_type']."\">\n";
echo "<option value=\"1\"";
if($tsubset_type == 1) {
	echo " selected=\"selected\"";
}
echo ">".$l['w_single_answer']."</option>\n";
echo "<option value=\"2\"";
if($tsubset_type == 2) {
	echo " selected=\"selected\"";
}
echo ">".$l['w_multiple_answers']."</option>\n";
echo "<option value=\"3\"";
if($tsubset_type == 3) {
	echo " selected=\"selected\"";
}
echo ">".$l['w_free_answer']."</option>\n";
echo "</select>\n";
?>
</span>
</div>

<div class="row">
<span class="label">
<label for="tsubset_type"><?php echo $l['w_question_difficulty']; ?></label>
</span>
<span class="formw">
<?php
echo "<select name=\"tsubset_difficulty\" id=\"tsubset_difficulty\" size=\"0\" title=\"".$l['h_question_difficulty']."\">\n";
for ($i=1; $i<=K_QUESTION_DIFFICULTY_LEVELS; $i++) {
	echo "<option value=\"".$i."\"";
	if($i == $tsubset_difficulty) {
		echo " selected=\"selected\"";
	}
	echo ">".$i."</option>\n";
}
echo "</select>\n";
?>
</span>
</div>

<div class="row">
<span class="label">
<label for="tsubset_answers"><?php echo $l['w_num_answers']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"text\" name=\"tsubset_answers\" id=\"tsubset_answers\" value=\"".$tsubset_answers."\" size=\"5\" maxlength=\"20\" title=\"".$l['h_num_answers']."\" />\n";
?>
</span>
</div>


<div class="row">
<span class="label">
&nbsp;
</span>
<span class="formw">
<?php
F_submit_button("addquestion", $l['w_add_questions'], $l['h_add_questions']);
?>
</span>
</div>

<div class="rowl" title="<?php echo $l['h_subjects']; ?>">
<br />
<div class="preview">
<?php
$test_max_score_new = 0; // test max score
$qtype = array("S", "M", "T"); // question types
$subjlist = "";
$sql = "SELECT * 
	FROM ".K_TABLE_TEST_SUBJSET."
	WHERE tsubset_test_id='".$test_id."'
	ORDER BY tsubset_id";
if($r = F_db_query($sql, $db)) {
	while($m = F_db_fetch_array($r)) {
		$subjlist .= "<li>";
		$subjects_list = "";
		$sqls = "SELECT subject_id,subject_name
			FROM ".K_TABLE_SUBJECTS.",".K_TABLE_SUBJECT_SET."
			WHERE subject_id=subjset_subject_id
				AND subjset_tsubset_id='".$m['tsubset_id']."'
			ORDER BY subject_name";
		if($rs = F_db_query($sqls, $db)) {
			while($ms = F_db_fetch_array($rs)) {
				$subjects_list .= "<a href=\"tce_edit_subject.php?subject_id=".$ms['subject_id']."\" title=\"".$l['t_subjects_editor']."\">".htmlspecialchars($ms['subject_name'], ENT_NOQUOTES, $l['a_meta_charset'])."</a>, ";
			}
		} else {
			F_display_db_error();
		}
		// remove last comma + space
		$subjlist .= substr($subjects_list,0,-2);
		$subjlist .= "<br />\n";
		$subjlist .= "<acronym class=\"offbox\" title=\"".$l['h_num_questions']."\">".$m['tsubset_quantity']."</acronym> ";
		$subjlist .= "<acronym class=\"offbox\" title=\"".$l['h_question_type']."\">".$qtype[($m['tsubset_type']-1)]."</acronym> ";
		$subjlist .= "<acronym class=\"offbox\" title=\"".$l['h_question_difficulty']."\">".$m['tsubset_difficulty']."</acronym> ";
		$subjlist .= "<acronym class=\"offbox\" title=\"".$l['h_num_answers']."\">".$m['tsubset_answers']."</acronym> ";
		$subjlist .= " <a href=\"".$_SERVER['SCRIPT_NAME']."?menu_mode=deletesubject&amp;test_id=".$test_id."&amp;tsubset_id=".$m['tsubset_id']."\" title=\"".$l['h_delete']."\" class=\"deletebutton\">".$l['w_delete']."</a>";
		$subjlist .= "</li>\n";
		
		// update test_max_score
		$test_max_score_new += $test_score_right * $m['tsubset_difficulty'] * $m['tsubset_quantity'];
		if (isset($test_max_score) AND ($test_max_score_new != $test_max_score)) {
			$test_max_score = $test_max_score_new;
			// update max score on test table
			$sqlup = "UPDATE ".K_TABLE_TESTS." SET 
				test_max_score=".$test_max_score."
				WHERE test_id=".$test_id."";
			if(!$rup = F_db_query($sqlup, $db)) {
				F_display_db_error(false);
			}
		}
	}
	if (strlen($subjlist) > 0) {
		echo "<ul>\n".$subjlist."</ul>\n";
	}
} else {
	F_display_db_error();
}
?>
&nbsp;
<?php
echo $l['w_max_score'].": ".$test_max_score_new;
?>
</div>
<br /><br />
</div>

</fieldset>

<div class="row"><br /></div>

<?php
	if (isset($test_max_score_new) and ($test_max_score_new > 0)) {
?>
<div class="row">
<span class="label">
<label for="test_num"><?php echo $l['w_pdf_offline_test']; ?></label>
</span>
<span class="formw">
<input type="text" name="test_num" id="test_num" value="<?php echo $test_num; ?>" size="4" maxlength="10" title="<?php echo $l['h_pdf_offline_test']; ?>" />
<?php
echo "<a href=\"tce_pdf_testgen.php?testid=".$test_id."&amp;num=".$test_num."\" title=\"".$l['h_pdf_offline_test']."\" class=\"xmlbutton\" onclick=\"pdfWindow=window.open('tce_pdf_testgen.php?testid=".$test_id."&amp;num=' + document.getElementById('form_testeditor').test_num.value + '','pdfWindow','dependent,menubar=yes,resizable=yes,scrollbars=yes,status=yes,toolbar=yes'); return false;\">".$l['w_generate']."</a>";
?>
</span>
&nbsp;
</div>

<?php
	}
}
?>

</form>

</div>
<?php

echo "<div class=\"pagehelp\">".$l['hp_edit_test']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
