<?php
//============================================================+
// File name   : tce_edit_subject.php
// Begin       : 2004-04-26
// Last Update : 2006-09-30
// 
// Description : Display form to edit exam subject_id (topics).
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display form to edit exam subject_id (topics).
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-04-27
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_SUBJECTS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_subjects_editor'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../code/tce_functions_tcecode_editor.php');
require_once('../code/tce_functions_auth_sql.php');

// set default values
if(!isset($subject_enabled) OR (empty($subject_enabled))) {
	$subject_enabled = 0;
}

switch($menu_mode) {

	case "delete":{
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_SUBJECTS, "subject_id", $subject_id, "subject_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		F_stripslashes_formfields();
		// check if this record is used (test_log)
		if(!F_check_unique(K_TABLE_SUBJECT_SET, "subjset_subject_id=".$subject_id."")) {
			//this record will be only disabled and not deleted because it's used
			$sql = "UPDATE ".K_TABLE_SUBJECTS." SET 
				subject_enabled='0'
				WHERE subject_id=".$subject_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error();
			}
			F_print_error("WARNING", $l['m_disabled_vs_deleted']);
		}
		else {
			// ask confirmation
			F_print_error("WARNING", $l['m_delete_confirm']);
			?>
			<div class="confirmbox">
			<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_delete">
			<div>
			
			<input type="hidden" name="subject_id" id="subject_id" value="<?php echo $subject_id; ?>" />
			<input type="hidden" name="subject_name" id="subject_name" value="<?php echo htmlspecialchars($subject_name, ENT_COMPAT, $l['a_meta_charset']); ?>" />
			<?php 
			F_submit_button("forcedelete", $l['w_delete'], $l['h_delete']);
			F_submit_button("cancel", $l['w_cancel'], $l['h_cancel']);
			?>
			</div>
			</form>
			</div>
		<?php
		}
		break;
	}

	case "forcedelete":{
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_SUBJECTS, "subject_id", $subject_id, "subject_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		F_stripslashes_formfields();
		if($forcedelete == $l['w_delete']) { //check if delete button has been pushed (redundant check)
			$sql = "DELETE FROM ".K_TABLE_SUBJECTS." WHERE subject_id=".$subject_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {				
				$subject_id=FALSE;
				F_print_error("MESSAGE", $subject_name.": ".$l['m_deleted']);
			}
		}
		break;
	}

	case "update":{ // Update
		// check user's authorization
		if (!F_isAuthorizedUser(K_TABLE_SUBJECTS, "subject_id", $subject_id, "subject_user_id")) {
			F_print_error("ERROR", $l['m_authorization_denied']);
			break;
		}
		if($formstatus = F_check_form_fields()) {
			// check referential integrity (NOTE: mysql do not support "ON UPDATE" constraint)
			if(!F_check_unique(K_TABLE_SUBJECT_SET, "subjset_subject_id=".$subject_id."")) {
				F_print_error("WARNING", $l['m_update_restrict']);
				
				// enable or disable record
				$sql = "UPDATE ".K_TABLE_SUBJECTS." SET 
					subject_enabled='".$subject_enabled."'
					WHERE subject_id=".$subject_id."";
				if(!$r = F_db_query($sql, $db)) {
					F_display_db_error(false);
				} else {
					$strmsg = $l['w_record_status'].": ";
					if ($subject_enabled) {
						$strmsg .= $l['w_enabled'];
					} else {
						$strmsg .= $l['w_disabled'];
					}
					F_print_error("MESSAGE", $strmsg);
				}
				
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			// check if name is unique
			if(!F_check_unique(K_TABLE_SUBJECTS, "subject_name='".$subject_name."'", "subject_id", $subject_id)) {
				F_print_error("WARNING", $l['m_duplicate_name']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			
			$sql = "UPDATE ".K_TABLE_SUBJECTS." SET 
				subject_name='".$subject_name."', 
				subject_description=".F_empty_to_null($subject_description).", 
				subject_enabled='".$subject_enabled."'
				WHERE subject_id=".$subject_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				F_print_error("MESSAGE", $l['m_updated']);
			}
		}
		break;
	}
	
	case "add":{ // Add
		if($formstatus = F_check_form_fields()) {
			// check if name is unique
			if(!F_check_unique(K_TABLE_SUBJECTS, "subject_name='".$subject_name."'")) {
				F_print_error("WARNING", $l['m_duplicate_name']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			
			$sql = "INSERT INTO ".K_TABLE_SUBJECTS." (
				subject_name, 
				subject_description, 
				subject_enabled,
				subject_user_id
				) VALUES (
				'".$subject_name."', 
				".F_empty_to_null($subject_description).", 
				'".$subject_enabled."',
				'".$_SESSION['session_user_id']."'
				)";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			}
			else {
				$subject_id = F_db_insert_id($db, K_TABLE_SUBJECTS, 'subject_id');
			}
		}
		break;
	}

	case "clear":{ // Clear form fields
		$subject_name = "";
		$subject_description = "";
		$subject_enabled = true;
		break;
	}

	default :{ 
		break;
	}

} //end of switch

// --- Initialize variables
if($formstatus) {
	if (($menu_mode != $l['w_clear']) AND ($menu_mode != unhtmlentities($l['w_clear']))) {
		if(!isset($subject_id) OR empty($subject_id)) {
			$sql = F_select_subjects_sql()." LIMIT 1";
		}
		else {
			$sql = "SELECT * 
				FROM ".K_TABLE_SUBJECTS."
				WHERE subject_id=".$subject_id."
				LIMIT 1";
		}
		if($r = F_db_query($sql, $db)) {
			if($m = F_db_fetch_array($r)) {
				$subject_id = $m['subject_id'];
				$subject_name = $m['subject_name'];
				$subject_description = $m['subject_description'];
				$subject_enabled = F_getBoolean($m['subject_enabled']);
			}
			else {
				$subject_name = "";
				$subject_description = "";
				$subject_enabled = true;
			}
		}
		else {
			F_display_db_error();
		}
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_subjecteditor">

<div class="row">
<span class="label">
<label for="subject_id"><?php echo $l['w_subject']; ?></label>
</span>
<span class="formw">
<select name="subject_id" id="subject_id" size="0" onchange="document.getElementById('form_subjecteditor').submit()" title="<?php echo $l['h_subject']; ?>">
<?php
$sql = F_select_subjects_sql();
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['subject_id']."\"";
		if($m['subject_id'] == $subject_id) {
			echo " selected=\"selected\"";
		}
		echo ">".$countitem.". ";
		if (F_getBoolean($m['subject_enabled'])) {
			echo "+";
		} else {
			echo "-";
		}
		echo " ".htmlspecialchars(F_remove_tcecode($m['subject_name']), ENT_NOQUOTES, $l['a_meta_charset'])."&nbsp;</option>\n";
		$countitem++;
	}
	if ($countitem == 1) {
		echo "<option value=\"0\">&nbsp;</option>\n";
	}
}
else {
	echo "</select></span></div>\n";
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row"><hr /></div>

<div class="row">
<span class="label">
<label for="subject_name"><?php echo $l['w_name']; ?></label>
</span>
<span class="formw">
<input type="text" name="subject_name" id="subject_name" value="<?php echo htmlspecialchars($subject_name, ENT_COMPAT, $l['a_meta_charset']); ?>" size="30" maxlength="255" title="<?php echo $l['h_subject_name']; ?>" />
</span>
</div>

<div class="row">
<span class="label">
<label for="subject_description"><?php echo $l['w_description']; ?></label>
<br />
<?php
echo "<a href=\"#\" title=\"".$l['h_preview']."\" class=\"xmlbutton\" onclick=\"previewWindow=window.open('tce_preview_tcecode.php?tcexamcode='+encodeURIComponent(document.getElementById('form_subjecteditor').subject_description.value),'previewWindow','dependent,height=500,width=500,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no'); return false;\">".$l['w_preview']."</a>";
?>
</span>
<span class="formw">
<textarea cols="30" rows="5" name="subject_description" id="subject_description" onselect="FJ_update_selection(document.getElementById('form_subjecteditor').subject_description)" title="<?php echo $l['h_subject_description']; ?>"><?php echo htmlspecialchars($subject_description, ENT_NOQUOTES, $l['a_meta_charset']); ?></textarea>
<br />
<?php echo tcecodeEditorTagButtons("form_subjecteditor", "subject_description"); ?>
</span>
</div>

<div class="row">
<span class="label">
<label for="subject_enabled"><?php echo $l['w_enabled']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"checkbox\" name=\"subject_enabled\" id=\"subject_enabled\" value=\"1\"";
if($subject_enabled) {echo " checked=\"checked\"";}
echo " title=\"".$l['h_enabled']."\" />";
?>
</span>
</div>

<div class="row">
<?php
// show buttons by case
if (isset($subject_id) AND ($subject_id > 0)) {
	F_submit_button("update", $l['w_update'], $l['h_update']);
	F_submit_button("delete", $l['w_delete'], $l['h_delete']);
}
F_submit_button("add", $l['w_add'], $l['h_add']);
F_submit_button("clear", $l['w_clear'], $l['h_clear']);
?>
</div>

<div class="row">
<span class="right">
<?php
if (isset($subject_id) AND ($subject_id > 0)) {
	echo "<a href=\"tce_edit_question.php?question_subject_id=".$subject_id."\" title=\"".$l['t_questions_editor']."\" class=\"xmlbutton\">".$l['t_questions_editor']." &gt;</a>";
}
?>
&nbsp;
</span>
&nbsp;
<!-- comma separated list of required fields -->
<input type="hidden" name="ff_required" id="ff_required" value="subject_name" />
<input type="hidden" name="ff_required_labels" id="ff_required_labels" value="<?php echo htmlspecialchars($l['w_name'], ENT_COMPAT, $l['a_meta_charset']); ?>" />

</div>

<div class="row"><hr /></div>

<div class="rowl" title="<?php echo $l['h_preview']; ?>">
<?php echo $l['w_preview']; ?>
<div class="preview">
<?php
echo F_decode_tcecode($subject_description);
?>
&nbsp;
</div>
</div>

</form>
</div>

<?php

echo "<div class=\"pagehelp\">".$l['hp_edit_subject']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');


//============================================================+
// END OF FILE                                                 
//============================================================+
?>
