<?php
//============================================================+
// File name   : tce_edit_answer.php
// Begin       : 2004-04-27
// Last Update : 2006-09-27
// 
// Description : Edit answers.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display form to edit exam answers.
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2004-04-27
 */

/**
 */

require_once('../config/tce_config.php');

$pagelevel = K_AUTH_ADMIN_ANSWERS;
require_once('../../shared/code/tce_authorization.php');

$thispage_title = $l['t_answers_editor'];
require_once('../code/tce_page_header.php');
require_once('../../shared/code/tce_functions_form.php');
require_once('../../shared/code/tce_functions_tcecode.php');
require_once('../code/tce_functions_tcecode_editor.php');
require_once('../code/tce_functions_auth_sql.php');

// set default values
if(!isset($answer_isright) OR (empty($answer_isright))) {
	$answer_isright = 0;
}
if(!isset($answer_enabled) OR (empty($answer_enabled))) {
	$answer_enabled = 0;
}
if (isset($selectcsubject)) {
	$changesubject = 1;
}
if (isset($selectcategory)) {
	$changecategory = 1;
}

$qtype = array("S","M","T"); // question types

switch($menu_mode) {

	case "delete":{
		F_stripslashes_formfields(); 
		// check if this record is used (test_log)
		if(!F_check_unique(K_TABLE_LOG_ANSWER, "logansw_answer_id=".$answer_id."")) {
			//this record will be only disabled and not deleted because it's used
			$sql = "UPDATE ".K_TABLE_ANSWERS." SET 
				answer_enabled='0'
				WHERE answer_id=".$answer_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error();
			}
			F_print_error("WARNING", $l['m_disabled_vs_deleted']);
		}
		else {
			// ask confirmation
			F_print_error("WARNING", $l['m_delete_confirm']);
			?>
			<div class="confirmbox">
			<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_delete">
			<div>
			
			<input type="hidden" name="answer_id" id="answer_id" value="<?php echo $answer_id; ?>" />
			<input type="hidden" name="question_subject_id" id="question_subject_id" value="<?php echo $question_subject_id; ?>" />
			<input type="hidden" name="answer_question_id" id="answer_question_id" value="<?php echo $answer_question_id; ?>" />
			<input type="hidden" name="answer_description" id="answer_description" value="<?php echo $answer_description; ?>" />
			<?php 
			F_submit_button("forcedelete", $l['w_delete'], $l['h_delete']);
			F_submit_button("cancel", $l['w_cancel'], $l['h_cancel']);
			?>
			</div>
			</form>
			</div>
		<?php
		}
		break;
	}

	case "forcedelete":{
		F_stripslashes_formfields(); // Delete
		if($forcedelete == $l['w_delete']) { //check if delete button has been pushed (redundant check)
			$sql = "DELETE FROM ".K_TABLE_ANSWERS." WHERE answer_id=".$answer_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				$answer_id=FALSE;
				F_print_error("MESSAGE", $l['m_deleted']);
			}
		}
		break;
	}

	case "update":{ // Update
		if($formstatus = F_check_form_fields()) {
			// check referential integrity (NOTE: mysql do not support "ON UPDATE" constraint)
			if(!F_check_unique(K_TABLE_LOG_ANSWER, "logansw_answer_id=".$answer_id."")) {
				F_print_error("WARNING", $l['m_update_restrict']);
				
				// enable or disable record
				$sql = "UPDATE ".K_TABLE_ANSWERS." SET 
					answer_enabled='".$answer_enabled."'
					WHERE answer_id=".$answer_id."";
				if(!$r = F_db_query($sql, $db)) {
					F_display_db_error(false);
				} else {
					$strmsg = $l['w_record_status'].": ";
					if ($answer_enabled) {
						$strmsg .= $l['w_enabled'];
					} else {
						$strmsg .= $l['w_disabled'];
					}
					F_print_error("MESSAGE", $strmsg);
				}
				
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			// check if alternate key is unique
			if(!F_check_unique(K_TABLE_ANSWERS, "answer_description='".$answer_description."' AND answer_question_id=".$answer_question_id."", "answer_id", $answer_id)) {
				F_print_error("WARNING", $l['m_duplicate_answer']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			
			$sql = "UPDATE ".K_TABLE_ANSWERS." SET 
				answer_question_id=".$answer_question_id.",
				answer_description='".$answer_description."',
				answer_isright='".$answer_isright."',
				answer_enabled='".$answer_enabled."'
				WHERE answer_id=".$answer_id."";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			} else {
				F_print_error("MESSAGE", $l['m_updated']);
			}
		}
		break;
	}

	case "add":{ // Add
		if($formstatus = F_check_form_fields()) {
			// check if alternate key is unique
			if(!F_check_unique(K_TABLE_ANSWERS, "answer_description='".$answer_description."' AND answer_question_id=".$answer_question_id."")) {
				F_print_error("WARNING", $l['m_duplicate_answer']);
				$formstatus = FALSE; F_stripslashes_formfields();
				break;
			}
			
			$sql = "INSERT INTO ".K_TABLE_ANSWERS." (
				answer_question_id,
				answer_description,
				answer_isright,
				answer_enabled
				) VALUES (
				".$answer_question_id.",
				'".$answer_description."',
				'".$answer_isright."',
				'".$answer_enabled."')";
			if(!$r = F_db_query($sql, $db)) {
				F_display_db_error(false);
			}
			else {
				$answer_id = F_db_insert_id($db, K_TABLE_ANSWERS, 'answer_id');
			}
		}
		break;
	}

	case "clear":{ // Clear form fields
		$answer_description = "";
		$answer_isright = false;
		$answer_enabled = true;
		break;
	}

	default :{ 
		break;
	}

} //end of switch


// select default subject (if not specified)
if(!(isset($question_subject_id) AND ($question_subject_id > 0))) {
	$sql = F_select_subjects_sql()." LIMIT 1";
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$question_subject_id = $m['subject_id'];
		} else {
			$question_subject_id = 0;
		}
	}
	else {
		F_display_db_error();
	}
}

// select default question (if not specified)
if ((isset($changesubject) AND ($changesubject > 0)) 
	OR (!(isset($answer_question_id) AND ($answer_question_id > 0)))) {
	$sql = "SELECT question_id 
		FROM ".K_TABLE_QUESTIONS." 
		WHERE question_subject_id=".$question_subject_id."
			AND question_type < 3
		ORDER BY question_description 
		LIMIT 1";
	if($r = F_db_query($sql, $db)) {
		if($m = F_db_fetch_array($r)) {
			$answer_question_id = $m['question_id'];
		} else {
			$answer_question_id = 0;
		}
	}
	else {
		F_display_db_error();
	}
}

// --- Initialize variables
if ($formstatus) {
	if (($menu_mode != $l['w_clear']) AND ($menu_mode != unhtmlentities($l['w_clear']))) {
		if ((isset($changesubject) AND ($changesubject > 0)) 
			OR (isset($changecategory) AND ($changecategory > 0)) 
			OR (!isset($answer_id)) OR empty($answer_id)) {
			$sql = "SELECT * 
				FROM ".K_TABLE_ANSWERS." 
				WHERE answer_question_id=".$answer_question_id." 
				ORDER BY answer_enabled DESC, answer_isright DESC, answer_description 
				LIMIT 1";
		}
		else {
			$sql = "SELECT * 
				FROM ".K_TABLE_ANSWERS." 
				WHERE answer_id=".$answer_id." 
				LIMIT 1";
		}
		if($r = F_db_query($sql, $db)) {
			if($m = F_db_fetch_array($r)) {
				$answer_id = $m['answer_id'];
				$answer_question_id = $m['answer_question_id'];
				$answer_description = $m['answer_description'];
				$answer_isright = F_getBoolean($m['answer_isright']);
				$answer_enabled = F_getBoolean($m['answer_enabled']);
			}
			else {
				$answer_description = "";
				$answer_isright = false;
				$answer_enabled = true;
			}
		}
		else {
			F_display_db_error();
		}
	}
}
?>

<div class="container">

<div class="tceformbox">
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data" id="form_answereditor">

<div class="row">
<span class="label">
<label for="question_subject_id"><?php echo $l['w_subject']; ?></label>
</span>
<span class="formw">
<input type="hidden" name="changesubject" id="changesubject" value="" />
<select name="question_subject_id" id="question_subject_id" size="0" onchange="document.getElementById('form_answereditor').changesubject.value=1; document.getElementById('form_answereditor').submit();" title="<?php echo $l['h_subject']; ?>">
<?php
$sql = F_select_subjects_sql()."";
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['subject_id']."\"";
		if($m['subject_id'] == $question_subject_id) {
			echo " selected=\"selected\"";
		}
		echo ">".$countitem.". ";
		if (F_getBoolean($m['subject_enabled'])) {
			echo "+";
		} else {
			echo "-";
		}
		echo " ".htmlspecialchars(F_remove_tcecode($m['subject_name']), ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
		$countitem++;
	}
	if ($countitem == 1) {
		echo "<option value=\"0\">&nbsp;</option>\n";
	}
}
else {
	echo "</select></span></div>\n";
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectcsubject" id="selectcsubject" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row">
<span class="label">
<label for="answer_question_id"><?php echo $l['w_question']; ?></label>
</span>
<span class="formw">
<input type="hidden" name="changecategory" id="changecategory" value="" />
<select name="answer_question_id" id="answer_question_id" size="0" onchange="document.getElementById('form_answereditor').changecategory.value=1; document.getElementById('form_answereditor').submit()" title="<?php echo $l['h_question']; ?>">
<?php
$sql = "SELECT * 
	FROM ".K_TABLE_QUESTIONS." 
	WHERE question_subject_id=".$question_subject_id."
		AND question_type < 3
	ORDER BY question_subject_id, question_description";
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['question_id']."\"";
		if($m['question_id'] == $answer_question_id) {
			echo " selected=\"selected\"";
		}
		echo ">".$countitem.". ";
		if (!F_getBoolean($m['question_enabled'])) {
			echo "-";
		} else {
			echo $qtype[($m['question_type'] - 1)];
		}
		echo " ".htmlspecialchars(F_substr_utf8(F_remove_tcecode($m['question_description']), 0, K_SELECT_SUBSTRING), ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
		$countitem++;
	}
	if ($countitem == 1) {
		echo "<option value=\"0\">&nbsp;</option>\n";
	}
}
else {
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectcategory" id="selectcategory" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row">
<span class="label">
<label for="answer_id"><?php echo $l['w_answer']; ?></label>
</span>
<span class="formw">
<select name="answer_id" id="answer_id" size="0" onchange="document.getElementById('form_answereditor').submit()" title="<?php echo $l['h_answer']; ?>">
<?php
$sql = "SELECT * 
	FROM ".K_TABLE_ANSWERS." 
	WHERE answer_question_id=".$answer_question_id." 
	ORDER BY answer_enabled DESC, answer_isright DESC, answer_description";
if($r = F_db_query($sql, $db)) {
	$countitem = 1;
	while($m = F_db_fetch_array($r)) {
		echo "<option value=\"".$m['answer_id']."\"";
		if($m['answer_id'] == $answer_id) {
			echo " selected=\"selected\"";
		}
		echo ">".$countitem.". ";
		if (!F_getBoolean($m['answer_enabled'])) {
			echo "-";
		} elseif (F_getBoolean($m['answer_isright'])) {
			echo "T";
		} else {
			echo "F";
		}
		echo " ".htmlspecialchars(F_substr_utf8(F_remove_tcecode($m['answer_description']), 0, K_SELECT_SUBSTRING), ENT_NOQUOTES, $l['a_meta_charset'])."</option>\n";
		$countitem++;
	}
	if ($countitem == 1) {
		echo "<option value=\"0\">&nbsp;</option>\n";
	}
}
else {
	F_display_db_error();
}
?>
</select>
</span>
</div>

<noscript>
<div class="row">
<span class="label">&nbsp;</span>
<span class="formw">
<input type="submit" name="selectrecord" id="selectrecord" value="<?php echo $l['w_select']; ?>" />
</span>
</div>
</noscript>

<div class="row"><hr /></div>

<div class="row">
<span class="label">
<label for="answer_description"><?php echo $l['w_answer']; ?></label>
<br />
<?php 
echo "<a href=\"#\" title=\"".$l['h_preview']."\" class=\"xmlbutton\" onclick=\"previewWindow=window.open('tce_preview_tcecode.php?tcexamcode='+encodeURIComponent(document.getElementById('form_answereditor').answer_description.value),'previewWindow','dependent,height=500,width=500,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no'); return false;\">".$l['w_preview']."</a>";
?>
</span>
<span class="formw">
<textarea cols="30" rows="5" name="answer_description" id="answer_description" onselect="FJ_update_selection(document.getElementById('form_answereditor').answer_description)" title="<?php echo $l['h_answer']; ?>"><?php echo htmlspecialchars($answer_description, ENT_NOQUOTES, $l['a_meta_charset']); ?></textarea>
<br />
<?php echo tcecodeEditorTagButtons("form_answereditor", "answer_description"); ?>
</span>
</div>

<div class="row">
<span class="label">
<label for="answer_isright"><?php echo $l['w_right']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"checkbox\" name=\"answer_isright\" id=\"answer_isright\" value=\"1\"";
if($answer_isright) {echo " checked=\"checked\"";}
echo " title=\"".$l['h_answer_isright']."\" />";
?>
</span>
</div>

<div class="row">
<span class="label">
<label for="answer_enabled"><?php echo $l['w_enabled']; ?></label>
</span>
<span class="formw">
<?php
echo "<input type=\"checkbox\" name=\"answer_enabled\" id=\"answer_enabled\" value=\"1\"";
if($answer_enabled) {echo " checked=\"checked\"";}
echo " title=\"".$l['h_enabled']."\" />";
?>
</span>
</div>

<div class="row">
<?php
// show buttons by case
if (isset($answer_id) AND ($answer_id > 0)) {
	F_submit_button("update", $l['w_update'], $l['h_update']);
	F_submit_button("delete", $l['w_delete'], $l['h_delete']);
}
F_submit_button("add", $l['w_add'], $l['h_add']);
F_submit_button("clear", $l['w_clear'], $l['h_clear']);
?>
</div>

<div class="row">
<span class="left">
&nbsp;
<?php
if (isset($answer_question_id) AND ($answer_question_id > 0)) {
	echo "<a href=\"tce_edit_question.php?question_id=".$answer_question_id."\" title=\"".$l['t_questions_editor']."\" class=\"xmlbutton\">&lt; ".$l['t_questions_editor']."</a>";
}
?>
</span>
&nbsp;
<!-- comma separated list of required fields -->
<input type="hidden" name="ff_required" id="ff_required" value="answer_description" />
<input type="hidden" name="ff_required_labels" id="ff_required_labels" value="<?php echo htmlspecialchars($l['w_description'], ENT_COMPAT, $l['a_meta_charset']); ?>" />

</div>

<div class="row"><hr /></div>

<div class="rowl" title="<?php echo $l['h_preview']; ?>">
<?php echo $l['w_preview']; ?>
<div class="preview">
<?php
echo F_decode_tcecode($answer_description);
?>
&nbsp;
</div>
</div>

</form>
</div>

<?php

echo "<div class=\"pagehelp\">".$l['hp_edit_answer']."</div>";
echo "</div>";

require_once('../code/tce_page_footer.php');

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
