<?php
//============================================================+
// File name   : tce_csv_users.php
// Begin       : 2006-03-30
// Last Update : 2006-09-29
// 
// Description : Functions to export users using CSV format.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display all users in CSV format.
 * (Tab Delimited Text File)
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-30
 */

// send headers

// fix for IE catching or PHP bug issue
header("Pragma: public");
// Date in the past
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
// always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header('Content-Description: TXT');
// force download dialog
header("Content-Type: application/force-download");
header("Content-Type: application/octet-stream", false);
header("Content-Type: application/download", false);
// use the Content-Disposition header to supply a recommended filename and 
// force the browser to display the save dialog.
header("Content-Disposition: attachment; filename=tcexam_users_".date("YmdHis").".txt;");
/*
The Content-transfer-encoding header should be binary, since the file will be read 
directly from the disk and the raw bytes passed to the downloading computer.
The Content-length header is useful to set for downloads. The browser will be able to 
show a progress meter as a file downloads. The content-lenght can be determines by 
filesize function returns the size of a file. 
*/
header("Content-Transfer-Encoding: binary");

echo F_csv_export_users();

/**
 * Export all users to CSV grouped by users' groups.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-30
 * @return CSV data
 */
function F_csv_export_users() {
	global $l, $db;
	require_once('../config/tce_config.php');
	
	$csv = ""; // CSV data to be returned
	
	// print column names
	$csv .= ""."user_id";
	$csv .= "\t"."user_name";
	$csv .= "\t"."user_password";
	$csv .= "\t"."user_email";
	$csv .= "\t"."user_regdate";
	$csv .= "\t"."user_ip";
	$csv .= "\t"."user_firstname";
	$csv .= "\t"."user_lastname";
	$csv .= "\t"."user_birthdate";
	$csv .= "\t"."user_birthplace";
	$csv .= "\t"."user_regnumber";
	$csv .= "\t"."user_ssn";
	$csv .= "\t"."user_level";
	$csv .= "\t"."user_verifycode";
	$csv .= "\t"."user_groups";
	
	$sql = "SELECT * 
		FROM ".K_TABLE_USERS."
		ORDER BY user_lastname,user_firstname,user_name";
	if($r = F_db_query($sql, $db)) {
		while($m = F_db_fetch_array($r)) {
			$csv .= "\n".$m['user_id'];
			$csv .= "\t".$m['user_name'];
			$csv .= "\t"; // password cannot be exported because is encrypted
			$csv .= "\t".$m['user_email'];
			$csv .= "\t".$m['user_regdate'];
			$csv .= "\t".$m['user_ip'];
			$csv .= "\t".$m['user_firstname'];
			$csv .= "\t".$m['user_lastname'];
			$csv .= "\t".$m['user_birthdate'];
			$csv .= "\t".$m['user_birthplace'];
			$csv .= "\t".$m['user_regnumber'];
			$csv .= "\t".$m['user_ssn'];
			$csv .= "\t".$m['user_level'];
			$csv .= "\t".$m['user_verifycode'];
			$csv .= "\t";
			$grp = "";
			// comma separated list of user's groups
			$sqlg = "SELECT * 
				FROM ".K_TABLE_GROUPS.",".K_TABLE_USERGROUP."
				WHERE usrgrp_group_id=group_id
					AND usrgrp_user_id=".$m['user_id']."
				ORDER BY group_name";
			if($rg = F_db_query($sqlg, $db)) {
				while($mg = F_db_fetch_array($rg)) {
					$grp .= $mg['group_name'].",";
				}
			}
			else {
				F_display_db_error();
			}
			if (!empty($grp)) {
				// add user's groups removing last comma
				$csv .= substr($grp,0,-1);
			}
		}
	}
	else {
		F_display_db_error();
	}
	return $csv;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
